#if !defined(__SUBEVENTSAVEDATA_H__)
#define __SUBEVENTSAVEDATA_H__
//==============================================================================
/**
 * @file    SubEventSaveData.h
 * @brief   TuCxgpZ[uf[^̈
 * @author  tamada
 * @date    2012.09.28
 */
//==============================================================================

#include <gflib.h>
#include <pmlib.h>

#include "savedata/SaveDataInterface.h"

GFL_NAMESPACE_BEGIN(savedata)



//==============================================================================
/**
 * @class SubEventSaveData
 */
//==============================================================================
class SubEventSaveData : public SaveDataInterface
{
  GFL_FORBID_COPY_AND_ASSIGN(SubEventSaveData); //Rs[RXgN^{֎~

private:
  static const u32 MAGIC_NUMBER = 'SUBE';
  static const size_t DUEL_MANSION_WORK_SIZE = 40;
  static const int GYM_MAX = 8;
  static const int TEMOTI_POKEMAX = pml::PokeParty::MAX_MEMBERS;

  struct CoreData
  {
    ///Đ{ݗp
    u8 duel_mansion_work[ DUEL_MANSION_WORK_SIZE ];

    u32 dummy_fence1;

    ///W[_[폟̎莝L^
    u16 gym_win_monsno[GYM_MAX][TEMOTI_POKEMAX];

    u32 dummy_fence2;

    ///|PaCxgp
		u8	keepPokemon[ pml::pokepara::CoreParam::DATASIZE ];

    u32 dummy_fence3;

    ///|P̌Cxgp
		u8	tradeAfterPokemon[ pml::pokepara::CoreParam::DATASIZE ];

    u32 dummy_fence4;

    u8  reserved[ 160 ];

  } __attribute__((aligned(4)));
  
  /// ۂ̃Z[uf[^̈
  CoreData m_Data;

public:
  SubEventSaveData(void);
  virtual ~SubEventSaveData(void);

  //-----------------------------------------------------------------------------
  /**
   * @brief    ǂݍ񂾃f[^Zbg֐
   * @param    pData   擪̃|C^
   */
  //-----------------------------------------------------------------------------
  virtual void SetData(void* pData){ gfl::std::MemCopy(pData, reinterpret_cast<void*>(&m_Data), sizeof(CoreData)); };
  //-----------------------------------------------------------------------------
  /**
   * @brief    f[^̐擪|C^𓾂֐
   * @return   擪̃|C^
   */
  //-----------------------------------------------------------------------------
  virtual void* GetData(void){ return reinterpret_cast<void*>(&m_Data); };
  //-----------------------------------------------------------------------------
  /**
   * @brief    f[^TCY
   * @retval   oCg
   */
  //-----------------------------------------------------------------------------
  virtual size_t GetDataSize(void){ return sizeof(CoreData); };

  //-----------------------------------------------------------------------------
  /**
   * @brief Z[uf[^̃NA
   * @param heap@NAɎgpe|q[v
   */
  //-----------------------------------------------------------------------------
  virtual void Clear( gfl::heap::HeapBase * heap ) { Initialize(); };

private:
  void Initialize( void );

};  // end of class SubEventSaveData




GFL_NAMESPACE_END(savedata)

#endif  // __SUBEVENTSAVEDATA_H__
