//==============================================================================
/**
 * @file	  PokeDiarySaveData.h
 * @brief   |P_CA[pZ[uf[^
 * @date    2012.09.28
 * @author  tamada
 */
// =============================================================================

#if !defined( __POKEDIARYSAVEDATA_H__ )
#define	__POKEDIARYSAVEDATA_H__

#include <gflib.h>
#include <savedata/SaveDataInterface.h>

GFL_NAMESPACE_BEGIN(savedata)

class PokeDiarySaveData : public SaveDataInterface
{
  GFL_FORBID_COPY_AND_ASSIGN(PokeDiarySaveData);

public:
  // RXgN^
  PokeDiarySaveData( void );
  // fXgN^
  virtual ~PokeDiarySaveData( void );

public:
	// SaveDataInterface
  //--------------------------------------------------------------------------
	/**
	 * @brief		ǂݍ񂾃f[^Zbg֐
	 * @param		pData		擪̃|C^
	 */
	//--------------------------------------------------------------------------
  virtual void SetData(void* data);
  //--------------------------------------------------------------------------
	/**
   * @brief    f[^̐擪|C^𓾂֐
   * @return   擪̃|C^
	 */
	//--------------------------------------------------------------------------
  virtual void* GetData(void);
  //--------------------------------------------------------------------------
	/**
   * @brief    f[^TCY
   * @retval   oCg
	 */
	//--------------------------------------------------------------------------
  virtual size_t GetDataSize(void);
  //--------------------------------------------------------------------------
	/**
   * @brief Z[uf[^̃NA
   * @param heap@NAɎgpe|q[v
	 */
	//--------------------------------------------------------------------------
  virtual void Clear( gfl::heap::HeapBase * heap ); 

public:
  enum DiaryType {
    DIARYTYPE_PERSONAL,
    DIARYTYPE_LIVE,
    DIARYTYPE_COUNT,
  };

private:
  enum {
    DIARYTYPE_PERSONAL_MAX  = 30,
    DIARYTYPE_LIVE_MAX = 10,
    DIARYTYPE_COUNT_MAX = 50,
  };

  struct DIARY_FASHION_DATA
  {
    u8 dummy[16];
  } __attribute__((aligned(4)));

  struct DIARY_DATA
  {
    u16 rom_code:6;     /**< f[^̃o[W*/
    u16 diary_type:2;   /**< _CA[*/
    u16 diary_id:8;     /**< _CA[IDiʓށj*/
    u16 data[3];        /**< ŗLf[^ */
    u32 date;           /**< t */
  };


  //-------------------------------------
  ///	Z[uf[^
  //=====================================
	struct CoreData
	{
    DIARY_DATA DiaryPersonalData[ DIARYTYPE_PERSONAL_MAX ];
    DIARY_DATA DiaryLiveData[ DIARYTYPE_LIVE_MAX ];
    DIARY_DATA DiaryCountData[ DIARYTYPE_COUNT_MAX ];

    DIARY_FASHION_DATA DiaryFashion[ DIARYTYPE_PERSONAL_MAX ];
	};

	CoreData m_data;
};


GFL_NAMESPACE_END(savedata)

#endif	/* __POKEDIARYSAVEDATA_H__ */

