//=============================================================================
/**
 *
 *  @file   ScriptToolPokeDex.h
 *  @brief  }Ӄf[^ANZT
 *          p\RʂƃXNvǧďoL
 *  @author masanori funakoshi
 *  @data   2012.09.25
 *
 */
//=============================================================================
#ifndef __SCRIPTTOOLPOKEDEX_H__
#define __SCRIPTTOOLPOKEDEX_H__


#include <gflib.h>

#include "message/script/msg_hyouka_scr.h"


GFL_NAMESPACE_BEGIN( field )
GFL_NAMESPACE_BEGIN(script);


class ScriptToolPokeDex
{
  GFL_FORBID_COPY_AND_ASSIGN( ScriptToolPokeDex );

// defines
public :
  enum tagIdentifier
  {
    CommandBufferMax = 32 // 8 * 32 = 256 byte(s)
  };

  //! ȈՃXNvgR}hQ
  enum CommandId
  {
    COMMAND_NULL,         // I[R}h

    COMMAND_NOP,          // no operation

    COMMAND_CONTINUE,     // XNvg̃[v
    COMMAND_BREAK,        // XNvg̏I

    COMMAND_MESSAGE,      // bZ[W`
    COMMAND_MESSAGE_WAIT, // bZ[WI҂
    COMMAND_WAIT_MARK,    // `aL[҂wx
    COMMAND_WAIT_LAST,    // ŏIL[҂
    COMMAND_CLOSE,        // bZ[W

    COMMAND_SELECT,       // }ӑI(dummy)

    COMMAND_WORD_SET_NUM, // lWordSet

    COMMAND_ITEM_ADD,     // ACeǉ(tB[ĥݗL)

    COMMAND_ME_PLAY,      // MEĐ
    COMMAND_ME_WAIT,      // ME҂

    COMMAND_MAX
  };

  //! R}hAo[yA
  typedef struct tagCommandData
  {
    u16 id;    ///< see enum CommandId
    u16 param; ///< slotNo(WORD_SET_NUM)
    u32 value; ///< 0 or messageId(MESSAGE) or soundId(ME_PLAY or ME_WAIT) or number(WORD_SET_NUM)
  } CommandData;

// methods
public :
  explicit ScriptToolPokeDex( gfl::heap::HeapBase* heap, gamesystem::GameManager *gameManager, bool is_pc_mode = true ); ///< RXgN^
  ~ScriptToolPokeDex(); ///< fXgN^

  /**
   *  @brief  }ӕ]̐
   *  - vpeBɃANZXOɎs
   */
  int  Evalute        ( poke_tool::ExtendData::LocalArea area = poke_tool::ExtendData::LOCAL_AREA_NONE );

  /**
   *  @brief  }ӕ]̐
   *  - v^[km̏bɋݍނ߂̐p֐
   */
  int  Evalute1st     ();

  //! SĂ̐}ӂς݂H
  bool IsCompleteAll  ( bool makeCommands = false );

  //! n}ӂς݂H
  bool IsCompleteLocal();

  //! S}ӂς݂H
  bool IsCompleteWorld();

  //! w̐}ӂς݂H
  bool IsComplete     ( poke_tool::ExtendData::LocalArea area = poke_tool::ExtendData::LOCAL_AREA_NONE );

  //! w肵}ӂ̕ߊlJEg擾
  u16  GetPokeGetCount( poke_tool::ExtendData::LocalArea area = poke_tool::ExtendData::LOCAL_AREA_NONE );

  //! w肵}ӂ݂̂JEg擾
  u16  GetPokeSeeCount( poke_tool::ExtendData::LocalArea area = poke_tool::ExtendData::LOCAL_AREA_NONE );

  //! R}hobt@̃NA
  void ClearCommands();

  //! R}h̔s
  void AppendCommand( u16 id, u16 param = 0, u32 vallue = 0);

private :
  bool flagGet( u16 flag_no );
  void flagSet( u16 flag_no, bool value = true );
  void flagRes( u16 flag_no );

  int  localCountToRank( u16 count );   ///< n}ӂ́w݂x}ӃN擾
  int  worldCountToRank( u16 count );   ///< S}ӂ́wߊlx}ӃN擾

  int  worldRankToMeOffset( int rank ); ///< S}ӂ̃NMEZo

// properties
private :
  inline bool isEvaluted() const { return m_isEvaluted; }

public :
  //! }ӕ]𑱂邩H
  inline bool IsContinue() const
  {
    GFL_ASSERT( isEvaluted() == true );
    return  m_isContinue;
  }

  //! }ӕ]I邩H
  inline bool IsBreak() const
  {
    GFL_ASSERT( isEvaluted() == true );
    return ( IsContinue() == false );
  }

  //! ]N̎擾
  inline int GetRank() const
  {
    GFL_ASSERT( isEvaluted() == true );
    return m_rank;
  }

  //! MEԍ̎擾
  inline int GetMENo() const
  {
    GFL_ASSERT( isEvaluted() == true );
    return m_meNo;
  }

  inline int GetCommandCount() const
  {
    GFL_ASSERT( isEvaluted() == true );
    return m_commandCount;
  }

  inline const CommandData *GetCommandAt( int index ) const
  {
    GFL_ASSERT( isEvaluted() == true );
    if ( index >= m_commandCount )
    {
      return NULL;
    }
    if ( m_commands[ index ].id == COMMAND_NULL )
    {
      return NULL;
    }
    return &m_commands[ index ];
  }

// fields
private :
  gamesystem::GameManager* m_gameManager;
  savedata::ZukanData*     m_zukanData;
  EventWork*               m_eventWork;

  poke_tool::ExtendData*   m_extend;

  bool m_isPcMode;   ///< ďo

  bool m_isEvaluted; ///< ]ς݂H
  bool m_isContinue; ///< 𑱂邩H

  int  m_rank;       ///< ]N
  int  m_meNo;       ///< 炷ME

  int         m_commandCount;                 ///< sR}h
  CommandData m_commands[ CommandBufferMax ]; ///< sR}hQ
};


GFL_NAMESPACE_END( script )
GFL_NAMESPACE_END( field )

  
#endif // __SCRIPTTOOLPOKEDEX_H__
