//=============================================================================
/**
 *
 *  @file   ScriptToolPokeDex.cpp
 *  @brief  }Ӄf[^ANZT
 *          p\RʂƃXNvǧďoL
 *  @author masanori funakoshi
 *  @data   2012.09.25
 *
 */
//=============================================================================


#include "ScriptToolPokeDex.h"

#include "pml_Item.h"
#include "field/flag_define.h"


GFL_NAMESPACE_BEGIN( field )
GFL_NAMESPACE_BEGIN( script )


//--------------------------------------------------------------
//! RXgN^
//--------------------------------------------------------------
ScriptToolPokeDex::ScriptToolPokeDex( gfl::heap::HeapBase* heap, gamesystem::GameManager *gameManager, bool is_pc_mode ) :
  m_isPcMode( is_pc_mode ),
  m_isEvaluted( false )
{
  m_gameManager = gameManager;
  m_zukanData   = gameManager->GetGameData()->GetZukanData();
  m_eventWork   = gameManager->GetGameData()->GetEventWork();

  m_extend = GFL_NEW( heap ) poke_tool::ExtendData( heap );
  m_extend->Load( heap );

  ClearCommands();
}

//--------------------------------------------------------------
//! fXgN^
//--------------------------------------------------------------
ScriptToolPokeDex::~ScriptToolPokeDex()
{
  GFL_SAFE_DELETE( m_extend );
}

//--------------------------------------------------------------
/**
 *  @brief   }ӕ]̐
 *
 *  - vpeBɃANZXOɎs
 *  - XNvgAAvɑΉ邽߁AŒ蒷̃R}hXg𐶐
 *  - sȈՃXNvgGWKv͂邪̗邱Ƃł
 *
 *  @param   [in]  area  nAȂ̏ꍇSƂĈ
 *  @return  ς񂾃R}hԂ
 */
//--------------------------------------------------------------
int ScriptToolPokeDex::Evalute( poke_tool::ExtendData::LocalArea area /* = LOACEL_AREA_NONE */ )
{
  static const struct
  {
    // messageId͎p16bitΏ[
    u16 evalId;   // ]p     messageId
    u16 adviceId; // AhoCX messageId
    u16 compId;   // Rv messageId
    u16 compedId; // Rvς messageId
    u16 compFlag; // Rvς݃tO
  } table_[] = {
    { msg_hyouka_hakase1_hei_eval,   msg_hyouka_hei01, msg_hyouka_hakase1_hei_comp, msg_hyouka_hei08, SYS_FLAG_ZUKAN_HEI_COMP },
    { msg_hyouka_hakase1_kai_eval,   msg_hyouka_kai01, msg_hyouka_hakase1_kai_comp, msg_hyouka_kai08, SYS_FLAG_ZUKAN_KAI_COMP },
    { msg_hyouka_hakase1_san_eval,   msg_hyouka_san01, msg_hyouka_hakase1_san_comp, msg_hyouka_san08, SYS_FLAG_ZUKAN_SAN_COMP },
    { msg_hyouka_hakase1_zen_eval00, msg_hyouka_zen01, msg_hyouka_hakase1_zen_comp, msg_hyouka_zen20, SYS_FLAG_ZUKAN_ZEN_COMP },
  };

  int index;    // areaZoCfbNX

  u16 count;    // w݂x́wߊlx
  int rank;     // countZo}ӃN

  int meNo;

  // R}h̃NA
  ClearCommands();

  // GAtable_[]т
  switch ( area )
  {
  case poke_tool::ExtendData::LOCAL_AREA_A    : index = 0; break; // 
  case poke_tool::ExtendData::LOCAL_AREA_B    : index = 1; break; // C
  case poke_tool::ExtendData::LOCAL_AREA_C    : index = 2; break; // Rx
  case poke_tool::ExtendData::LOCAL_AREA_NONE : index = 3; break; // S()
  }

  if ( flagGet( table_[ index ].compFlag ) == true )
  {
    AppendCommand( COMMAND_MESSAGE, 1, table_[ index ].compedId );   // ς
    AppendCommand( COMMAND_MESSAGE_WAIT );                           // bZ[WI[҂
    AppendCommand( COMMAND_WAIT_MARK );                              // 
  }
  else
  {
    if ( ( index >= 0 ) && ( index <= 2 ) )
    {
      count = GetPokeSeeCount( area );
      rank  = localCountToRank( count );

      AppendCommand( COMMAND_WORD_SET_NUM, 0, count );               // ݂ݒ
      AppendCommand( COMMAND_MESSAGE, 1, table_[ index ].evalId );   // JX ~~~~Łc
      AppendCommand( COMMAND_MESSAGE_WAIT );                         // bZ[WI[҂
      AppendCommand( COMMAND_ME_PLAY, 0, STRM_ME_HYOUKA01 + rank );  // MEĐ
      AppendCommand( COMMAND_ME_WAIT, 0, STRM_ME_HYOUKA01 + rank );  // ME҂
      AppendCommand( COMMAND_WAIT_MARK );                            // 

      if ( IsComplete( area ) == true )                              // ( rank == 7 ) 茘
      {
        // Rv
        AppendCommand( COMMAND_MESSAGE, 1, table_[ index ].compId ); // ΂炵
        AppendCommand( COMMAND_MESSAGE_WAIT );                       // bZ[WI[҂
        AppendCommand( COMMAND_WAIT_MARK );                          // 

        flagSet( table_[ index ].compFlag );                         // n} RvtOZbg
      }
      else
      {
        // w݂xŕ]
        AppendCommand( COMMAND_MESSAGE, 1, table_[index].adviceId + rank );   // ]bZ[W
        AppendCommand( COMMAND_MESSAGE_WAIT );                                // bZ[WI[҂
        AppendCommand( COMMAND_WAIT_MARK );                                   // 
      }
    }
    else
    {
      // S}ӕ]
      count = GetPokeGetCount();
      rank  = worldCountToRank( count );
      meNo  = STRM_ME_HYOUKA01 + worldRankToMeOffset( rank );

      AppendCommand( COMMAND_WORD_SET_NUM, 0, count );                        // S}ӂ̕ߊlݒ
      AppendCommand( COMMAND_MESSAGE, 1, table_[ index ].evalId );            // ܂ |Ṕc
      AppendCommand( COMMAND_MESSAGE_WAIT );                                  // bZ[WI[҂
      AppendCommand( COMMAND_ME_PLAY, 0, meNo );                              // MEĐ
      AppendCommand( COMMAND_ME_WAIT, 0, meNo );                              // ME҂
      AppendCommand( COMMAND_WAIT_MARK );                                     // 

      // n}ӂ̕ߊl]
      AppendCommand(                                                          // n}ӂ̕ߊlݒ
        COMMAND_WORD_SET_NUM,
        1, 
        GetPokeGetCount( poke_tool::ExtendData::LOCAL_AREA_A ) +
        GetPokeGetCount( poke_tool::ExtendData::LOCAL_AREA_B ) +
        GetPokeGetCount( poke_tool::ExtendData::LOCAL_AREA_C )
      );
      AppendCommand( COMMAND_MESSAGE, 1, table_[ index ].evalId + 1 );        // JXق ݂ ܂c
      AppendCommand( COMMAND_MESSAGE_WAIT );                                  // bZ[WI[҂
      AppendCommand( COMMAND_WAIT_MARK );                                     // 

      if ( IsCompleteLocal() == true )
      {
        // n}ӃRv[g
        AppendCommand( COMMAND_MESSAGE, 1, table_[ index ].evalId + 2 );      // ΂炵I
        AppendCommand( COMMAND_MESSAGE_WAIT );                                // bZ[WI[҂
        AppendCommand( COMMAND_WAIT_MARK );                                   // 
      }

      if ( IsCompleteWorld() == true )                                        // ( rank == 19 ) 茘
      {
        // S}ӃRv[g
        AppendCommand( COMMAND_MESSAGE, 1, table_[ index ].compId );          //  ܂ȁI
        AppendCommand( COMMAND_MESSAGE_WAIT );                                // bZ[WI[҂
        AppendCommand( COMMAND_WAIT_MARK );                                   // 

        flagSet( table_[ index ].compFlag );                                  // S}ӃRvtOZbg
      }
      else
      {
        // wߊlxŕ]
        AppendCommand( COMMAND_MESSAGE, 1, table_[ index ].adviceId + rank ); // ]bZ[W
        AppendCommand( COMMAND_MESSAGE_WAIT );                                // bZ[WI[҂
        AppendCommand( COMMAND_WAIT_MARK );                                   // 
      }
    }
  }

  // ܂`FbN
  if ( ( index >= 0 ) && ( index <= 2 ) )
  {
    if ( ( IsCompleteLocal() == true ) && ( flagGet( SYS_FLAG_MARUIOMAMORI ) == false ) )
    {
      // n}ӊAA܂邢܂O
      if ( m_isPcMode == true )
      {
        // PC̏ꍇ͗U
        AppendCommand( COMMAND_MESSAGE, 1, msg_hyouka_hakase1_item01 );   // 񂫂イ Ă
        AppendCommand( COMMAND_MESSAGE_WAIT );                            // bZ[WI[҂
        AppendCommand( COMMAND_WAIT_MARK );                               // 
      }
      else
      {
        // b̏ꍇ̓v[g
        AppendCommand( COMMAND_MESSAGE, 1, msg_hyouka_hakase1_item02 );   //  v[g
        AppendCommand( COMMAND_MESSAGE_WAIT );                            // bZ[WI[҂
        AppendCommand( COMMAND_WAIT_MARK );                               // 

        AppendCommand( COMMAND_ITEM_ADD, 0, ITEM_MARUIOMAMORI );          // ܂邢܂

        AppendCommand( COMMAND_MESSAGE, 1, msg_hyouka_hakase1_item03 );   // Ђ邨܂c
        AppendCommand( COMMAND_MESSAGE_WAIT );                            // bZ[WI[҂
        AppendCommand( COMMAND_WAIT_MARK );                               // 

        flagSet( SYS_FLAG_MARUIOMAMORI );                                 // tO̓hLgŗĂĂ
      }
    }
  }
  else
  {
    if ( ( IsCompleteWorld() == true ) && ( flagGet( SYS_FLAG_HIKARUOMAMORI ) == false ) )
    {
      // S}ӊAAЂ邨܂O
      if ( m_isPcMode == true )
      {
        // PC̏ꍇ͗U
        AppendCommand( COMMAND_MESSAGE, 1, msg_hyouka_hakase1_item01 );   // 񂫂イ Ă
        AppendCommand( COMMAND_MESSAGE_WAIT );                            // bZ[WI[҂
        AppendCommand( COMMAND_WAIT_MARK );                               // 
      }
      else
      {
        // b̏ꍇ̓v[g
        AppendCommand( COMMAND_MESSAGE, 1, msg_hyouka_hakase1_item02 );   //  v[g
        AppendCommand( COMMAND_MESSAGE_WAIT );                            // bZ[WI[҂
        AppendCommand( COMMAND_WAIT_MARK );                               // 

        AppendCommand( COMMAND_ITEM_ADD, 0, ITEM_HIKARUOMAMORI );         // Ђ邨܂

        AppendCommand( COMMAND_MESSAGE, 1, msg_hyouka_hakase1_item04 );   // Ђ邨܂c
        AppendCommand( COMMAND_MESSAGE_WAIT );                            // bZ[WI[҂
        AppendCommand( COMMAND_WAIT_MARK );                               // 

        flagSet( SYS_FLAG_HIKARUOMAMORI );                                // tO̓hLgŗĂĂ
      }
    }
  }

  AppendCommand( COMMAND_CLOSE );    // EBhEN[Y
  AppendCommand( COMMAND_CONTINUE ); // Iփ[v

  m_isEvaluted = true; // ]

  return m_commandCount;
}

//--------------------------------------------------------------
/**
 *  @brief   }ӕ]̐
 *
 *  - v^[km̏bɋݍނ߂̐p֐
 *  - Evalute()Q
 *
 *  @return  ς񂾃R}hԂ
 */
//--------------------------------------------------------------
int ScriptToolPokeDex::Evalute1st()
{
  u16 count;    // w݂x́wߊlx
  int rank;     // countZo}ӃN

  // R}h̃NA
  ClearCommands();

  /*
   *  n} ̕]쐬
   *  ̓V`G[V邽߁Aߑł̃R[hƂȂ
   */
  count = GetPokeSeeCount( poke_tool::ExtendData::LOCAL_AREA_A );
  rank  = localCountToRank( count );

  AppendCommand( COMMAND_WORD_SET_NUM, 0, count );                  // ݂ݒ
  AppendCommand( COMMAND_MESSAGE, 0, msg_hyouka_hakase1_hei_eval ); // JX ւŁc
  AppendCommand( COMMAND_MESSAGE_WAIT );                            // bZ[WI[҂
  AppendCommand( COMMAND_ME_PLAY, 0, STRM_ME_HYOUKA01 + rank );     // MEĐ
  AppendCommand( COMMAND_ME_WAIT, 0, STRM_ME_HYOUKA01 + rank );     // ME҂
  AppendCommand( COMMAND_WAIT_MARK );                               // 

  // w݂xŕ]
  AppendCommand( COMMAND_MESSAGE, 0, msg_hyouka_hei01 + rank );     // ]bZ[W
  AppendCommand( COMMAND_MESSAGE_WAIT );                            // bZ[WI[҂
  AppendCommand( COMMAND_WAIT_MARK );                               // 

  m_isEvaluted = true; // ]

  return m_commandCount;
}

//--------------------------------------------------------------
/**
 *  @brief   
 *  @param   
 *  @return  
 */
//--------------------------------------------------------------
bool ScriptToolPokeDex::IsComplete( poke_tool::ExtendData::LocalArea area /* = LOCAL_AREA_NONE */ )
{
  switch ( area )
  {
  case poke_tool::ExtendData::LOCAL_AREA_A : return m_zukanData->CheckLocalSeeComp( area, m_extend );
  case poke_tool::ExtendData::LOCAL_AREA_B : return m_zukanData->CheckLocalSeeComp( area, m_extend );
  case poke_tool::ExtendData::LOCAL_AREA_C : return m_zukanData->CheckLocalSeeComp( area, m_extend );
  default                                  : return m_zukanData->CheckZenkokuComp();
  }

  // return false;
}

//--------------------------------------------------------------
/**
 *  @brief   
 *  @param   
 *  @return  
 */
//--------------------------------------------------------------
bool ScriptToolPokeDex::IsCompleteLocal()
{
  return
     ( ( IsComplete( poke_tool::ExtendData::LOCAL_AREA_A ) == true )
   &&  ( IsComplete( poke_tool::ExtendData::LOCAL_AREA_B ) == true )
   &&  ( IsComplete( poke_tool::ExtendData::LOCAL_AREA_C ) == true ) );
}

//--------------------------------------------------------------
/**
 *  @brief   
 *  @param   
 *  @return  
 */
//--------------------------------------------------------------
bool ScriptToolPokeDex::IsCompleteWorld()
{
  return IsComplete();
}

//--------------------------------------------------------------
/**
 *  @brief   
 *  @param   
 *  @return  
 */
//--------------------------------------------------------------
bool ScriptToolPokeDex::IsCompleteAll( bool makeCommands /* = false */ )
{
  bool result = ( ( IsCompleteLocal() == true ) && ( IsCompleteWorld() == true ) );
 
  if ( makeCommands == true )
  {
    // R}h̃NA
    ClearCommands();
    if ( result == true )
    {
      // S}ӃRvR}h𔭍s
      AppendCommand( COMMAND_MESSAGE, 0, msg_hyouka_hakase1_all_comp ); // S}ӊς݃bZ[W
      AppendCommand( COMMAND_WAIT_LAST );                               // L[EFCg
      AppendCommand( COMMAND_CLOSE );                                   // EBhEN[Y
      AppendCommand( COMMAND_BREAK );                                   // bI
    }
  }

  return result;
}

//--------------------------------------------------------------
/**
 *  @brief   
 *  @param   
 *  @return  
 */
//--------------------------------------------------------------
u16 ScriptToolPokeDex::GetPokeGetCount( poke_tool::ExtendData::LocalArea area /* = LOCAL_AREA_NONE */ )
{
  switch ( area )
  {
  case poke_tool::ExtendData::LOCAL_AREA_A : return m_zukanData->GetLocalGetCompCount( area, m_extend );
  case poke_tool::ExtendData::LOCAL_AREA_B : return m_zukanData->GetLocalGetCompCount( area, m_extend );
  case poke_tool::ExtendData::LOCAL_AREA_C : return m_zukanData->GetLocalGetCompCount( area, m_extend );
  default                                  : return m_zukanData->GetZenkokuGetCompCount();
  }

  // return 0;
}

//--------------------------------------------------------------
/**
 *  @brief   
 *  @param   
 *  @return  
 */
//--------------------------------------------------------------
u16 ScriptToolPokeDex::GetPokeSeeCount( poke_tool::ExtendData::LocalArea area /* = LOCAL_AREA_NONE */ )
{
  switch ( area )
  {
  case poke_tool::ExtendData::LOCAL_AREA_A : return m_zukanData->GetLocalSeeCompCount( area, m_extend );
  case poke_tool::ExtendData::LOCAL_AREA_B : return m_zukanData->GetLocalSeeCompCount( area, m_extend );
  case poke_tool::ExtendData::LOCAL_AREA_C : return m_zukanData->GetLocalSeeCompCount( area, m_extend );
  default                                  : return m_zukanData->GetPokeSeeCount(); // ͓̎ɕKvȂ
  }

  // return 0;
}

//! R}hobt@̃NA
void ScriptToolPokeDex::ClearCommands()
{
  m_commandCount = 0;
  gfl::std::MemClear( &m_commands[ 0 ], sizeof( m_commands ) );
}

//! R}h̔s
void ScriptToolPokeDex::AppendCommand( u16 id, u16 param /* = 0 */, u32 value /* = 0 */)
{
  GFL_ASSERT( m_commandCount < CommandBufferMax );

  m_commands[ m_commandCount ].id    = id;
  m_commands[ m_commandCount ].param = param;
  m_commands[ m_commandCount ].value = value;
  m_commandCount += 1;
}

//============================================================================//
//  private methods
//============================================================================//

//----------------------------------------//
//! tO̎擾
//----------------------------------------//
bool ScriptToolPokeDex::flagGet( u16 flag_no )
{
  return m_eventWork->CheckEventFlag( flag_no );
}

//----------------------------------------//
//! tO̐ݒ
//----------------------------------------//
void ScriptToolPokeDex::flagSet( u16 flag_no, bool value /* = true */ )
{
  if ( value == true )
  {
    m_eventWork->SetEventFlag( flag_no );
  }
  else 
  {
    m_eventWork->ResetEventFlag( flag_no );
  }
}

//----------------------------------------//
//! tȌ
//----------------------------------------//
void ScriptToolPokeDex::flagRes( u16 flag_no )
{
  flagSet( flag_no, false );
}

//--------------------------------------------------------------
/**
 *  @brief  n}ӂ́w݂(or ߊl)x}ӃN擾
 *  @param  [in]  count  w݂x
 *  @return }ӃN 0-7
 */
//--------------------------------------------------------------
int ScriptToolPokeDex::localCountToRank( u16 count )
{
  static const u16 table_[ 8 ] = // ꉞeʂP`u16
  {
       19, //  0
       39, //  1
       59, //  2
       89, //  3
      109, //  4
      129, //  5
      149, //  6
    65535  //  7 ... ȏ㑝Ȃ炻\Ȃ
  };

  int i;

  for ( i = 0; i < GFL_NELEMS( table_ ); ++i )
  {
    if ( table_[i] >= count )
    {
      return i;
    }
  }

  return GFL_NELEMS( table_ ) - 1;
}

//--------------------------------------------------------------
/**
 *  @brief  S}ӂ́wߊl(or ݂)x}ӃN擾
 *  @param  [in]  count  wߊlx
 *  @return }ӃN 0-19
 */
//--------------------------------------------------------------
int ScriptToolPokeDex::worldCountToRank( u16 count )
{
  static const u16 table_[ 20 ] = // ꉞeʂP`u16
  {
       79, //  0
      149, //  1
      199, //  2
      249, //  3
      299, //  4
      349, //  5
      399, //  6
      449, //  7
      499, //  8
      529, //  9
      559, // 10
      589, // 11
      614, // 12
      634, // 13
      654, // 14
      674, // 15
      689, // 16
      699, // 17
      704, // 18
    65535  // 19 ... ȏ㑝Ȃ炻\Ȃ
  };

  int i;

  for ( i = 0; i < GFL_NELEMS( table_ ); ++i )
  {
    if ( table_[i] >= count )
    {
      return i;
    }
  }

  return GFL_NELEMS( table_ ) - 1;
}

//--------------------------------------------------------------
/**
 *  @brief  S}ӂ̃NMEZo
 *  @param  [in]  rank  S}ӂ̃N
 *  @return MEItZbg
 */
//--------------------------------------------------------------
int ScriptToolPokeDex::worldRankToMeOffset( int rank )
{
  static const u8 offset_[ 20 ] =
  {
//- 1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 16 17 18 19 20 -// 
    0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 5, 5, 6, 6, 7
  };

  return static_cast< int >( offset_[ rank ] );
}


GFL_NAMESPACE_END( script )
GFL_NAMESPACE_END( field )
