//=============================================================================
/**
 * @class   ScriptToolDueling.h
 * @brief   Đ{݃XNvgݒ
 * @date    2012.09.11
 * @author  masanori funakoshi
 */
//=============================================================================
#ifndef __SCRIPTTOOLDUELING_H__
#define __SCRIPTTOOLDUELING_H__

#include "field/FieldPawnTypes.h"


GFL_NAMESPACE_BEGIN(field);
GFL_NAMESPACE_BEGIN(script);


/**
 *  @class ScriptToolDueling
 *  @brief Đ{
 *  - XNvg剻߃lCeBuɈڐA
 */
class ScriptToolDueling
{
private :
  /*----------------------------------------*
   *  萔`
   *----------------------------------------*/
  /*!
   *  ėp萔
   *  const萔ŗǂ`̖ʓ|Ȃ
   */
  enum CommonDef
  {
    TRAINER_SLOT_MAX = 10, ///< zug[i[
  };

  //! ݈ʒ萔
  enum Rank
  {
    RANK_D = 0, ///< j
    RANK_C,     ///< q
    RANK_B,     ///< 
    RANK_A,     ///< 
    RANK_S,     ///< 

    RANK_MAX
  };

  //! [N`
  enum Flag
  {
    FLAG_RANK = 0, // @todo WK_OTHER_DUELING_RANK,                                  ///< ݈ʂƎ݈P
    FLAG_LAST_DATE,                                                     ///< ŏIzut
    FLAG_LAST_TIME,                                                     ///< ŏIzu
    FLAG_LAST_NO,                                                       ///< ŏIzug[i[No
    FLAG_INFO_ORG,                                                      ///< ő10l̔zu
    FLAG_BOOK_ORG   = FLAG_INFO_ORG +    TRAINER_SLOT_MAX,              ///< ő10l̔zu\(Zbg΍)
    FLAG_BOOK_QUEUE = FLAG_BOOK_ORG + ( (TRAINER_SLOT_MAX  + 1 ) / 2 ), ///< zu\L[݈̌ʒu

    FLAG_MAX
  };

  //! g[i[ʒu
  enum Post
  {
    POST_NONE = 0, // ݒ

    POST_A1,       // L
    POST_A2,
    POST_A3,
    POST_A4,
    POST_A5,
    POST_B1,       // .
    POST_B2,
    POST_C1,       // .
    POST_C2,
    POST_D1,       // .E
    POST_D2,
    POST_E1,       // L
    POST_E2,
    POST_E3,
    POST_E4,

    POST_MIN = POST_A1,
    POST_NUM = POST_E4,
    POST_MAX
  };

  //! g[i[[h
  enum TrainerMode
  {
    MODE_VANISH = 0, ///< ݂Ȃ
    MODE_IDLE,       ///< ΐ҂
    MODE_LOSE,       ///< vC[ɕ
    MODE_WIN,        ///< vC[ɏ

    MODE_MAX
  };

  //! g[i[
  enum TrainerType
  {
    TRAINER_TYPE_INVALID = 0,   ///< 

    TRAINER_TYPE_NORMAL,        ///< ʃg[i[
    TRAINER_TYPE_GYM_LEADER,    ///< W[_[
    TRAINER_TYPE_GYM_LEADER_EX, ///< W[_[Eς
    TRAINER_TYPE_BIG_FOUR,      ///< lV
    TRAINER_TYPE_CHAMPION,      ///< `sI

    TRAINER_TYPE_MAX
  };

  //! g[i[/݈
  enum TrainerNum
  {
    TRAINER_NUM_NORMAL_RANK_D = 14,
    TRAINER_NUM_NORMAL_RANK_C = 14,
    TRAINER_NUM_NORMAL_RANK_B = 14,
    TRAINER_NUM_NORMAL_RANK_A = 10,
    TRAINER_NUM_NORMAL_RANK_S = 10,

    TRAINER_NUM_GYM_LEADER    =  8,
    TRAINER_NUM_GYM_LEADER_EX =  8,
    TRAINER_NUM_BIG_FOUR      =  4,
    TRAINER_NUM_CHAMPION      =  1
  };

  enum TrainerIdx
  {
    TRAINER_IDX_DUMMY             = 0,

    TRAINER_IDX_NORMAL_RANK_D     = 1,
    TRAINER_IDX_NORMAL_RANK_C     = TRAINER_IDX_NORMAL_RANK_D + TRAINER_NUM_NORMAL_RANK_D,
    TRAINER_IDX_NORMAL_RANK_B     = TRAINER_IDX_NORMAL_RANK_C + TRAINER_NUM_NORMAL_RANK_C,
    TRAINER_IDX_NORMAL_RANK_A     = TRAINER_IDX_NORMAL_RANK_B + TRAINER_NUM_NORMAL_RANK_B,
    TRAINER_IDX_NORMAL_RANK_S     = TRAINER_IDX_NORMAL_RANK_A + TRAINER_NUM_NORMAL_RANK_A,
    TRAINER_IDX_NORMAL_MAX        = TRAINER_IDX_NORMAL_RANK_S + TRAINER_NUM_NORMAL_RANK_S,

    TRAINER_IDX_GYM_LEADER        = TRAINER_IDX_NORMAL_MAX,
    TRAINER_IDX_GYM_LEADER_MAX    = TRAINER_IDX_GYM_LEADER    + TRAINER_NUM_GYM_LEADER,

    TRAINER_IDX_GYM_LEADER_EX     = TRAINER_IDX_GYM_LEADER_MAX,
    TRAINER_IDX_GYM_LEADER_EX_MAX = TRAINER_IDX_GYM_LEADER_EX + TRAINER_NUM_GYM_LEADER_EX,

    TRAINER_IDX_BIG_FOUR          = TRAINER_IDX_GYM_LEADER_EX_MAX,
    TRAINER_IDX_BIG_FOUR_MAX      = TRAINER_IDX_BIG_FOUR      + TRAINER_NUM_BIG_FOUR,

    TRAINER_IDX_CHAMPION          = TRAINER_IDX_BIG_FOUR_MAX,
    TRAINER_IDX_CHAMPION_MAX      = TRAINER_IDX_CHAMPION      + TRAINER_NUM_CHAMPION,

    TRAINER_IDX_MAX               = TRAINER_IDX_CHAMPION_MAX
  };

  /*----------------------------------------*
   *  Z[uf[^`
   *
   *  {Ȃ̂Ńrbgk
   *----------------------------------------*/

  //! t
  typedef union tagDate
  {
    u16   value;
    struct
    {
      u16 year:7;  ///< N : 000-127 -> 2000-2127 (RTC͈͂2000-2099)
      u16 month:4; ///<  :   1- 12
      u16 day:5;   ///<  :   1- 31
    };
  } Date;

  //! ԏ
  typedef union tagTime
  {
    u16   value;
    struct
    {
      u16 hour:5;   ///<  : 00-23
      u16 minute:6; ///<  : 00-59
      u16 second:5; ///< b : 00-29(rbgȂߐx𗎂Ƃ)
    };
  } Time;

  //! ݈
  typedef union tagRankInfo
  {
    u16   value;
    struct
    {
      u16 no:4;     ///< ݈
      u16 point:12; ///< ݈P
    };
  } RankInfo;

  //! g[i[
  typedef union tagTrainerInfo
  {
    u16   value;  ///< Z[uf[^
    struct
    {
      u16 post:4; ///< zuĂꏊ(0-15)
      u16 mode:2; ///< (0 : A1 : ҋ@A2 : A3 : )
      u16 :2;
      u16 drop:1; ///< ACehbv
      u16 no:7;   ///< g[i[ԍ
    };
  } TrainerInfo;

  /**
   *  @brief \g[i[
   *  - ZbgɂĔzuŒ肷
   */
  typedef union tagTrainerBook
  {
    u16   value;  ///< Z[uf[^
    struct
    {
      u8  drop:1; ///< ACehbv
      u8  no:7;   ///< g[i[ԍ
    } data[2];
  } TrainerBook;

  //! \g[i[L[(CfbNX̂)
  typedef union tagTrainerQueue
  {
    u16   value; ///< Z[uf[^
    struct
    {
      s8  head;  ///< L[擪
      s8  tail;  ///< L[
    };
  } TrainerQueue;

  /*----------------------------------------*
   *  g[i[f[^`
   *----------------------------------------*/
  typedef struct tagTrainerData
  {
    u8  type;      ///< g[i[
    u8  rank;      ///< ݈
    u16 trId;      ///< g[i[ID
    u16 objCode;   ///< O
    u16 msgOrigin; ///< bZ[WJnԍ
    u8  dropProb;  ///< ACehbvm
    u16 dropItem;  ///< hbvACe
  } TrainerData;

// methods
public :
  explicit ScriptToolDueling( AMX *amx ) { m_amx = amx; }
  ~ScriptToolDueling() {}

  // ȉAXNvgR}hƂĎ
  u8   GetRank();              ///< ݈ʂ擾
  void SetRank( u8 value );    ///< ݈ʂݒ

  u16  GetRankP();             ///< ݈P̎擾
  void SetRankP( u32 value );  ///< ݈P̐ݒ

  int  Update(int threashold); ///< zu̍XV

  void LoadTrainerInfoAt( int slot, cell* ptr ); ///< Z[uf[^zu(0- 9)g[i[擾
  void SaveTrainerInfoAt( int slot, cell* ptr ); ///< Z[uf[^zu(0- 9)փg  [i[ۑ
  void PostToTrainerInfo( int post, cell* ptr ); ///< ꏊ(1-15)g[i[擾

  void ReadTrainerDataAt( int no,   cell* ptr ); ///< g[i[ԍg[i[f[^擾

  void Dump(); ///< _v

private :
  const TrainerData* TrainerDataAt( int no );

  bool FlagGet( u32 work_no );
  void FlagSet( u32 work_no, bool value );

  int  BadgeCount();          ///< obW(W[_[)̎擾

  u16  WorkGet( u32 work_no );
  void WorkSet( u32 work_no, u16  value );

  void AddRankP( u16 value ); ///< ݈P̉Z

  bool IsItemDrop();          ///< ACehbv邩H
  int  GetItemProb();         ///< ACehbv擾

  int  GetTrainerSlotMax();   ///< ݈ʂɂg[i[zu
  int  GetTrainerNoMax();     ///< ݈ʂɂzu\ȍőg[i[ԍ

  void RemoveTrainerOne();    ///< zug[i[P̏

  int  GetEmptySlotNo();      ///< zu\ȃg[i[ʒu
  int  GetEmptyPostNo();      ///< zu\ȃXbg擾

  u8   BookNoAt    ( int offset = 0 ); ///< \g[i[̎擾
  bool BookIsDropAt( int offset = 0 ); ///< \g[i[̃ACehbv擾

  u8   BookTake();       ///< \g[i[̉oƒǉ
  void BookAdd ();       ///< \g[i[̒ǉ
  void BookInvalidate(); ///< \g[i[̍V

  void dumpParam(); ///< ݈PȂǂ̃_v
  void dumpSlots(); ///< zug[i[̃_v
  void dumpBooks(); ///< \g[i[̃_v

// inlines
private :
  //! \g[i[L[̎擾
  inline u16 GetQueueValue()
  {
    return WorkGet( FLAG_BOOK_QUEUE );
  }

  //! \g[i[L[̐ݒ
  inline void SetQueueValue( u16 value )
  {
    WorkSet( FLAG_BOOK_QUEUE, value );
  }

  /* ͗eʃMM̐݌v̂߁ÅTO͂Ȃ
  //! \g[i[L[󂩁H
  inline bool IsQueueEmpty()
  {
    TrainerQueue queue;
    queue.value = GetQueueValue();
    return ( value.head == value.tail );
  }
  */

  //! \g[i[̎擾
  inline int GetQueueCount()
  {
    TrainerQueue queue;
    int          value;

    queue.value = GetQueueValue();
    value = queue.tail - queue.head;
    if (value < 0)
    {
      value += TRAINER_SLOT_MAX;
    }

    return value;
  }

  //! \g[i[L[̐擪Eړ
  inline s8 AddQueueIndex( s8 value, s8 add )
  {
    return ( value + add ) % TRAINER_SLOT_MAX;
  }

  //! \g[i[L[̐擪EXV
  inline s8 IncQueueIndex( s8 value )
  {
    return AddQueueIndex( value, 1 );
  }

  //! \g[i[L[擪̎擾
  inline s8 GetQueueHead()
  {
    TrainerQueue queue;
    queue.value = GetQueueValue();
    return queue.head;
  }

  //! \g[i[L[̎擾
  inline s8 GetQueueTail()
  {
    TrainerQueue queue;
    queue.value = GetQueueValue();
    return queue.tail;
  }

  //! \g[i[L[擪̕ۑ
  inline void SetQueueHead( s8 value )
  {
    TrainerQueue queue;
    queue.value = GetQueueValue();
    queue.head  = value;
    SetQueueValue( queue.value );
  }

  //! \g[i[L[̕ۑ
  inline void SetQueueTail( s8 value )
  {
    TrainerQueue queue;
    queue.value = GetQueueValue();
    queue.tail  = value;
    SetQueueValue( queue.value );
  }

/// fields
private :
  AMX *m_amx; ///< pawnIuWFNg
};


GFL_NAMESPACE_END(script);
GFL_NAMESPACE_END(field);


#endif // __SCRIPTTOOLDUELING_H__

