//=============================================================================
/**
 * @class   ScriptToolDueling.cpp
 * @brief   Đ{݃XNvgݒ
 * @date    2012.09.11
 * @author  masanori funakoshi
 */
//=============================================================================

#include <pmlib.h>

#include "field/movemodel/FieldObjCode.h"
#include "trainer/trid_def.h"

#include "ScriptToolDueling.h"

#include "message/msg_dueling_room.h"
#include "message/msg_dueling_trainer.h"


using namespace field::mmodel;
using namespace trainer;


GFL_NAMESPACE_BEGIN(field);
GFL_NAMESPACE_BEGIN(script);


/* -------------------------------------------------------------------------*/
/**
 *  @brief Đ{݃ZbgAbv
 *  @param [in]  threashold  ւԂ̂l
 *  @note  XNvg̔剻邽߃lBeBu
 */
/* -------------------------------------------------------------------------*/
int ScriptToolDueling::Update( int threashold )
{
  gfl::std::DateTime bef;
  gfl::std::DateTime now;
  Date               date;
  Time               time;
  s64                span;

  TrainerInfo        trInfo;
  const TrainerData *trData;
  int                slotMax;
  int                slot;
  int                post;
  bool               drop;
  int                no;
  int                i;

  no = TRAINER_IDX_DUMMY;

  gfl::std::DateTime::GetNow( &now );

  date.value = WorkGet( FLAG_LAST_DATE );
  time.value = WorkGet( FLAG_LAST_TIME );

  slotMax = GetTrainerSlotMax();  // ݈ʂɉőzul
  if ( date.value == 0 )
  {
    /*
     *  e[u쐬
     */

    // ꉞNݒ
    SetRank( RANK_D );

    // \g[i[̒ǉ
    for ( i = 0; i < slotMax; ++i )
    {
      BookAdd();
    }

    // g[i[̔zu
    for ( i = 0; i < slotMax; ++i )
    {
      trInfo.value = 0;
      trInfo.mode  = MODE_IDLE;
      trInfo.post  = GetEmptyPostNo();
      trInfo.drop  = BookIsDropAt() ? 1 : 0;
      trInfo.no    = BookTake(); // \L[XV

      trData = TrainerDataAt( trInfo.no );

      WorkSet( FLAG_INFO_ORG + i, trInfo.value );
    }
  }
  else
  {
    /*
     *  ԂɂXV
     */

    span = 0;

    if ( threashold > 0 ) // lzero͖l
    {
      // ۑĂԂ߂
      bef.SetYear  ( date.year + 2000 );
      bef.SetMonth ( date.month       );
      bef.SetDay   ( date.day         );
      bef.SetHour  ( time.hour        );
      bef.SetMinute( time.minute      );
      bef.SetSecond( time.second *  2 );

      span = now.GetDateTimeToSecond() - bef.GetDateTimeToSecond(); // oߕb
      if ( span < 0 )
      {
        span = 0;
      }
      span /= threashold; // ւԂŊAւlɕϊ

      /*
       *  ɏꍇA
       *  ւől𒴂ꍇAXVԂ݂ɁA
       *  łȂꍇAXVԂւl * threasholdɂ
       */

      if ( span >= slotMax )
      {
        span = slotMax; // ւől
      }

      // g[i[ւ
      for ( i = 0; i < span; ++i )
      {
        trInfo.value = 0;
        trInfo.mode  = MODE_IDLE;
        trInfo.post  = GetEmptyPostNo();
        trInfo.drop  = BookIsDropAt() ? 1 : 0;
        trInfo.no    = BookTake(); // \L[XV

        trData = TrainerDataAt( trInfo.no );

        RemoveTrainerOne(); // g[i[P̒Iď
        WorkSet( FLAG_INFO_ORG + GetEmptySlotNo(), trInfo.value ); // ɗ\g[i[ǉ

        no = trInfo.no;
      }
    }

    if ( span == 0)
    {
      return no; // ւȂȂ̂Œf
    }
  }

  // ԂXV
  date.year   = now.GetYear  () - 2000;
  date.month  = now.GetMonth ();
  date.day    = now.GetDay   ();
  time.hour   = now.GetHour  ();
  time.minute = now.GetMinute();
  time.second = now.GetSecond() / 2;

  WorkSet( FLAG_LAST_DATE, date.value );
  WorkSet( FLAG_LAST_TIME, time.value );

  return no;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief Z[uf[^zu(0- 9)g[i[擾
 */
/* -------------------------------------------------------------------------*/
void ScriptToolDueling::LoadTrainerInfoAt( int slot, cell* ptr )
{
  TrainerInfo info;

  GFL_ASSERT( ( slot >= 0 ) && ( slot < TRAINER_SLOT_MAX ) );

  info.value = WorkGet( FLAG_INFO_ORG + slot );

  ptr[ 0 ] = info.post;
  ptr[ 1 ] = info.mode;
  ptr[ 2 ] = info.drop;
  ptr[ 3 ] = info.no;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief Z[uf[^zu(0- 9)փg[i[ۑ
 */
/* -------------------------------------------------------------------------*/
void ScriptToolDueling::SaveTrainerInfoAt( int slot, cell* ptr )
{
  TrainerInfo info;

  GFL_ASSERT( ( slot >= 0 ) && ( slot < TRAINER_SLOT_MAX ) );

  info.value = 0;

  info.post = ptr[ 0 ];
  info.mode = ptr[ 1 ];
  info.drop = ptr[ 2 ];
  info.no   = ptr[ 3 ];

  WorkSet( FLAG_INFO_ORG + slot, info.value );
}

/* -------------------------------------------------------------------------*/
/**
 * @brief ꏊ(1-15)g[i[擾
 */
/* -------------------------------------------------------------------------*/
void ScriptToolDueling::PostToTrainerInfo( int post, cell* ptr )
{
  TrainerInfo info;
  int         i;

  GFL_ASSERT( ( post >= POST_A1 ) && ( post < POST_MAX ) );

  for ( i = 0; i < TRAINER_SLOT_MAX; ++i )
  {
    info.value = WorkGet( FLAG_INFO_ORG + i );
    if ( info.post == post )
    {
      ptr[ 0 ] = info.post;
      ptr[ 1 ] = info.mode;
      ptr[ 2 ] = info.drop;
      ptr[ 3 ] = info.no;
      return;
    }
  }

  ptr[ 0 ] = POST_NONE;
  ptr[ 1 ] = MODE_VANISH;
  ptr[ 2 ] = 0;
  ptr[ 3 ] = 0;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief g[i[ԍg[i[f[^擾
 */
/* -------------------------------------------------------------------------*/
void ScriptToolDueling::ReadTrainerDataAt( int no,  cell* ptr )
{
  const TrainerData* data = TrainerDataAt( no );

  ptr[ 0 ] = data->type;
  ptr[ 1 ] = data->rank;
  ptr[ 2 ] = data->trId;
  ptr[ 3 ] = data->objCode;
  ptr[ 4 ] = data->msgOrigin;
  ptr[ 5 ] = data->dropProb;
  ptr[ 6 ] = data->dropItem;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief _v
 */
/* -------------------------------------------------------------------------*/
void ScriptToolDueling::Dump()
{
  GFL_PRINT( "===== dump dueling\n" );
  dumpParam();
  dumpSlots();
  dumpBooks();
  GFL_PRINT( "dump dueling =====\n" );
}

/* -------------------------------------------------------------------------*/
/*
 *  private methods
 */
/* -------------------------------------------------------------------------*/

//----------------------------------------//
//! g[i[f[^̎擾
//----------------------------------------//
const ScriptToolDueling::TrainerData* ScriptToolDueling::TrainerDataAt( int no )
{
  /*
   *  g[i[e[u
   *
   *   u8  type;      : g[i[
   *   u8  rank;      : ݈
   *   u16 trId;      : g[i[ID
   *   u16 objCode;   : O
   *   u16 msgOrigin; : bZ[WJnԍ
   *   u8  dropProb;  : ACehbvm
   *   u16 dropItem;  : hbvACe
   *
   */
  const TrainerData table_[TRAINER_IDX_MAX] =
  {
    { TRAINER_TYPE_NORMAL,        RANK_D, TRID_NULL,         NONDRAW, 0, 0, 0 }, // dummy

    // j(14)
    { TRAINER_TYPE_NORMAL,        RANK_D, TRID_PRINCESS_02,  GIRL3,     mes_dueling_tr_001_01, 0, ITEM_HOSINOKAKERA   },
    { TRAINER_TYPE_NORMAL,        RANK_D, TRID_PRINCESS_03,  GIRL3,     mes_dueling_tr_002_01, 0, ITEM_HOSINOKAKERA   },
    { TRAINER_TYPE_NORMAL,        RANK_D, TRID_PRINCESS_04,  GIRL3,     mes_dueling_tr_003_01, 0, ITEM_HOSINOKAKERA   },
    { TRAINER_TYPE_NORMAL,        RANK_D, TRID_PRINCESS_05,  GIRL3,     mes_dueling_tr_004_01, 0, ITEM_HOSINOKAKERA   },
    { TRAINER_TYPE_NORMAL,        RANK_D, TRID_PRINCESS_06,  GIRL3,     mes_dueling_tr_005_01, 0, ITEM_HOSINOKAKERA   },
    { TRAINER_TYPE_NORMAL,        RANK_D, TRID_PRINCE_01,    BOY2,      mes_dueling_tr_006_01, 0, ITEM_HOSINOKAKERA   },
    { TRAINER_TYPE_NORMAL,        RANK_D, TRID_PRINCE_02,    BOY2,      mes_dueling_tr_007_01, 0, ITEM_HOSINOKAKERA   },
    { TRAINER_TYPE_NORMAL,        RANK_D, TRID_PRINCE_03,    BOY2,      mes_dueling_tr_008_01, 0, ITEM_HOSINOKAKERA   },
    { TRAINER_TYPE_NORMAL,        RANK_D, TRID_PRINCE_04,    BOY2,      mes_dueling_tr_009_01, 0, ITEM_HOSINOKAKERA   },
    { TRAINER_TYPE_NORMAL,        RANK_D, TRID_PRINCE_05,    BOY2,      mes_dueling_tr_010_01, 0, ITEM_HOSINOKAKERA   },
    { TRAINER_TYPE_NORMAL,        RANK_D, TRID_BUTLER_01,    BUTLER,    mes_dueling_tr_011_01, 0, ITEM_HOSINOKAKERA   },
    { TRAINER_TYPE_NORMAL,        RANK_D, TRID_MADAM_01,     LADY,      mes_dueling_tr_012_01, 0, ITEM_HOSINOKAKERA   },
    { TRAINER_TYPE_NORMAL,        RANK_D, TRID_GENTLE_01,    GENTLEMAN, mes_dueling_tr_013_01, 0, ITEM_HOSINOKAKERA   },
    { TRAINER_TYPE_NORMAL,        RANK_D, TRID_MAID_01,      MAID,      mes_dueling_tr_014_01, 0, ITEM_HOSINOKAKERA   },

    // q(14)
    { TRAINER_TYPE_NORMAL,        RANK_C, TRID_PRINCESS_07,  GIRL3,     mes_dueling_tr_015_01, 0, ITEM_HOSINOKAKERA   },
    { TRAINER_TYPE_NORMAL,        RANK_C, TRID_PRINCESS_08,  GIRL3,     mes_dueling_tr_016_01, 0, ITEM_KINNOTAMA      },
    { TRAINER_TYPE_NORMAL,        RANK_C, TRID_PRINCESS_09,  GIRL3,     mes_dueling_tr_017_01, 0, ITEM_KINNOTAMA      },
    { TRAINER_TYPE_NORMAL,        RANK_C, TRID_PRINCE_06,    BOY2,      mes_dueling_tr_018_01, 0, ITEM_HOSINOKAKERA   },
    { TRAINER_TYPE_NORMAL,        RANK_C, TRID_PRINCE_07,    BOY2,      mes_dueling_tr_019_01, 0, ITEM_KINNOTAMA      },
    { TRAINER_TYPE_NORMAL,        RANK_C, TRID_PRINCE_08,    BOY2,      mes_dueling_tr_020_01, 0, ITEM_KINNOTAMA      },
    { TRAINER_TYPE_NORMAL,        RANK_C, TRID_BUTLER_02,    BUTLER,    mes_dueling_tr_021_01, 0, ITEM_KINNOTAMA      },
    { TRAINER_TYPE_NORMAL,        RANK_C, TRID_MADAM_02,     LADY,      mes_dueling_tr_022_01, 0, ITEM_KINNOTAMA      },
    { TRAINER_TYPE_NORMAL,        RANK_C, TRID_MADAM_03,     LADY,      mes_dueling_tr_023_01, 0, ITEM_KINNOTAMA      },
    { TRAINER_TYPE_NORMAL,        RANK_C, TRID_MADAM_04,     LADY,      mes_dueling_tr_024_01, 0, ITEM_KINNOTAMA      },
    { TRAINER_TYPE_NORMAL,        RANK_C, TRID_GENTLE_02,    GENTLEMAN, mes_dueling_tr_025_01, 0, ITEM_KINNOTAMA      },
    { TRAINER_TYPE_NORMAL,        RANK_C, TRID_GENTLE_03,    GENTLEMAN, mes_dueling_tr_026_01, 0, ITEM_KINNOTAMA      },
    { TRAINER_TYPE_NORMAL,        RANK_C, TRID_GENTLE_04,    GENTLEMAN, mes_dueling_tr_027_01, 0, ITEM_KINNOTAMA      },
    { TRAINER_TYPE_NORMAL,        RANK_C, TRID_MAID_02,      MAID,      mes_dueling_tr_028_01, 0, ITEM_KINNOTAMA      },

    // (14)
    { TRAINER_TYPE_NORMAL,        RANK_B, TRID_PRINCESS_10,  GIRL3,     mes_dueling_tr_029_01, 0, ITEM_KINNOTAMA      },
    { TRAINER_TYPE_NORMAL,        RANK_B, TRID_PRINCE_09,    BOY2,      mes_dueling_tr_030_01, 0, ITEM_KINNOTAMA      },
    { TRAINER_TYPE_NORMAL,        RANK_B, TRID_BUTLER_03,    BUTLER,    mes_dueling_tr_031_01, 0, ITEM_ODANGOSINZYU   },
    { TRAINER_TYPE_NORMAL,        RANK_B, TRID_MADAM_05,     LADY,      mes_dueling_tr_032_01, 0, ITEM_ODANGOSINZYU   },
    { TRAINER_TYPE_NORMAL,        RANK_B, TRID_MADAM_06,     LADY,      mes_dueling_tr_033_01, 0, ITEM_ODANGOSINZYU   },
    { TRAINER_TYPE_NORMAL,        RANK_B, TRID_MADAM_07,     LADY,      mes_dueling_tr_034_01, 0, ITEM_ODANGOSINZYU   },
    { TRAINER_TYPE_NORMAL,        RANK_B, TRID_MADAM_08,     LADY,      mes_dueling_tr_035_01, 0, ITEM_ODANGOSINZYU   },
    { TRAINER_TYPE_NORMAL,        RANK_B, TRID_MADAM_09,     LADY,      mes_dueling_tr_036_01, 0, ITEM_ODANGOSINZYU   },
    { TRAINER_TYPE_NORMAL,        RANK_B, TRID_GENTLE_05,    GENTLEMAN, mes_dueling_tr_037_01, 0, ITEM_ODANGOSINZYU   },
    { TRAINER_TYPE_NORMAL,        RANK_B, TRID_GENTLE_06,    GENTLEMAN, mes_dueling_tr_038_01, 0, ITEM_ODANGOSINZYU   },
    { TRAINER_TYPE_NORMAL,        RANK_B, TRID_GENTLE_07,    GENTLEMAN, mes_dueling_tr_039_01, 0, ITEM_ODANGOSINZYU   },
    { TRAINER_TYPE_NORMAL,        RANK_B, TRID_GENTLE_08,    GENTLEMAN, mes_dueling_tr_040_01, 0, ITEM_ODANGOSINZYU   },
    { TRAINER_TYPE_NORMAL,        RANK_B, TRID_GENTLE_09,    GENTLEMAN, mes_dueling_tr_041_01, 0, ITEM_ODANGOSINZYU   },
    { TRAINER_TYPE_NORMAL,        RANK_B, TRID_MAID_03,      MAID,      mes_dueling_tr_042_01, 0, ITEM_ODANGOSINZYU   },

    // (10)
    { TRAINER_TYPE_NORMAL,        RANK_A, TRID_PRINCESS_11,  GIRL3,     mes_dueling_tr_043_01, 0, ITEM_KINNOTAMA      },
    { TRAINER_TYPE_NORMAL,        RANK_A, TRID_PRINCE_10,    BOY2,      mes_dueling_tr_044_01, 0, ITEM_KINNOTAMA      },
    { TRAINER_TYPE_NORMAL,        RANK_A, TRID_BUTLER_04,    BUTLER,    mes_dueling_tr_045_01, 0, ITEM_DEKAIKINNOTAMA },
    { TRAINER_TYPE_NORMAL,        RANK_A, TRID_MADAM_10,     LADY,      mes_dueling_tr_046_01, 0, ITEM_DEKAIKINNOTAMA },
    { TRAINER_TYPE_NORMAL,        RANK_A, TRID_GENTLE_10,    GENTLEMAN, mes_dueling_tr_047_01, 0, ITEM_DEKAIKINNOTAMA },
    { TRAINER_TYPE_NORMAL,        RANK_A, TRID_MAID_04,      MAID,      mes_dueling_tr_048_01, 0, ITEM_DEKAIKINNOTAMA },
    { TRAINER_TYPE_NORMAL,        RANK_A, TRID_KIMONO3_02,   KIMONO3,   mes_dueling_tr_049_01, 0, ITEM_DEKAIKINNOTAMA },
    { TRAINER_TYPE_NORMAL,        RANK_A, TRID_KIMONO4_02,   KIMONO4,   mes_dueling_tr_050_01, 0, ITEM_DEKAIKINNOTAMA },
    { TRAINER_TYPE_NORMAL,        RANK_A, TRID_KIMONO2_02,   KIMONO2,   mes_dueling_tr_051_01, 0, ITEM_DEKAIKINNOTAMA },
    { TRAINER_TYPE_NORMAL,        RANK_A, TRID_KIMONO1_02,   KIMONO1,   mes_dueling_tr_052_01, 0, ITEM_DEKAIKINNOTAMA },

    // (10)
    { TRAINER_TYPE_NORMAL,        RANK_S, TRID_PRINCESS_12,  GIRL3,     mes_dueling_tr_069_01, 0, ITEM_ODANGOSINZYU   },
    { TRAINER_TYPE_NORMAL,        RANK_S, TRID_PRINCE_11,    BOY2,      mes_dueling_tr_070_01, 0, ITEM_ODANGOSINZYU   },
    { TRAINER_TYPE_NORMAL,        RANK_S, TRID_BUTLER_05,    BUTLER,    mes_dueling_tr_071_01, 0, ITEM_SUISEINOKAKERA },
    { TRAINER_TYPE_NORMAL,        RANK_S, TRID_MADAM_11,     LADY,      mes_dueling_tr_072_01, 0, ITEM_DEKAIKINNOTAMA },
    { TRAINER_TYPE_NORMAL,        RANK_S, TRID_GENTLE_11,    GENTLEMAN, mes_dueling_tr_073_01, 0, ITEM_DEKAIKINNOTAMA },
    { TRAINER_TYPE_NORMAL,        RANK_S, TRID_MAID_05,      MAID,      mes_dueling_tr_074_01, 0, ITEM_SUISEINOKAKERA },
    { TRAINER_TYPE_NORMAL,        RANK_S, TRID_KIMONO3_03,   KIMONO3,   mes_dueling_tr_075_01, 0, ITEM_SUISEINOKAKERA },
    { TRAINER_TYPE_NORMAL,        RANK_S, TRID_KIMONO4_03,   KIMONO4,   mes_dueling_tr_076_01, 0, ITEM_SUISEINOKAKERA },
    { TRAINER_TYPE_NORMAL,        RANK_S, TRID_KIMONO2_03,   KIMONO2,   mes_dueling_tr_077_01, 0, ITEM_SUISEINOKAKERA },
    { TRAINER_TYPE_NORMAL,        RANK_S, TRID_KIMONO1_03,   KIMONO1,   mes_dueling_tr_078_01, 0, ITEM_SUISEINOKAKERA },

    // W[_[(8)
    { TRAINER_TYPE_GYM_LEADER,    RANK_S, TRID_XYLEADER1_02, LEADER1,   mes_dueling_tr_053_01, 0, ITEM_HUSIGINAAME    },
    { TRAINER_TYPE_GYM_LEADER,    RANK_S, TRID_XYLEADER2_02, LEADER2,   mes_dueling_tr_054_01, 0, ITEM_HUSIGINAAME    },
    { TRAINER_TYPE_GYM_LEADER,    RANK_S, TRID_XYLEADER3_03, LEADER3,   mes_dueling_tr_055_01, 0, ITEM_HUSIGINAAME    },
    { TRAINER_TYPE_GYM_LEADER,    RANK_S, TRID_XYLEADER4_02, LEADER4,   mes_dueling_tr_056_01, 0, ITEM_HUSIGINAAME    },
    { TRAINER_TYPE_GYM_LEADER,    RANK_S, TRID_XYLEADER5_02, LEADER5,   mes_dueling_tr_057_01, 0, ITEM_HUSIGINAAME    },
    { TRAINER_TYPE_GYM_LEADER,    RANK_S, TRID_XYLEADER6_02, LEADER6,   mes_dueling_tr_058_01, 0, ITEM_HUSIGINAAME    },
    { TRAINER_TYPE_GYM_LEADER,    RANK_S, TRID_XYLEADER7_02, LEADER7,   mes_dueling_tr_059_01, 0, ITEM_HUSIGINAAME    },
    { TRAINER_TYPE_GYM_LEADER,    RANK_S, TRID_XYLEADER8_02, LEADER8,   mes_dueling_tr_060_01, 0, ITEM_HUSIGINAAME    },

    // W[_[(8)
    { TRAINER_TYPE_GYM_LEADER_EX, RANK_S, TRID_XYLEADER1_03, LEADER1,   mes_dueling_tr_061_01, 0, ITEM_HUSIGINAAME    },
    { TRAINER_TYPE_GYM_LEADER_EX, RANK_S, TRID_XYLEADER2_03, LEADER2,   mes_dueling_tr_062_01, 0, ITEM_HUSIGINAAME    },
    { TRAINER_TYPE_GYM_LEADER_EX, RANK_S, TRID_XYLEADER3_04, LEADER3,   mes_dueling_tr_063_01, 0, ITEM_HUSIGINAAME    },
    { TRAINER_TYPE_GYM_LEADER_EX, RANK_S, TRID_XYLEADER4_03, LEADER4,   mes_dueling_tr_074_01, 0, ITEM_HUSIGINAAME    },
    { TRAINER_TYPE_GYM_LEADER_EX, RANK_S, TRID_XYLEADER5_03, LEADER5,   mes_dueling_tr_065_01, 0, ITEM_HUSIGINAAME    },
    { TRAINER_TYPE_GYM_LEADER_EX, RANK_S, TRID_XYLEADER6_03, LEADER6,   mes_dueling_tr_066_01, 0, ITEM_HUSIGINAAME    },
    { TRAINER_TYPE_GYM_LEADER_EX, RANK_S, TRID_XYLEADER7_03, LEADER7,   mes_dueling_tr_067_01, 0, ITEM_HUSIGINAAME    },
    { TRAINER_TYPE_GYM_LEADER_EX, RANK_S, TRID_XYLEADER8_03, LEADER8,   mes_dueling_tr_068_01, 0, ITEM_HUSIGINAAME    },

    // lV(4)
    { TRAINER_IDX_BIG_FOUR,       RANK_S, TRID_BIGFOUR1_02,  BIGFOUR1,  mes_dueling_tr_079_01, 0, ITEM_HUSIGINAAME    },
    { TRAINER_IDX_BIG_FOUR,       RANK_S, TRID_BIGFOUR2_02,  BIGFOUR2,  mes_dueling_tr_080_01, 0, ITEM_HUSIGINAAME    },
    { TRAINER_IDX_BIG_FOUR,       RANK_S, TRID_BIGFOUR3_02,  BIGFOUR3,  mes_dueling_tr_081_01, 0, ITEM_HUSIGINAAME    },
    { TRAINER_IDX_BIG_FOUR,       RANK_S, TRID_BIGFOUR4_02,  BIGFOUR4,  mes_dueling_tr_082_01, 0, ITEM_HUSIGINAAME    },

    // `sI(1)
    { TRAINER_IDX_CHAMPION,       RANK_S, TRID_CHAMPION_02,  CHAMPION,  mes_dueling_tr_083_01, 0, ITEM_HUSIGINAAME    }
  };

  return &table_[ no ];
}

/*
 *  ȉAĐ{݂邽߂̃wp֐Q
 */

//----------------------------------------//
//! tO̎擾
//----------------------------------------//
bool ScriptToolDueling::FlagGet( u32 flag_no )
{
  ScriptObject* p_script_obj;
  Work*         p_script_work;

  p_script_obj  = ScriptObject::GetClass< ScriptObject* >( m_amx );
  p_script_work = p_script_obj->GetWork();

  return 0; // p_script_work->GetEventFlag( flag_no );
}

//----------------------------------------//
//! tO̐ݒ
//----------------------------------------//
void ScriptToolDueling::FlagSet( u32 flag_no, bool value )
{
  ScriptObject* p_script_obj;
  Work*         p_script_work;

  p_script_obj  = ScriptObject::GetClass< ScriptObject* >( m_amx );
  p_script_work = p_script_obj->GetWork();

  // p_script_work->SetEventFlag( flag_no, value );
}

//----------------------------------------//
//! obW(W[_[)̎擾
//----------------------------------------//
int ScriptToolDueling::BadgeCount()
{
  System* p_system = System::GetInstance();
  gamesystem::GameManager* p_game_man = p_system->GetGameManager();
  savedata::Misc* p_misc = p_game_man->GetGameData()->GetMisc();

  return p_misc->GetBadgeCount();
}

//----------------------------------------//
//! [N̎擾
//----------------------------------------//
u16 ScriptToolDueling::WorkGet( u32 work_no )
{
  ScriptObject* p_script_obj;
  Work*         p_script_work;

  p_script_obj  = ScriptObject::GetClass< ScriptObject* >( m_amx );
  p_script_work = p_script_obj->GetWork();

  return 0; // @todo p_script_work->GetEventWorkValue( work_no );
}

//----------------------------------------//
//! [N̐ݒ
//----------------------------------------//
void ScriptToolDueling::WorkSet( u32 work_no, u16 value )
{
  ScriptObject* p_script_obj;
  Work*         p_script_work;

  p_script_obj  = ScriptObject::GetClass< ScriptObject* >( m_amx );
  p_script_work = p_script_obj->GetWork();

  // p_script_work->SetEventWorkValue( work_no, value );
}

//----------------------------------------//
//! N擾
//----------------------------------------//
u8 ScriptToolDueling::GetRank()
{
  RankInfo rank;
  rank.value = WorkGet( FLAG_RANK );
  return rank.no;
}

//----------------------------------------//
//! Nݒ
//----------------------------------------//
void ScriptToolDueling::SetRank( u8 value )
{
  RankInfo rank;
  rank.value = WorkGet( FLAG_RANK );
  if ( rank.no != value )
  {
    rank.no  = static_cast< u16 >( value );
    WorkSet( FLAG_RANK, rank.value );

    BookInvalidate(); // \g[i[̍V
  }
}

//----------------------------------------//
//! ݈P̎擾
//----------------------------------------//
u16 ScriptToolDueling::GetRankP()
{
  RankInfo rank;
  rank.value = WorkGet( FLAG_RANK );
  return rank.point;
}

//----------------------------------------//
//! ݈P̐ݒ
//----------------------------------------//
void ScriptToolDueling::SetRankP( u32 value )
{
  RankInfo rank;

  if ( value > 0x0fff )
  {
    value = 0x0fff;
  }

  rank.value = WorkGet( FLAG_RANK );
  rank.point = value;
  WorkSet( FLAG_RANK, rank.value );
}

//! ݈P̉Z
void ScriptToolDueling::AddRankP(u16 value)
{
  SetRankP( GetRankP() + value );
}

//----------------------------------------//
//! ACehbv邩H
//----------------------------------------//
bool ScriptToolDueling::IsItemDrop()
{
  // 100{Đxシ邱Ƃ҂
  return ( xy_system::GflUse::GetPublicRand( 100 * 100 ) < ( GetItemProb() * 100 ) );
}

//----------------------------------------//
//! ݈PACehbv擾
//----------------------------------------//
int ScriptToolDueling::GetItemProb()
{
  u16 rankP = GetRankP();

  if      ( rankP >= 840 ) { return 1; }
  else if ( rankP >= 450 ) { return 2; }
  else if ( rankP >= 180 ) { return 4; }
  else if ( rankP >=  30 ) { return 8; }

  return 0;
}

//----------------------------------------//
//! ݈ʂɂg[i[zu
//----------------------------------------//
int ScriptToolDueling::GetTrainerSlotMax()
{
  u8 rank = GetRank();

  switch (rank)
  {
  case RANK_S : { return 10; }
  case RANK_A : { return  9; }
  case RANK_B : { return  8; }
  case RANK_C : { return  7; }
  case RANK_D : { return  6; }
  }

  return 0;
}

//----------------------------------------//
//! ݈ʂɂzu\ȍőg[i[ԍ
//----------------------------------------//
int ScriptToolDueling::GetTrainerNoMax()
{
  u8   rank = GetRank();
  int  max  = 0;

  /*
   *  揑̕\̂܂ܗ񋓂X^CŃR[fBOĂ
   */
  if ( rank >= RANK_D ) { max += TRAINER_NUM_NORMAL_RANK_D; }
  if ( rank >= RANK_C ) { max += TRAINER_NUM_NORMAL_RANK_C; }
  if ( rank >= RANK_B ) { max += TRAINER_NUM_NORMAL_RANK_B; }
  if ( rank >= RANK_A ) { max += TRAINER_NUM_NORMAL_RANK_A; }
  if ( rank >= RANK_S ) { max += TRAINER_NUM_NORMAL_RANK_S; }

  return max;
}

//----------------------------------------//
//! zug[i[P̏
//----------------------------------------//
void ScriptToolDueling::RemoveTrainerOne()
{
  TrainerInfo info;
  int         max;
  int         at;
  int         n;
  int         i;

  max = 0;
  at  = 0;
  for ( i = 0; i < TRAINER_SLOT_MAX; ++i )
  {
    info.value = WorkGet( FLAG_INFO_ORG + i );
    if ( info.value == 0 )
    {
      break; // ܂łI
    }

    n = ( TRAINER_SLOT_MAX - i ) * 10; // Âg[i[قǉo₷ݒ
    if ( info.mode != MODE_IDLE )
    {
      n += 50; // ΐς݃g[i[͉o₷ݒ
    }

    n = xy_system::GflUse::GetPublicRand( n ) + 1;
    if ( n > max )
    {
      max = n;
      at  = i;
    }
  }

  /*!
   *  Z[uf[^g[i[
   *
   *  Vg[i[قǌɒuߔzl߂
   */
  for ( i = at + 1; i < TRAINER_SLOT_MAX; ++i )
  {
    info.value = WorkGet( FLAG_INFO_ORG + i );
    WorkSet( FLAG_INFO_ORG + i - 1, info.value );
  }
  WorkSet( FLAG_INFO_ORG + TRAINER_SLOT_MAX - 1, 0 );
}

//----------------------------------------//
//! zu\ȃg[i[ʒu
//----------------------------------------//
int ScriptToolDueling::GetEmptySlotNo()
{
  TrainerInfo info;
  int         i;

  for ( i = 0; i < TRAINER_SLOT_MAX; ++i )
  {
    info.value = WorkGet( FLAG_INFO_ORG + i );
    if ( info.value == 0 )
    {
      return i;
    }
  }

  return -1;
}

//----------------------------------------//
//! zu\ȃXbg擾
//----------------------------------------//
int ScriptToolDueling::GetEmptyPostNo()
{
  u32         map = 0; // zuXbgrbg}bv

  TrainerInfo info;
  int         post;
  int         i;

  // zug[i[̃rbg}bv
  for ( i = 0; i < TRAINER_SLOT_MAX; ++i )
  {
    info.value = WorkGet( FLAG_INFO_ORG + i );
    map       |= 1 << info.post;
  }

  post = xy_system::GflUse::GetPublicRand( POST_NUM ) + POST_MIN;
  while ( true )
  {
    if ( ( map & ( 1 << post ) ) == 0 )
    {
      break;
    }

    post += 1;
    if ( post >= POST_MAX )
    {
      post = POST_MIN;
    }
  }

  return post;
}

//----------------------------------------//
/*!
 *  @brief  \g[i[ԍ̎擾
 *  - L[ƂĎ
 *  - eʍ팸̂߁ArbgtB[hpĂP[NɂQl̏Ԃێ
 */
//----------------------------------------//
u8 ScriptToolDueling::BookNoAt( int offset /* = 0 */ )
{
  s8          head;
  TrainerBook book;

  head = AddQueueIndex( GetQueueHead(), offset );
  book.value = WorkGet( FLAG_BOOK_ORG + ( head / 2 ) );

  return book.data[ head & 1 ].no;
}

//! \g[i[̃ACehbvtO擾
bool ScriptToolDueling::BookIsDropAt( int offset /* = 0 */ )
{
  s8          head;
  TrainerBook book;

  head = AddQueueIndex( GetQueueHead(), offset );
  book.value = WorkGet( FLAG_BOOK_ORG + ( head / 2 ) );

  return ( book.data[ head & 1 ].drop != 0 );
}

//! \g[i[̉oƒǉ
u8 ScriptToolDueling::BookTake()
{
  TrainerQueue queue;
  u8           bookNo;

  bookNo = BookNoAt();
  BookAdd();

  queue.value = GetQueueValue();
  queue.head  = IncQueueIndex( queue.head );
  SetQueueValue( queue.value );

  return bookNo;
}

//----------------------------------------//
//! \g[i[̒ǉ
//----------------------------------------//
void ScriptToolDueling::BookAdd()
{
  static const int prob_[3][5] = // rawFg[i[ʁAcolumnF݈ʃ|Cg
  {
    {  5, 10, 15, 20, 40 }, // Wg[i[
    {  0,  3,  6,  9, 12 }, // lV
    {  0,  0,  1,  2,  4 }  // `sI
  };

  u32         map[4] = { 0, 0, 0, 0 }; // g[i[zurbg}bv

  TrainerQueue queue;
  TrainerInfo  info;
  TrainerBook  book;
  u16          rankP;
  u8           rank;
  int          col;
  u8           post;
  u8           max;
  u8           no;
  int          i;

  rankP = GetRankP();
  rank  = GetRank();

  // g[i[me[uCfbNX擾
  if      ( rankP >= 840 )
  {
    col = 4;
  }
  else if ( rankP >= 630 )
  {
    col = 3;
  }
  else if ( rankP >= 450 )
  {
    col = 2;
  }
  else if ( rankP >= 300 )
  {
    col = 1;
  }
  else
  {
    col = 0;
  }

  // zug[i[̃rbg}bv
  for ( i = 0; i < TRAINER_SLOT_MAX; ++i )
  {
    info.value = WorkGet( FLAG_INFO_ORG + i );
    no         = info.no;
    map[ no / 32 ] |= 1 << ( no & 31 );
  }

  // zu҂g[i[̃rbg}bv
  for ( i = 0; i < TRAINER_SLOT_MAX; ++i )
  {
    no = BookNoAt( i );
    map[ no / 32 ] |= 1 << ( no & 31 );
  }

  do // g[i[ԍm肵甲邾̋^goto[v
  {
    /*
     *  Q[NAViINAa
     *  @Q[NAViINAa
     *
     *  @厖ȂƂȂ̂łQsg܂
     */

    /*
     *  `sI`FbN
     *  aAm
     */
    if ( FlagGet( SYS_FLAG_GAME_CLEAR ) == true ) // a
    {
      if ( xy_system::GflUse::GetPublicRand( 100 * 100 ) < ( prob_[ 2 ][ col ] * 100 ) )
      {
        no = TRAINER_IDX_CHAMPION + xy_system::GflUse::GetPublicRand( max );
      }
      if ( ( map[ no / 32 ] & ( 1 << ( no & 31 ) ) ) == 0 )
      {
          break; // ЂƂ܂I͂Pɂ
      }
    }

    /*
     *  lV`FbN
     *  aAm
     */
    if ( FlagGet( SYS_FLAG_GAME_CLEAR ) == true ) // a
    {
      if ( xy_system::GflUse::GetPublicRand( 100 * 100 ) < ( prob_[ 1 ][ col ] * 100 ) )
      {
        no = TRAINER_IDX_BIG_FOUR + xy_system::GflUse::GetPublicRand( max );
      }
      if ( ( map[ no / 32 ] & ( 1 << ( no & 31 ) ) ) == 0 )
      {
          break; // ЂƂ܂I͂Pɂ
      }
    }

    /*
     *  W[_[`FbN
     *  ς݁Am
     */
    max = BadgeCount();
    if ( max > 0 )
    {
      // ς݂̃W[_[璊I
      if ( xy_system::GflUse::GetPublicRand( 100 * 100 ) < ( prob_[ 0 ][ col ] * 100 ) )
      {
        if ( ( rank >= RANK_S ) && ( FlagGet( SYS_FLAG_GAME_CLEAR ) == true ) )
        {
          no = TRAINER_IDX_GYM_LEADER_EX; // ݈ȏAViINAς݂̏ꍇʃW[_[
        }
        else
        {
          no = TRAINER_IDX_GYM_LEADER;    // W[_[ʏ
        }
        no += xy_system::GflUse::GetPublicRand( max );
      }
      if ( ( map[ no / 32 ] & ( 1 << ( no & 31 ) ) ) == 0 )
      {
          break; // ЂƂ܂I͂Pɂ
      }
    }

    /*
     *  ʃg[i[
     *  ɔzuĂg[i[ƂԂȂ悤I
     */
    max = GetTrainerNoMax();
    no  = TRAINER_IDX_NORMAL_RANK_D + xy_system::GflUse::GetPublicRand( max );
    for ( i = 0; i < max; ++i )
    {
      if ( ( map[ no / 32 ] & ( 1 << ( no & 31 ) ) ) == 0 )
      {
          break;
      }
      no += 1;
      if ( no >= TRAINER_IDX_NORMAL_MAX )
      {
        no = TRAINER_IDX_NORMAL_RANK_D;
      }
    }
    if ( i == max )
    {
      return; // ǉłlȂ
    }
  } while (false);

  // \g[i[ݒ
  queue.value = GetQueueValue();

  book.value = WorkGet( FLAG_BOOK_ORG + ( queue.tail / 2 ) );
  book.data[ queue.tail & 1 ].drop = IsItemDrop();
  book.data[ queue.tail & 1 ].no   = no;
  WorkSet( FLAG_BOOK_ORG + ( queue.tail / 2 ), book.value );

  queue.tail = IncQueueIndex( queue.tail );
  SetQueueValue( queue.value );
}

//----------------------------------------//
//!  \g[i[̍V
//----------------------------------------//
void ScriptToolDueling::BookInvalidate()
{
  int slotMax;
  int i;

  slotMax = GetTrainerSlotMax();  // ݈ʂɉőzul
  for ( i = 0; i < slotMax; ++i )
  {
    BookAdd();
  }
}

//----------------------------------------//
//! ݈PȂǂ̃_v
//----------------------------------------//
void ScriptToolDueling::dumpParam()
{
  Date date;
  Time time;
  int  i;

  date.value = WorkGet( FLAG_LAST_DATE );
  time.value = WorkGet( FLAG_LAST_TIME );

  GFL_PRINT( "----- dump dueling param\n" );
  GFL_PRINT( "rank / rankP : %d / %d\n", GetRank(), GetRankP());
  GFL_PRINT( "last time    : %2d/%02d/%02d %02d:%02d:%02d\n", date.year, date.month, date.day, time.hour, time.minute, time.second * 2 );
  GFL_PRINT( "invitation   :");
  for ( i = TMFLG_PI_DUELING_ANNAI; i <= TMFLG_PI_DUELING_TYOUSEN_RED; ++i ) // !!!!! шˑAdumpȂ̂Ŗ
  {
    if ( FlagGet( i ) == false )
    {
      GFL_PRINT( " 0" );
    }
    else
    {
      GFL_PRINT( " 1" );
    }
  }
  GFL_PRINT( "\n" );
  GFL_PRINT( "dump dueling param ------\n" );
}

//----------------------------------------//
//! zug[i[̃_v
//----------------------------------------//
void ScriptToolDueling::dumpSlots()
{
  TrainerInfo info;
  int         i;

  GFL_PRINT( "----- dump dueling slots\n" );
  for ( i = 0; i < TRAINER_SLOT_MAX; ++i )
  {
    info.value = WorkGet( FLAG_INFO_ORG + i );
    GFL_PRINT( "%d : %d %d %d %d\n", i, info.post, info.mode, info.drop, info.no );
  }
  GFL_PRINT( "dump dueling slots ------\n" );
}

//----------------------------------------//
//! \g[i[̃_v
//----------------------------------------//
void ScriptToolDueling::dumpBooks()
{
  int count;
  int i;

  count = GetQueueCount();
  GFL_PRINT( "----- dump dueling books\n" );
  for ( i = 0; i < count; ++i )
  {
    GFL_PRINT( "%d ", BookNoAt( i ));
  }
  GFL_PRINT( "\n" );
  GFL_PRINT( "dump dueling books ------\n" );
}


GFL_NAMESPACE_END(script);
GFL_NAMESPACE_END(field);
