//===================================================================
/**
 * @file    WonderGiftSaveData.h
 * @brief   svcȑ蕨Z[uf[^
 * @author  Shin Kosaka
 * @date    2012.09.13
 */
//===================================================================

#include "savedata/WonderGiftSaveData.h"



GFL_NAMESPACE_BEGIN(savedata)



//=============================================================================================
/**
*  RXgN^
*/
//=============================================================================================
WonderGiftSaveData::WonderGiftSaveData( void )
{
	// ^̃TCYςĂ܂ĂȂ`FbN
	//STATIC_ASSERT( sizeof(m_coreData) == (18+129+4)*5 );

	this->Clear( NULL );
}
//=============================================================================================
/**
*  fXgN^
*/
//=============================================================================================
WonderGiftSaveData::~WonderGiftSaveData()
{
}

//=============================================================================================
/**
 * @brief Rs[
 */
//=============================================================================================
void WonderGiftSaveData::CopyFrom( const WonderGiftSaveData& src )
{
	gfl::std::MemCopy( reinterpret_cast<const void*>(&src.m_coreData), reinterpret_cast<void*>(&m_coreData), sizeof(m_coreData) );
}

//=============================================================================================
/**
*  svcȂ̃f[^|C^擾
*/
//=============================================================================================
const WONDER_GIFT_DATA* WonderGiftSaveData::GetGiftData( u32 index ) const
{
	if( index < 0 || index >= WONDER_GIFT_DATA_NUM )
		return NULL;
	
	return &(m_coreData.wonderGiftData[index]);
}


//=============================================================================================
/**
*  svcȂ̃f[^ݒ
*/
//=============================================================================================
bool WonderGiftSaveData::SetGiftData( u32 index , const WONDER_GIFT_DATA* pData )
{
	if( index < 0 || index >= WONDER_GIFT_DATA_NUM )
		return false;
	
	gfl::std::MemCopy( pData , &(m_coreData.wonderGiftData[index]), sizeof(WONDER_GIFT_DATA) );
	
	return true;
}

//======================================================================================================================
// for SaveData
//======================================================================================================================

//=============================================================================================
/**
 * [for SaveData]  ۑf[^oCiւ̃|C^Ԃ
 *
 * @retval        void*
 */
//=============================================================================================
void*  WonderGiftSaveData::GetData( void )
{
	return reinterpret_cast<void*>(&m_coreData);
}

//=============================================================================================
/**
 * [for SaveData]  ۑf[^oCĩTCYԂ
 *
 * @retval        u32
 */
//=============================================================================================
size_t WonderGiftSaveData::GetDataSize( void )
{
	return sizeof(m_coreData);
}

//=============================================================================================
/**
 * [for SaveData]  Z[uf[^WJ
 *
 * @retval        void*
 */
//=============================================================================================
void WonderGiftSaveData::SetData(void* pData)
{
	gfl::std::MemCopy(pData, &m_coreData, sizeof(m_coreData) );
}

//=============================================================================================
/**
* [for SaveData]  Z[uf[^
*
* @param heap
*/
//=============================================================================================
void    WonderGiftSaveData::Clear( gfl::heap::HeapBase * heap )
{
	GFL_PRINT( "WonderGiftSaveData::CORE SIZE=%d\n", sizeof(savedata::WonderGiftSaveData::CORE_DATA));

	gfl::std::MemFill(&m_coreData, 0x00, sizeof(m_coreData));
}



GFL_NAMESPACE_END(savedata)

