//===================================================================
/**
 * @file    WonderGiftSaveData.h
 * @brief   svcȑ蕨Z[uf[^
 * @author  Shin Kosaka
 * @date    2012.09.13
 */
//===================================================================
#ifndef __WONDER_GIFT_SAVE_DATA_H__
#define __WONDER_GIFT_SAVE_DATA_H__

#include <gflib.h>
#include <gflnet.h>
#include "savedata/SaveDataInterface.h"

GFL_NAMESPACE_BEGIN(savedata)

//ӂȂ̃f[^
struct WONDER_GIFT_DATA
{
	wchar_t eventName[37];//Cxg
	u32 recvDate;//󂯎t
	u16	eventID;//CxgID
	u8 cardMessageID;//J[hbZ[WID
	u8 dataType;//f[^^Cv@|PAAGp[Ȃ
	u8 recvFlag;//󂯎tO
	u8 padding[17];//pfBO
	u16 crc;//CRC
	u16 key;//ÍL[
	u8 body[160];//zMf[^
};

/**
*  svcȑ蕨Z[uf[^ǗNX
*/

class WonderGiftSaveData : public SaveDataInterface
{
GFL_FORBID_COPY_AND_ASSIGN(WonderGiftSaveData); //Rs[RXgN^{֎~

public:
	
	enum
	{
		WONDER_GIFT_DATA_NUM = 24, // 24ۑ
	};
	
private:



	//Z[uf[^{
	typedef struct
	{
		u32 recvFlag[64];//MtO256byte
		WONDER_GIFT_DATA wonderGiftData[WONDER_GIFT_DATA_NUM];
	}CORE_DATA;


public:
	//=============================================================================================
	/**
	*  RXgN^
	*/
	//=============================================================================================
	WonderGiftSaveData( void );
	//=============================================================================================
	/**
	*  fXgN^
	*/
	//=============================================================================================
	virtual ~WonderGiftSaveData();

	//=============================================================================================
	/**
	*  f[^Rs[
	*
	* @param[in]   src   Rs[
	*/
	//=============================================================================================
	void CopyFrom( const WonderGiftSaveData& src );


	//=============================================================================================
	/**
	*  svcȂ̃f[^|C^擾
	*/
	//=============================================================================================
	const WONDER_GIFT_DATA* GetGiftData( u32 index ) const;
	
	
	//=============================================================================================
	/**
	*  svcȂ̃f[^ݒ
	*/
	//=============================================================================================
	bool SetGiftData( u32 index , const WONDER_GIFT_DATA* pData );

public:
	//======================================================================================================================
	// for SaveData
	//======================================================================================================================

	//=============================================================================================
	/**
	* [for SaveData]  ۑf[^oCiւ̃|C^Ԃ
	*
	* @retval        void*
	*/
	//=============================================================================================
	virtual void*  GetData( void );

	//=============================================================================================
	/**
	* [for SaveData]  ۑf[^oCĩTCYԂ
	*
	* @retval        void*
	*/
	//=============================================================================================
	virtual size_t    GetDataSize( void );
	//=============================================================================================
	/**
	 * [for SaveData]  Z[uf[^WJ
	 *
	 * @retval        void*
	 */
	//=============================================================================================
	virtual void SetData(void* pData);

	//=============================================================================================
	/**
	* [for SaveData]  Z[uf[^
	*
	* @param heap
	*/
	//=============================================================================================
	virtual void    Clear( gfl::heap::HeapBase * heap );

private:
	CORE_DATA           m_coreData;

};  // class WonderGiftSaveData

GFL_NAMESPACE_END(savedata)




#endif //__MYSTATUS_H__
