
//=============================================================================
/**
 * @file   FieldCameraAnimation.h
 * @brief  tB[hJAj[VNXwb_
 * @author rc N
 * @date   2012.09.27
 */
//=============================================================================

#ifndef __FIELD_CAMERA_ANIMATION_H__
#define __FIELD_CAMERA_ANIMATION_H__

namespace field
{
  class FieldStereoCamera;

  //-----------------------------------------------------------------------------
  /**
   * @brief tB[hJAj[VNX
   */
  //-----------------------------------------------------------------------------
  class CFieldCameraAnimation
  {
  public:
    // tB[hJ̃Aj[V̏
    enum
    {
      FLD_CAM_ANM_STATE_NONE          = 0,      // Ȃ
      FLD_CAM_ANM_STATE_DISTANCE_BIT  = 1 << 0, // (Y[)Aj[V
      FLD_CAM_ANM_STATE_OFFSETPOS_BIT = 1 << 1, // JItZbgAj[V
      FLD_CAM_ANM_STATE_TRANS_BIT     = 1 << 2, // JsړAj[V
      FLD_CAM_ANM_STATE_LINERMOVE_BIT = 1 << 3, // J`ԃAj[V
      FLD_CAM_ANM_STATE_SHAKE_BIT     = 1 << 4, // JUAj[V
      FLD_CAM_ANM_STATE_SETTING_BIT   = 1 << 5, // ftHgZbeBOύXAj[V
    };

    // (Y[)Aj[V̊֐
    enum FldCamAnmDistanceFunction
    {
      //FLD_CAM_ANM_DISTANCE_FUNCTION_LINER,      // `  // 
      FLD_CAM_ANM_DISTANCE_FUNCTION_ZENKASHIKI  // Q a[n+1] = a[n] + ( b - a[n] ) * c  ([]͓Y)
    };
    
    // JItZbgAj[V̊֐
    enum FldCamAnmOffsetPosFunction
    {
      //FLD_CAM_ANM_OFFSETPOS_FUNCTION_LINER,      // `  // 
      FLD_CAM_ANM_OFFSETPOS_FUNCTION_ZENKASHIKI  // Q a[n+1] = a[n] + ( b - a[n] ) * c  ([]͓Y)
    };
    
    // sړAj[V̊֐
    enum FldCamAnmTransFunction
    {
      FLD_CAM_ANM_TRANS_FUNCTION_LINER
    };

  public:
    // (Y[)Aj[V̈
    union FldCamAnmDistanceArg
    {
      // `
      struct liner
      {
        u32 frame;  // t[
      }
      liner;
      
      // Q
      struct zenkashiki
      {
        f32 limit;     // Ɍl  // b
        f32 bairitsu;  // {    // c
        // Ⴛ1
        // Jnl500AIl1AɌl0A{0.3
        // a[0] = 500
        // a[n+1] = a[n] + ( 0 - a[n] ) * 0.3
        // a[n+1]1ȉɂȂI
        // Ⴛ2
        // Jnl0AIl499AɌl500A{0.3
        // a[0] = 0
        // a[n+1] = a[n] + ( 500 - a[n] ) * 0.3
        // a[n+1]499ȏɂȂI
        // lݒ̃[
        // lĂƂ͋Ɍl<IlɂĂA
        // l傫ĂƂ͋Ɍl>IlɂĂƁB
      }
      zenkashiki;
    };

    // JItZbgAj[V̈
    union FldCamAnmOffsetPosArg
    {
      // `
      struct liner
      {
        u32 frame;  // t[
      }
      liner;

      // Q
      struct zenkashiki
      {
        f32 limit;     // Ɍl  // b(IlƂ̍)
        f32 bairitsu;  // {    // c
        // Ⴛ1
        // Jnl500AIl1AɌl0A{0.3
        // a[0] = 500
        // a[n+1] = a[n] + ( 0 - a[n] ) * 0.3
        // a[n+1]1ȉɂȂI
        // Ⴛ2
        // Jnl0AIl499AɌl500A{0.3
        // a[0] = 0
        // a[n+1] = a[n] + ( 500 - a[n] ) * 0.3
        // a[n+1]499ȏɂȂI
      }
      zenkashiki;
    };
    
    // JsړAj[V̈
    union FldCamAnmTransArg
    {
      // `
      struct liner
      {
        u32 frame; // t[
        bool is_rowdata; // true:W΍W false:J̌ɂW
      }
      liner;
    };
    
    // JUAj[V̈
    union FldCamAnmShakeArg
    {
      // Up[^
      struct shake_param
      {
        s16 width;              // ꕝ
        s16 height;             // ꍂ
        u8  time;               // 
        u32 sync;               // 1̂ɂVN
      }
      param;
    };

    // JZbeBOAj[V
    struct FldCamAnmSettingArg
    {
      FieldCameraSetting::FieldCameraSettingData        end;
      u32                                               frame;
    };

  private:
    FieldStereoCamera* m_pCamera;

    // tB[hJ̃Aj[V̏Ԃ̃rbgtO
    bit32  m_fld_cam_anm_state_bit_flag;

    // (Y[)Aj[V
    f32                             m_fld_cam_anm_distance_end_value;
    FldCamAnmDistanceFunction       m_fld_cam_anm_distance_function;
    FldCamAnmDistanceArg            m_fld_cam_anm_distance_arg;
  
    gfl::math::VEC3                 m_fld_cam_anm_offsetpos_end_pos;
    FldCamAnmOffsetPosFunction      m_fld_cam_anm_offsetpos_function;
    FldCamAnmOffsetPosArg           m_fld_cam_anm_offsetpos_arg;
  
    gfl::math::VEC3                 m_fld_cam_anm_trans_start_pos;
    gfl::math::VEC3                 m_fld_cam_anm_trans_end_pos;
    gfl::math::VEC3                 m_fld_cam_anm_trans_start_tar;
    gfl::math::VEC3                 m_fld_cam_anm_trans_end_tar;
    FldCamAnmTransFunction          m_fld_cam_anm_trans_function;
    FldCamAnmTransArg               m_fld_cam_anm_trans_arg;
    u32                             m_fld_cam_anm_trans_cnt;

    // UAj[V
    FldCamAnmShakeArg               m_fld_cam_anm_shake_arg;
    gfl::math::VEC3                 m_fld_cam_anm_shake_ofs;
    gfl::math::VEC3                 m_fld_cam_anm_shake_start_ofs;
    u32                             m_fld_cam_anm_shake_now_sync;
    s32    m_fld_cam_anm_now_time;

    // ftHgZbeBOAj[V
    FieldCameraSetting::FieldCameraSettingData m_fld_cam_anm_setting_start;
    FldCamAnmSettingArg                        m_fld_cam_anm_setting_end;
    s32 m_fld_cam_anm_setting_now_time;

  public:
    CFieldCameraAnimation(FieldStereoCamera* pCamera); ///< RXgN^
    void Update(); ///< t[

    // Aj[V trueAB
    b32 IsExecutingFldCamAnm() const ;

    // (Y[)Aj[VJn
    void StartFldCamAnmDistance(
      const f32                        start_value,
      const f32                        end_value,
      const FldCamAnmDistanceFunction  function,
      const FldCamAnmDistanceArg&      arg  // functionɍ킹lݒ肵ĉ
      );
    // (Y[)Aj[VŝƂtrueԂ
    b32  IsExecutingFldCamAnmDistance(void);
    
    /// @brief JUAj[Vǉ
    void StartFldCamAnmShake(
      const FldCamAnmShakeArg&          arg
      );
    /// @brief JUAj[V𒲂ׂ
    b32 IsExecutingFldCamAnmShake(void);
    
    // JItZbgAj[VJn
    void StartFldCamAnmOffsetPos(
      const gfl::math::VEC3&            end_pos,
      const FldCamAnmOffsetPosFunction  function,
      const FldCamAnmOffsetPosArg&      arg  // functionɍ킹lݒ肵ĉ
      );
    // JItZbgAj[VŝƂtrueԂ
    b32  IsExecutingFldCamAnmOffsetPos(void);
    
    // JsړAj[VJn
    
    // sړ
    void StartFldCamAnmTrans(
      const gfl::math::VEC3&            trans_val,
      const FldCamAnmTransFunction      function,
      const FldCamAnmTransArg&          arg
      );
    
    // POSTARړ
    void StartFldCamAnmTransPosTar(
      const gfl::math::VEC3&            end_pos,
      const gfl::math::VEC3&            end_tar,
      const FldCamAnmTransFunction      function,
      const FldCamAnmTransArg&          arg
      );
    
    // TARPOSZoĈړ
    void StartFldCamAnmTrans(
      const f32                     pitch,
      const f32                     yaw,
      const f32                     distance,
      const gfl::math::VEC3&        end_tar,
      const FldCamAnmTransFunction  function,
      const FldCamAnmTransArg&      arg
      );
    
    b32 IsExecutingFldCamAnmTrans(void);
    
    // ftHgZbeBO@Aj[VJn
    void StartFldCamAnmSetting(
      const FldCamAnmSettingArg&          arg
      );
    b32 IsExecutingFldCamAnmSetting(void);

  private:
    // (Y[)Aj[VXV
    void CalculateFldCamAnmDistance(void); 
    
    // JItZbgAj[VXV
    bool CalculateFldCamAnmOffsetPosParam( f32* distance, const f32 tar );
    void CalculateFldCamAnmOffsetPos(void);
    
    void CalculateFldCamAnmTrans(void);
    /// UAj[V
    void CalculateFldCamAnmShake(void);
    /// ftHgZbeBOAj[V
    void CalculateFldCamAnmSetting(void);
    
    /// J̉]}gbNX擾
    void GetAxisRotMatrix(gfl::math::MTX34* p_mtx);
    
    /// C[WO֐
    static f32 getEasing( f32 now, f32 max );

  private:
    static const f32 DEFAULT_DISTANCE  = 10.0f;

    static const f32 MIN_ROTATE_AROUND_TARGET_POSITION_BASE_X  = -85.0f;
    static const f32 MAX_ROTATE_AROUND_TARGET_POSITION_BASE_X  = +85.0f;
  };

} // namespace field

#endif // __FIELD_CAMERA_ANIMATION_H__

/*  EOF  */





