
//=============================================================================
/**
 * @file   FieldCameraAnimation.cpp
 * @brief  tB[hJAj[VNX
 * @author rc N
 * @date   2012.09.27
 */
//=============================================================================

#include "FieldCameraAnimation.h"
#include "../FieldStereoCamera.h"

namespace field
{
  /* ------------------------------------------------------------------------- */
  /**
   * @brief _̍WJ̍WvZ
   *
   * @param out_pos J̍W
   * @param tar_pos _
   * @param pitch sb`iX]j
   * @param yaw [iY]j
   * @param distance 
   */
  /* ------------------------------------------------------------------------- */
  static void CalcAnglePos( gfl::math::VEC3& out_pos, const gfl::math::VEC3& tar_pos, f32 pitch, f32 yaw, f32 distance )
  {
    f32 sinYaw;
    f32 cosYaw;
    f32 sinPitch;
    f32 cosPitch;
  
    gfl::math::SinCosRad( &sinYaw, &cosYaw, yaw );
    gfl::math::SinCosRad( &sinPitch, &cosPitch, pitch );

    if( cosPitch < 0 ) { cosPitch = -cosPitch; } // 肵Ȃ悤Ƀ}CiXl̓vXlɕ␳
    if( cosPitch < 0.01f ) { cosPitch = 0.01f; } // 0lߕӂ͕s\ɂȂ邽ߕ␳
    // J̍WvZ
    {
      out_pos.x = sinYaw * cosPitch;
      out_pos.y = sinPitch;
      out_pos.z = cosYaw * cosPitch;
      gfl::math::VEC3Normalize( &out_pos, &out_pos ); 
      out_pos = tar_pos + out_pos * distance;
    }
  }

  //-----------------------------------------------------------------------------
  // RXgN^
  //-----------------------------------------------------------------------------
  CFieldCameraAnimation::CFieldCameraAnimation(FieldStereoCamera* pCamera) :
  m_pCamera(pCamera) ,
  m_fld_cam_anm_state_bit_flag(FLD_CAM_ANM_STATE_NONE) ,
  m_fld_cam_anm_distance_end_value(DEFAULT_DISTANCE) ,
  m_fld_cam_anm_distance_function(FLD_CAM_ANM_DISTANCE_FUNCTION_ZENKASHIKI)
  {
    return ;
  }

  //-----------------------------------------------------------------------------
  // t[
  //-----------------------------------------------------------------------------
  void CFieldCameraAnimation::Update()
  {
    CalculateFldCamAnmSetting();
    CalculateFldCamAnmDistance();
    CalculateFldCamAnmOffsetPos();
    CalculateFldCamAnmTrans();
    CalculateFldCamAnmShake();
  }

  // Aj[V trueAB
  b32 CFieldCameraAnimation::IsExecutingFldCamAnm(void) const
  {
    if(m_fld_cam_anm_state_bit_flag == 0){
      return false;
    }
    return true;
  }

  // (Y[)Aj[VJn
  void CFieldCameraAnimation::StartFldCamAnmDistance(
    const f32                        start_value,
    const f32                        end_value,
    const FldCamAnmDistanceFunction  function,
    const FldCamAnmDistanceArg&      arg  // functionɍ킹lݒ肵ĉ
    )
  {
    m_pCamera->SetParameterDistance(start_value);
    
    m_fld_cam_anm_distance_end_value = end_value;
    m_fld_cam_anm_distance_function = function;
    m_fld_cam_anm_distance_arg = arg;

    // 
    switch( m_fld_cam_anm_distance_function )
    {
    //case FLD_CAM_ANM_DISTANCE_FUNCTION_LINER:
    //  {
    //  }
    //  break;
    case FLD_CAM_ANM_DISTANCE_FUNCTION_ZENKASHIKI:
      {
        // Ȃ
      }
      break;
    default : GFL_ASSERT(0);
    }

    // sɂ
    m_fld_cam_anm_state_bit_flag |= FLD_CAM_ANM_STATE_DISTANCE_BIT;
  }

  // (Y[)Aj[VŝƂtrueԂ
  b32 CFieldCameraAnimation::IsExecutingFldCamAnmDistance(void)
  {
    return ( ( m_fld_cam_anm_state_bit_flag & FLD_CAM_ANM_STATE_DISTANCE_BIT ) != FLD_CAM_ANM_STATE_NONE );
  }

  /* -------------------------------------------------------------------------*/
  /**
   * @brief JUAj[Vǉ
   *
   * @param arg Up[^
   */
  /* -------------------------------------------------------------------------*/
  void CFieldCameraAnimation::StartFldCamAnmShake(
      const FldCamAnmShakeArg&          arg
  )
  {
    m_fld_cam_anm_shake_arg = arg;
    m_pCamera->GetParameterPositionOffset(&m_fld_cam_anm_shake_start_ofs);
    gfl::math::VEC3 tmp_vec = gfl::math::VEC3(arg.param.width,arg.param.height,0);
    m_fld_cam_anm_now_time = arg.param.time;

    // ]s쐬
    gfl::math::MTX34 mtx;
    GetAxisRotMatrix(&mtx);

    // Wϊ
    gfl::math::VEC3Transform( &m_fld_cam_anm_shake_ofs, &mtx, &tmp_vec );

    // t[
    m_fld_cam_anm_shake_now_sync = 0;

    // sɂ
    m_fld_cam_anm_state_bit_flag |= FLD_CAM_ANM_STATE_SHAKE_BIT;
  }

  /* -------------------------------------------------------------------------*/
  /**
   * @brief J̉]}gbNX擾
   *
   * @param p_mtx 擾MatrixmF
   */
  /* -------------------------------------------------------------------------*/
  void CFieldCameraAnimation::GetAxisRotMatrix(gfl::math::MTX34* p_mtx)
  {
    // J̕xNg
    gfl::math::VEC3 s_vec,e_vec;
    m_pCamera->GetCameraPosition( s_vec );
    m_pCamera->GetTargetPosition( e_vec );

    gfl::math::VEC3 vec = e_vec - s_vec;
    gfl::math::VEC3Normalize( &vec, &vec );

    gfl::math::VEC3 base_vec(0,0,-1);

    f32 deg;
    gfl::math::VEC3 axis;

    // ̊pxZo
    {
      f32 cos = gfl::math::VEC3Dot( &base_vec, &vec );
      if( cos > 1.0f ){ cos = 1.0f; }
      else if ( cos < -1.0f ){ cos = -1.0f; }

      // pxZo
      deg = gfl::math::AcosDeg( cos );

      // Oς]߂
      gfl::math::VEC3Cross( &axis, &base_vec, &vec );
      // Oς狁߂͒Hi0ł͂Ȃj
      if( gfl::math::VEC3SquareLen( &axis ) )
      {
        //      if( axis.y < 0 ){ deg *= -1; }
      }
      else  // ȂꍇAQ̃xNg͓ɂ\̂ŁAcos̐Ŕ
      {
        if( cos < 0 ){ deg = 180.0f; }
        else{ deg = 0; }
        axis.x = 0.0f;
        axis.y = 1.0f;
        axis.z = 0.0f;
      }
    }

    // ]s쐬
    //@todo CuDeg֐Ăׂ
    gfl::math::MTX34RotAxisFIdx( p_mtx, &axis, NN_MATH_DEG_TO_FIDX(deg) );
  }

  // C[WO֐
  f32 CFieldCameraAnimation::getEasing( f32 now, f32 max )
  {
    if( max <= 0.0f ){
      return 1.0f;
    }
    if( now <= 0.0f ){
      return 0.0f;
    }
    if( max < now ){
      now = max;
    }
    // a = (-cos( t*180.0f )) / 2 + 0.50f
    return (-gfl::core::Math::FCos( gfl::core::Math::DegreeToRadian((now / max) * 180.0f) ) * 0.50f) + 0.50f;
  }

  /* -------------------------------------------------------------------------*/
  /**
   * @brief JUAj[V𒲂ׂ
   *
   * @return true̎UAj[V
   */
  /* -------------------------------------------------------------------------*/
  b32 CFieldCameraAnimation::IsExecutingFldCamAnmShake(void)
  {
    return ( ( m_fld_cam_anm_state_bit_flag & FLD_CAM_ANM_STATE_SHAKE_BIT ) != FLD_CAM_ANM_STATE_NONE );
  }

  // JItZbgAj[VJn
  void CFieldCameraAnimation::StartFldCamAnmOffsetPos(
    const gfl::math::VEC3&          end_pos,
    const FldCamAnmOffsetPosFunction  function,
    const FldCamAnmOffsetPosArg&      arg  // functionɍ킹lݒ肵ĉ
  )
  {
    m_fld_cam_anm_offsetpos_end_pos = end_pos;
    m_fld_cam_anm_offsetpos_function = function;
    m_fld_cam_anm_offsetpos_arg = arg;

    // 
    switch( m_fld_cam_anm_distance_function )
    {
    //case FLD_CAM_ANM_DISTANCE_FUNCTION_LINER:
    //  {
    //  }
    //  break;
    case FLD_CAM_ANM_DISTANCE_FUNCTION_ZENKASHIKI:
      {
        // Ȃ
      }
      break;
    default : GFL_ASSERT(0);
    }

    // sɂ
    m_fld_cam_anm_state_bit_flag |= FLD_CAM_ANM_STATE_OFFSETPOS_BIT;
  }

  // JItZbgAj[VŝƂtrueԂ
  b32  CFieldCameraAnimation::IsExecutingFldCamAnmOffsetPos(void)
  {
    return ( ( m_fld_cam_anm_state_bit_flag & FLD_CAM_ANM_STATE_OFFSETPOS_BIT ) != FLD_CAM_ANM_STATE_NONE );
  }
  
  // JsړAj[VJn
  void CFieldCameraAnimation::StartFldCamAnmTrans(
    const gfl::math::VEC3&            trans_val,
    const FldCamAnmTransFunction      function,
    const FldCamAnmTransArg&          arg
  )
  { 
    m_fld_cam_anm_trans_function = function;
    m_fld_cam_anm_trans_arg = arg;
    m_pCamera->GetCameraPosition( m_fld_cam_anm_trans_start_pos );
    m_pCamera->GetTargetPosition( m_fld_cam_anm_trans_start_tar );
    
    gfl::math::VEC3 vec;
  
    if( arg.liner.is_rowdata == false )
    {
      // J̕xNg
      vec = m_fld_cam_anm_trans_start_tar - m_fld_cam_anm_trans_start_pos;
      gfl::math::VEC3Normalize( &vec, &vec );
    
      gfl::math::VEC3 base_vec(0,0,-1);
    
      f32 deg;
      gfl::math::VEC3 axis;
    
      // ̊pxZo
      {
        f32 cos = gfl::math::VEC3Dot( &base_vec, &vec );
        if( cos > 1.0f ){ cos = 1.0f; }
        else if ( cos < -1.0f ){ cos = -1.0f; }
      
        // pxZo
        deg = gfl::math::AcosDeg( cos );

        // Oς]߂
        gfl::math::VEC3Cross( &axis, &base_vec, &vec );
        // Oς狁߂͒Hi0ł͂Ȃj
        if( gfl::math::VEC3SquareLen( &axis ) )
        {
    //      if( axis.y < 0 ){ deg *= -1; }
        }
        else  // ȂꍇAQ̃xNg͓ɂ\̂ŁAcos̐Ŕ
        {
          if( cos < 0 ){ deg = 180.0f; }
          else{ deg = 0; }
          axis.x = 0.0f;
          axis.y = 1.0f;
          axis.z = 0.0f;
        }
      }

#if 0
      // 荞
      if( deg < 0 )
      {
        deg = 360 + deg;
      }
#endif
    
      // ]s쐬
      gfl::math::MTX34 mtx;
      //@todo CuDeg֐Ăׂ
      gfl::math::MTX34RotAxisFIdx( &mtx, &axis, NN_MATH_DEG_TO_FIDX(deg) );

      // Wϊ
      gfl::math::VEC3Transform( &vec, &mtx, &trans_val );

#if 0
      HOSAKA_PRINT( "deg=%f \n", deg );
      HOSAKA_PRINT( "axis=%f %f %f \n", axis.x, axis.y, axis.z );
      HOSAKA_PRINT( "trans_val=%f %f %f \n", trans_val.x, trans_val.y, trans_val.z );
      HOSAKA_PRINT( "res=%f %f %f \n", vec.x, vec.y, vec.z );
#endif
    }
    else 
    {
      vec = trans_val;
    }
  
    // In_ݒ
    m_fld_cam_anm_trans_end_pos = m_fld_cam_anm_trans_start_pos + vec;
    m_fld_cam_anm_trans_end_tar = m_fld_cam_anm_trans_start_tar + vec;
  
    switch( m_fld_cam_anm_trans_function )
    {
    case FLD_CAM_ANM_TRANS_FUNCTION_LINER:
      {
        m_fld_cam_anm_trans_cnt = 0;
      }
      break;
  
    default : GFL_ASSERT(0);
    }
  
    // sɂ
    m_fld_cam_anm_state_bit_flag |= FLD_CAM_ANM_STATE_TRANS_BIT;
  }

  // J POSTAR̈ړAj[VJn rowdata
  void CFieldCameraAnimation::StartFldCamAnmTransPosTar(
    const gfl::math::VEC3&            end_pos,
    const gfl::math::VEC3&            end_tar,
    const FldCamAnmTransFunction      function,
    const FldCamAnmTransArg&          arg
  )
  { 
    m_fld_cam_anm_trans_function = function;
    m_fld_cam_anm_trans_arg = arg;
    m_pCamera->GetCameraPosition( m_fld_cam_anm_trans_start_pos );
    m_pCamera->GetTargetPosition( m_fld_cam_anm_trans_start_tar );
    
    gfl::math::VEC3 vec;

    // In_ݒ
    m_fld_cam_anm_trans_end_pos = end_pos;
    m_fld_cam_anm_trans_end_tar = end_tar;
  
    switch( m_fld_cam_anm_trans_function )
    {
    case FLD_CAM_ANM_TRANS_FUNCTION_LINER:
      {
        m_fld_cam_anm_trans_cnt = 0;
      }
      break;
  
    default : GFL_ASSERT(0);
    }
  
    // sɂ
    m_fld_cam_anm_state_bit_flag |= FLD_CAM_ANM_STATE_TRANS_BIT;
  }

  // J TARPOSZo Aj[VJn rowdata
  void CFieldCameraAnimation::StartFldCamAnmTrans(
    const f32                     pitch,
    const f32                     yaw,
    const f32                     distance,
    const gfl::math::VEC3&        end_tar,
    const FldCamAnmTransFunction  function,
    const FldCamAnmTransArg&      arg
  )
  { 
    m_fld_cam_anm_trans_function = function;
    m_fld_cam_anm_trans_arg = arg;
  
    m_pCamera->GetCameraPosition( m_fld_cam_anm_trans_start_pos );
    m_pCamera->GetTargetPosition( m_fld_cam_anm_trans_start_tar );
    
    gfl::math::VEC3 vec;

    // In_ݒ
    m_fld_cam_anm_trans_end_tar = end_tar;
    // POSvZ
    CalcAnglePos( m_fld_cam_anm_trans_end_pos, end_tar, pitch, yaw, distance );
  
    switch( m_fld_cam_anm_trans_function )
    {
    case FLD_CAM_ANM_TRANS_FUNCTION_LINER:
      {
        m_fld_cam_anm_trans_cnt = 0;
      }
      break;

    default : GFL_ASSERT(0);
    }

    // sɂ
    m_fld_cam_anm_state_bit_flag |= FLD_CAM_ANM_STATE_TRANS_BIT;
  }

  // JsړAj[Vs̎trueԂ
  b32 CFieldCameraAnimation::IsExecutingFldCamAnmTrans(void)
  {
    return ( ( m_fld_cam_anm_state_bit_flag & FLD_CAM_ANM_STATE_TRANS_BIT ) != FLD_CAM_ANM_STATE_NONE );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ftHgZbeBO@Aj[VJn
   *
   *	@param  arg   
   */
  //-----------------------------------------------------------------------------
  void CFieldCameraAnimation::StartFldCamAnmSetting(
    const FldCamAnmSettingArg&          arg
  )
  {
    gfl::math::VEC3 rotate_around_target_position_base; m_pCamera->GetParameterRotateAroundTargetPositionBase(&rotate_around_target_position_base);

    m_fld_cam_anm_setting_end = arg;
    m_fld_cam_anm_setting_now_time = 0;
  
    m_fld_cam_anm_setting_start.offset_y    = m_pCamera->GetParameterPositionOffsetY();
    m_fld_cam_anm_setting_start.rotate_x    = rotate_around_target_position_base.x;
    m_fld_cam_anm_setting_start.rotate_y    = rotate_around_target_position_base.y;
    m_fld_cam_anm_setting_start.near        = m_pCamera->GetNearClip();
    m_fld_cam_anm_setting_start.far         = m_pCamera->GetFarClip();
    m_fld_cam_anm_setting_start.fovy        = GFL_MATH_RAD_TO_DEG(m_pCamera->GetFovy());
    m_fld_cam_anm_setting_start.distance    = m_pCamera->GetParameterDistance();
    m_fld_cam_anm_setting_start.depth_range = m_pCamera->GetDepthRange();
    m_fld_cam_anm_setting_start.depth_level = m_pCamera->GetDepthLevel();
    m_fld_cam_anm_setting_start.depth_f_flag= m_pCamera->GetParameterDepthOfFieldFlag();
    m_fld_cam_anm_setting_start.depth_f     = m_pCamera->GetParameterDepthOfFieldF();

    m_fld_cam_anm_state_bit_flag |= FLD_CAM_ANM_STATE_SETTING_BIT;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ftHgZbeBO@Aj[V`FbN
   *
   *	@retval true  ͂
   *	@retval false 
   */
  //-----------------------------------------------------------------------------
  b32 CFieldCameraAnimation::IsExecutingFldCamAnmSetting(void)
  {
    return ( ( m_fld_cam_anm_state_bit_flag & FLD_CAM_ANM_STATE_SETTING_BIT ) == FLD_CAM_ANM_STATE_SETTING_BIT );
  }
  
  //--------------------------------------------
  // tB[hJ̃Aj[V
  //--------------------------------------------
  void CFieldCameraAnimation::CalculateFldCamAnmDistance(void)
  {
    if( this->IsExecutingFldCamAnmDistance() )
    {
      f32 distance = m_pCamera->GetParameterDistance();
      switch( m_fld_cam_anm_distance_function )
      {
      //case FLD_CAM_ANM_DISTANCE_FUNCTION_LINER:
      //  {
      //  }
      //  break;
      case FLD_CAM_ANM_DISTANCE_FUNCTION_ZENKASHIKI:
        {
          distance = distance + ( m_fld_cam_anm_distance_arg.zenkashiki.limit - distance ) * m_fld_cam_anm_distance_arg.zenkashiki.bairitsu;
          b32 is_end = false; 
          if( m_fld_cam_anm_distance_arg.zenkashiki.limit < m_fld_cam_anm_distance_end_value )
          {
            if( distance <= m_fld_cam_anm_distance_end_value )
            {
              is_end = true;
            }
          }
          else
          {
            if( distance >= m_fld_cam_anm_distance_end_value )
            {
              is_end = true;
            }
          }
          if( is_end )
          {
            distance = m_fld_cam_anm_distance_end_value;
            m_fld_cam_anm_state_bit_flag &= (~FLD_CAM_ANM_STATE_DISTANCE_BIT);
          }
        }
        break;
      default : GFL_ASSERT(0);
      }
      m_pCamera->SetParameterDistance(distance);
    }
  }

  //-----------------------------------------------------------------------------
  /**
   *	@brief  JItZbgAj[VAp[^PP̏
   *
   *	@param	f32* distance ݂̒l
   *	@param	f32 tar ړIl
   *
   *	@retval true:I
   */
  //-----------------------------------------------------------------------------
  bool CFieldCameraAnimation::CalculateFldCamAnmOffsetPosParam( f32* distance, const f32 tar )
  {
    f32 limit;
  
    if( tar > *distance )
    {
      limit = tar + m_fld_cam_anm_offsetpos_arg.zenkashiki.limit; 
    }
    else 
    {
      limit = tar - m_fld_cam_anm_offsetpos_arg.zenkashiki.limit; 
    }
  
    *distance += ( limit - *distance ) * m_fld_cam_anm_offsetpos_arg.zenkashiki.bairitsu;
  
    if( limit < tar )
    {
      if( *distance <= tar )
      {
        return true;
      }
    }
    else 
    {
      if( *distance >= tar )
      {
        return true;
      }
    }

    return false;
  }

  void CFieldCameraAnimation::CalculateFldCamAnmOffsetPos(void)
  {
    if( this->IsExecutingFldCamAnmOffsetPos() )
    {
      gfl::math::VEC3 camtar;
      gfl::math::VEC3 camofs;
        
      m_pCamera->GetTargetPosition( camtar );

      switch( m_fld_cam_anm_offsetpos_function )
      {
      //case FLD_CAM_ANM_OFFSETPOS_FUNCTION_LINER:
      //  {
      //  }
      //  break;
      case FLD_CAM_ANM_OFFSETPOS_FUNCTION_ZENKASHIKI:
        {
          gfl::math::VEC3 campos;
          m_pCamera->GetCameraPosition( campos );
        
          camofs = campos - camtar; 
        
          b32 is_end = true; 
        
          if( !CalculateFldCamAnmOffsetPosParam( &camofs.x, m_fld_cam_anm_offsetpos_end_pos.x ) )
          {
            is_end =false;
          }
          if( !CalculateFldCamAnmOffsetPosParam( &camofs.y, m_fld_cam_anm_offsetpos_end_pos.y ) )
          {
            is_end =false;
          }
          if( !CalculateFldCamAnmOffsetPosParam( &camofs.z, m_fld_cam_anm_offsetpos_end_pos.z ) )
          {
            is_end =false;
          }
        
          if( is_end )
          {
            camofs = m_fld_cam_anm_offsetpos_end_pos;
            m_fld_cam_anm_state_bit_flag &= (~FLD_CAM_ANM_STATE_OFFSETPOS_BIT);
          }
        }
        break;
      default : GFL_ASSERT(0);
      }

      m_pCamera->SetCameraPosition( camtar + camofs );
    }
  }

  void CFieldCameraAnimation::CalculateFldCamAnmTrans(void)
  {
    if( this->IsExecutingFldCamAnmTrans() )
    {
      gfl::math::VEC3 pos;
      gfl::math::VEC3 tar;
      switch( m_fld_cam_anm_offsetpos_function )
      {
      case FLD_CAM_ANM_TRANS_FUNCTION_LINER:
        {
          m_fld_cam_anm_trans_cnt++;
          if( m_fld_cam_anm_trans_cnt >= m_fld_cam_anm_trans_arg.liner.frame )
          {
            m_fld_cam_anm_state_bit_flag &= (~FLD_CAM_ANM_STATE_TRANS_BIT);
          }
          f32 max = m_fld_cam_anm_trans_arg.liner.frame;
          f32 per = m_fld_cam_anm_trans_cnt / max;
        
          gfl::math::VEC3 start_pos = m_fld_cam_anm_trans_start_pos;
          gfl::math::VEC3 end_pos = m_fld_cam_anm_trans_end_pos;
          gfl::math::VEC3Lerp( &pos, &start_pos, &end_pos, per );
        
          gfl::math::VEC3 start_tar = m_fld_cam_anm_trans_start_tar;
          gfl::math::VEC3 end_tar = m_fld_cam_anm_trans_end_tar;
          gfl::math::VEC3Lerp( &tar, &start_tar, &end_tar, per );
        }
        break;
      default : GFL_ASSERT(0);
      }
        
      m_pCamera->SetCameraPosition(pos);
      m_pCamera->SetTargetPosition(tar);
    }
  }

  /* -------------------------------------------------------------------------*/
  /**
   * @brief UAj[V
   */
  /* -------------------------------------------------------------------------*/
  void CFieldCameraAnimation::CalculateFldCamAnmShake(void)
  {
    if( this->IsExecutingFldCamAnmShake() )
    {
      // U
      u32 rad = (m_fld_cam_anm_shake_now_sync * 0x10000) / m_fld_cam_anm_shake_arg.param.sync;
      // @todo nn::math𒼐ڎgȂ悤ɕύX
      gfl::math::VEC3 position_offset;
      m_pCamera->GetParameterPositionOffset(&position_offset);
      position_offset = m_fld_cam_anm_shake_ofs * nn::math::SinIdx(rad);
      m_pCamera->SetParameterPositionOffset(m_fld_cam_anm_shake_start_ofs+position_offset);

      // i߂
      ++m_fld_cam_anm_shake_now_sync;

      // UJEg
      if (m_fld_cam_anm_shake_now_sync >= m_fld_cam_anm_shake_arg.param.sync)
      {
        m_fld_cam_anm_now_time--;
        m_fld_cam_anm_shake_now_sync = 0;
      }
      // I
      if (m_fld_cam_anm_now_time <= 0)
      {
        m_fld_cam_anm_shake_now_sync = 0;
        m_fld_cam_anm_state_bit_flag &= (~FLD_CAM_ANM_STATE_SHAKE_BIT);
        m_pCamera->SetParameterPositionOffset(m_fld_cam_anm_shake_start_ofs);
      }
    }
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief ftHgZbeBOAj[V
   */
  //-----------------------------------------------------------------------------
  void CFieldCameraAnimation::CalculateFldCamAnmSetting(void)
  {
    if( this->IsExecutingFldCamAnmSetting() )
    {
      f32 rate;
      ++m_fld_cam_anm_setting_now_time;
      if( m_fld_cam_anm_setting_now_time <= m_fld_cam_anm_setting_end.frame ){

        // [g߂
        rate = getEasing( static_cast<f32>(m_fld_cam_anm_setting_now_time), static_cast<f32>(m_fld_cam_anm_setting_end.frame) );
        if( rate > 1.0f ){
          rate = 1.0f;
        }

        // t[̃ZbeBO߂B
        FieldCameraSetting::FieldCameraSettingData data;

        data.offset_y = m_fld_cam_anm_setting_start.offset_y + (m_fld_cam_anm_setting_end.end.offset_y - m_fld_cam_anm_setting_start.offset_y) * rate;
        data.rotate_x = m_fld_cam_anm_setting_start.rotate_x + (m_fld_cam_anm_setting_end.end.rotate_x - m_fld_cam_anm_setting_start.rotate_x) * rate;
        data.rotate_y = m_fld_cam_anm_setting_start.rotate_y + (m_fld_cam_anm_setting_end.end.rotate_y - m_fld_cam_anm_setting_start.rotate_y) * rate;
        data.near = m_fld_cam_anm_setting_start.near + (m_fld_cam_anm_setting_end.end.near - m_fld_cam_anm_setting_start.near) * rate;
        data.far = m_fld_cam_anm_setting_start.far + (m_fld_cam_anm_setting_end.end.far - m_fld_cam_anm_setting_start.far) * rate;
        data.fovy = m_fld_cam_anm_setting_start.fovy + (m_fld_cam_anm_setting_end.end.fovy - m_fld_cam_anm_setting_start.fovy) * rate;
        data.distance = m_fld_cam_anm_setting_start.distance + (m_fld_cam_anm_setting_end.end.distance - m_fld_cam_anm_setting_start.distance) * rate;
        data.depth_range = m_fld_cam_anm_setting_start.depth_range + (m_fld_cam_anm_setting_end.end.depth_range - m_fld_cam_anm_setting_start.depth_range) * rate;
        data.depth_level = m_fld_cam_anm_setting_start.depth_level + (m_fld_cam_anm_setting_end.end.depth_level - m_fld_cam_anm_setting_start.depth_level) * rate;
        data.depth_f_flag = m_fld_cam_anm_setting_end.end.depth_f_flag;
        data.depth_f = m_fld_cam_anm_setting_start.depth_f + (m_fld_cam_anm_setting_end.end.depth_f - m_fld_cam_anm_setting_start.depth_f) * rate;

        // depth_rangeȊO͔f
        if( m_pCamera->m_camera_area ) {
          m_pCamera->m_camera_area->SetCameraSetting( data );  // JZbeBOɂf
        }
        m_pCamera->SetSettingDataForDefault( &data, NULL );
      }
    
      // I
      if( m_fld_cam_anm_setting_now_time >= m_fld_cam_anm_setting_end.frame ){
        m_fld_cam_anm_state_bit_flag &= (~FLD_CAM_ANM_STATE_SETTING_BIT);
      }
    }
  }

} // namespace field

/*  EOF  */





