//============================================================================================
/**
 * @file		BattleRecorderSaveData.cpp
 * @brief		ogR[_[Z[uf[^
 * @author	sogabe
 * @date		12.09.20
 */
//============================================================================================

#include "battle/btl_net.h"
#include "savedata/BattleRecorderSaveData.h"

namespace savedata {  

//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 */
//--------------------------------------------------------------------------------------------
BattleRecorderSaveData::BattleRecorderSaveData( gfl::heap::HeapBase* heap )
{
  mHeap          = heap;
  mBattleRecData = ( BATTLE_REC_DATA* )GflHeapAllocMemory( heap, sizeof( BATTLE_REC_DATA ) );
  mIsLoadData    = false;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
BattleRecorderSaveData::~BattleRecorderSaveData()
{ 
  GflHeapFreeMemory( mBattleRecData );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		BattleSetupParamRegulationogR[_[Z[uf[^𐶐
 *
 * @param[in] bsp BattleSetupParam
 * @param[in] reg Regulation
 */
//--------------------------------------------------------------------------------------------
void  BattleRecorderSaveData::CreateSaveData( const BATTLE_SETUP_PARAM* bsp, const regulation::Regulation::REGULATION* reg )
{ 
  //^Z[uf[^wb_[
  //ΐ{ݎ
  mBattleRecData->upload.header.category     = reg->category;
  //ΐ탂[h
  mBattleRecData->upload.header.rule         = reg->btl_rule;
  mBattleRecData->upload.header.magic_key    = REC_MAGIC_KEY;
  //tog
  mBattleRecData->upload.header.sakasaBattle = reg->reverse;

  for( s32 i = 0 ; i < regulation::Regulation::WIFI_PLAYER_TIX_CUPNAME_MOJINUM + gamesystem::EOM_LEN ; i++ )
  { 
    //JbvP
    mBattleRecData->upload.header.cupname1[ i ] = reg->cupname1[ i ];
    //JbvQ
    mBattleRecData->upload.header.cupname2[ i ] = reg->cupname2[ i ];
  }

  { 
    gfl::str::StrBuf* str = GFL_NEW_LOW( mHeap ) gfl::str::StrBuf( pml::PERSON_NAME_BUFFER_SIZE, mHeap );
    for( s32 i = 0 ; i < BTL_CLIENT_NUM ; i++ )
    { 
      //ւf[^
      mBattleRecData->upload.header.pssIcon[ i ].fashionData  = bsp->playerStatus[ i ]->GetDressUpData();
      //PSSACRIDiFBEm荇j
      mBattleRecData->upload.header.pssIcon[ i ].iconFriend   = bsp->playerStatus[ i ]->GetPssIconForFriend();
      //PSSACRIDiႢj
      mBattleRecData->upload.header.pssIcon[ i ].iconStranger = bsp->playerStatus[ i ]->GetPssIconForStranger();
  
      bsp->playerStatus[ i ]->GetNameString( str );
      str->PutStr( mBattleRecData->upload.header.name[ i ], pml::PERSON_NAME_BUFFER_SIZE );
    }
    GFL_DELETE str;
  }

  //ʏƃ}`Ń|Pp[eB̎oႤ
  { 
    if( bsp->multiMode )
    { 
      for( s32 i = 0 ; i < pml::PokeParty::MAX_MEMBERS / 2; i++ )
      { 
        const pml::pokepara::PokemonParam* pp_player1 = bsp->party[ BTL_CLIENT_PLAYER ]->GetMemberPointerConst( i );
        const pml::pokepara::PokemonParam* pp_enemy1  = bsp->party[ BTL_CLIENT_ENEMY1 ]->GetMemberPointerConst( i );
        const pml::pokepara::PokemonParam* pp_player2 = bsp->party[ BTL_CLIENT_PARTNER ]->GetMemberPointerConst( i );
        const pml::pokepara::PokemonParam* pp_enemy2  = bsp->party[ BTL_CLIENT_ENEMY2 ]->GetMemberPointerConst( i );
  
        mBattleRecData->upload.header.mons_no[ i ] = pp_player1->GetMonsNo();
        mBattleRecData->upload.header.form_no[ i ] = pp_player1->GetFormNo();
        mBattleRecData->upload.header.gender[ i ]  = pp_player1->GetSex();
        mBattleRecData->upload.header.rare[ i ]    = pp_player1->IsRare();

        mBattleRecData->upload.header.mons_no[ i + PP_HALF ] = pp_player2->GetMonsNo();
        mBattleRecData->upload.header.form_no[ i + PP_HALF ] = pp_player2->GetFormNo();
        mBattleRecData->upload.header.gender[ i + PP_HALF ]  = pp_player2->GetSex();
        mBattleRecData->upload.header.rare[ i + PP_HALF ]    = pp_player2->IsRare();

        mBattleRecData->upload.header.mons_no[ i + PP_FULL ] = pp_enemy1->GetMonsNo();
        mBattleRecData->upload.header.form_no[ i + PP_FULL ] = pp_enemy1->GetFormNo();
        mBattleRecData->upload.header.gender[ i + PP_FULL ]  = pp_enemy1->GetSex();
        mBattleRecData->upload.header.rare[ i + PP_FULL ]    = pp_enemy1->IsRare();

        mBattleRecData->upload.header.mons_no[ i + PP_FULL + PP_HALF ] = pp_enemy2->GetMonsNo();
        mBattleRecData->upload.header.form_no[ i + PP_FULL + PP_HALF ] = pp_enemy2->GetFormNo();
        mBattleRecData->upload.header.gender[ i + PP_FULL + PP_HALF ]  = pp_enemy2->GetSex();
        mBattleRecData->upload.header.rare[ i + PP_FULL + PP_HALF ]    = pp_enemy2->IsRare();
      }
    }
    else
    { 
      for( s32 i = 0 ; i < pml::PokeParty::MAX_MEMBERS ; i++ )
      { 
        const pml::pokepara::PokemonParam* pp_player = bsp->party[ BTL_CLIENT_PLAYER ]->GetMemberPointerConst( i );
        const pml::pokepara::PokemonParam* pp_enemy  = bsp->party[ BTL_CLIENT_ENEMY1 ]->GetMemberPointerConst( i );

        mBattleRecData->upload.header.mons_no[ i ] = pp_player->GetMonsNo();
        mBattleRecData->upload.header.form_no[ i ] = pp_player->GetFormNo();
        mBattleRecData->upload.header.gender[ i ]  = pp_player->GetSex();
        mBattleRecData->upload.header.rare[ i ]    = pp_player->IsRare();

        mBattleRecData->upload.header.mons_no[ i + PP_FULL ] = pp_enemy->GetMonsNo();
        mBattleRecData->upload.header.form_no[ i + PP_FULL ] = pp_enemy->GetFormNo();
        mBattleRecData->upload.header.gender[ i + PP_FULL ]  = pp_enemy->GetSex();
        mBattleRecData->upload.header.rare[ i + PP_FULL ]    = pp_enemy->IsRare();
      }
    }
  }

  // @todo AƂ΂̂BATTLE_SETUP_PARAMɂRegulationɂ͂ĂȂ
  //mBattleRecData->upload.header.battle_counter; //A

  //ʐM͐ڑ}V̍ŐVo[WɂȂ̂ŁA擾@Ⴄ
  if( bsp->commMode )
  { 
    mBattleRecData->upload.header.server_version = bsp->commServerVer;
  }
  else
  { 
    mBattleRecData->upload.header.server_version = btl::net::GetServerVersion();
  }

  //pfBONA
  { 
    mBattleRecData->upload.header.padding = 0;
    for( s32 i = 0 ; i < 12 ; i++ )
    { 
      mBattleRecData->upload.header.padding_work[ i ] = 0;   //\i12oCgKvǂ͕siWBjj
    }
  }

  //CRC𐶐
  mBattleRecData->upload.header.crc = nn::util::Crc32::Calculate( &mBattleRecData->upload.header,
                                                                  sizeof( BATTLE_REC_HEADER ) -
                                                                  sizeof( mBattleRecData->upload.header.crc ) );

  //^Z[uf[^{̐
  //_̎
  mBattleRecData->upload.body.setupSubset.recRandContext = bsp->recRandContext;

  //ʍ\zp
  mBattleRecData->upload.body.setupSubset.fieldSituation = bsp->fieldSituation;

  //ogop[^
  mBattleRecData->upload.body.setupSubset.battleEffect   = bsp->btlEffData;

  //[URtBO
  memcpy( &mBattleRecData->upload.body.setupSubset.config, bsp->configData, sizeof( CONFIG ) );

  //V[^[gpp[^
  mBattleRecData->upload.body.setupSubset.shooterBitWork = bsp->shooterBitWork;

  //og[
  mBattleRecData->upload.body.setupSubset.competitor   = bsp->competitor;
  mBattleRecData->upload.body.setupSubset.rule         = bsp->rule;
  mBattleRecData->upload.body.setupSubset.multiMode    = bsp->multiMode;
  mBattleRecData->upload.body.setupSubset.skyBattle    = bsp->bSkyBattle;
  mBattleRecData->upload.body.setupSubset.sakasaBattle = bsp->bSakasaBattle;

  //fobOptO@@todo ȂœĂ邩킩ȂiWBj
  mBattleRecData->upload.body.setupSubset.debugFlag = bsp->DebugFlagBit;
  //ʐMΐ펞̗̎ʒu
  mBattleRecData->upload.body.setupSubset.commPos = bsp->commPos;
  //pfBO
  mBattleRecData->upload.body.setupSubset.padding = 0;

  //^f[^
  mBattleRecData->upload.body.opBuffer.size = bsp->recDataSize;
  memcpy( mBattleRecData->upload.body.opBuffer.buffer, bsp->recBuffer, BTLREC_OPERATION_BUFFER_SIZE );

  //莝|P
  { 
    for( s32 i = 0 ; i < BTL_CLIENT_NUM ; i++ )
    { 
      GFL_ASSERT( SerializeDataSize == bsp->party[ i ]->GetSerializeDataSize() );
      bsp->party[ i ]->Serialize( mBattleRecData->upload.body.rec_party[ i ].member );
    }
  }
#if 0
  //g[i[f[^
  mBattleRecData->upload.body
  BTLREC_CLIENT_STATUS    clientStatus[ BTL_CLIENT_NUM ];

  mBattleRecData->upload.body
  u16                     magic_key;
  mBattleRecData->upload.body
  u16                     padding;

  mBattleRecData->upload.body莝
  u32                     crc;

  //SDJ[hɃZ[utb^f[^
  mBattleRecData->
  bool                    upload_flag;
  mBattleRecData->
  u32                     dataID;
  mBattleRecData->
  u32                     playCount;
  mBattleRecData->
  u32                     registDay;
#endif

  mIsLoadData = true;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		SDJ[hogR[_[Z[uf[^[h
 *
 * @param[in] name  t@C
 */
//--------------------------------------------------------------------------------------------
void  BattleRecorderSaveData::LoadData( const char* name )
{ 
  // @todo SDJ[hǂݍ݂̂Ȃɂ̏

  mIsLoadData = true;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ǂݍ񂾃ogR[_[f[^BattleSetupParam𐶐
 *
 * @param[in] bsp BattleSetupParam
 *
 * @retval  łǂitrue:ł@falseFłȂj
 */
//--------------------------------------------------------------------------------------------
bool  BattleRecorderSaveData::CreateBattleSetupParam( BATTLE_SETUP_PARAM* bsp )
{ 
  if( mIsLoadData == false ) return false;

  // @todo BATTLE_SETUP_PARAM𐶐Ȃɂ̏

  return true;
}

} //namespace savedata
