//===================================================================
/**
 * @file    actor_h3d_model.h
 * @brief   H3DfgpAN^[
 * @author  soga
 * @date    12.09.27
*/
//===================================================================

#if !defined(__ACTOR_H3D_MODEL_H__)
#define  __ACTOR_H3D_MODEL_H__

#include  "ActorModelBase.h"
#include  "app/util/app_util_3d.h"

namespace actor {

  class ActorH3DModel : public  actor::ActorModelBase
  { 
    GFL_FORBID_COPY_AND_ASSIGN( ActorH3DModel );

    #define NO_MODEL_ID ( 0xffffffff )

    private:
    app::util::G3DUtil* mG3DUtil;
    app::util::Heap*    mHeap;
    u32                 mModelID;

    public:
    //----------------------------------------------------------------------------
    /**
     *	@brief    RXgN^
     */
    //-----------------------------------------------------------------------------
    ActorH3DModel();

    //-----------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //-----------------------------------------------------------------------------
    virtual ~ActorH3DModel();

    //-----------------------------------------------------------------------------
    /**
     * @brief Update֐i]VEC3Łj
     */
    //-----------------------------------------------------------------------------
    virtual void  Update( const gfl::math::VEC3& trans, const gfl::math::VEC3& rotate, const gfl::math::VEC3& scale );

    //-----------------------------------------------------------------------------
    /**
     * @brief Update֐i]MTX34Łj
     */
    //-----------------------------------------------------------------------------
    virtual void  Update( const gfl::math::VEC3& trans, const gfl::math::MTX34& mtx, const gfl::math::VEC3& scale );

    //-----------------------------------------------------------------------------
    /**
     * @brief Aj[VZbg
     *
     * @param[in] anm_no ZbgAj[VNo
     * @param[in] is_loop   [v邩ǂH(true:loop false:no_loop)
     */
    //-----------------------------------------------------------------------------
    virtual void  SetAnime( int anm_no, bool is_loop = true );

    //-----------------------------------------------------------------------------
    /**
     * @brief Aj[VI`FbN
     *
     * @param[in] none
     *
     * @retval  true:I false:p
     */
    //-----------------------------------------------------------------------------
    virtual bool  IsFinishAnime( void );

    //-----------------------------------------------------------------------------
    /**
     * @brief AddScene
     */
    //-----------------------------------------------------------------------------
    virtual void  AddSceneModel( void );

    //-----------------------------------------------------------------------------
    /**
     * @brief RemoveScene
     */
    //-----------------------------------------------------------------------------
    virtual void  RemoveSceneModel( void );

    //-----------------------------------------------------------------------------
    /**
     * @brief SetVisible
     *
     * @param[in] flag  true:\@false:\
     */
    //-----------------------------------------------------------------------------
    virtual void  SetVisible( bool flag );

    //-----------------------------------------------------------------------------
    /**
     * @brief GetVisible
     *
     * @retval  true:\ false:\
     */
    //-----------------------------------------------------------------------------
    virtual bool  GetVisible( void ) const;

    //-----------------------------------------------------------------------------
    /**
     * @brief SetConstantColor
     *
     * @param[in] col ZbgJ[
     * @param[in] no  ZbgRX^gJ[io[
     */
    //-----------------------------------------------------------------------------
    virtual void  SetConstantColor( gfl::grp::ColorF32 col, int col_no = 0 );

    //-----------------------------------------------------------------------------
    /**
     * @brief GetNodePosition
     *
     * @param[in]   node  擾m[hCfbNX
     * @param[out]  pos   擾|WV̊i[
     */
    //-----------------------------------------------------------------------------
    virtual void  GetNodePosition( int node, gfl::math::VEC3* pos );

    //-----------------------------------------------------------------------------
    /**
     * @brief Model
     *
     * @param[in] util    G3dUtil
     * @param[in] af      f\[XArcFile
     * @param[in] mdlID   fARCDATID
     * @param[in] heap    app::util::Heap
     * @param[in] anm     Ajf[^
     * @param[in] anmMax  Ajf[^̐
     */
    //-----------------------------------------------------------------------------
    void  CreateModel( app::util::G3DUtil* util, gfl::fs::ArcFile* af, gfl::fs::ArcFile::ARCDATID mdlID, app::util::Heap* heap, app::util::G3DUtil::ANIME_DATA* anm, u32 anmMax );

  };

} // namespace actor

#endif
