//===================================================================
/**
 * @file    actor_h3d_model.cpp
 * @brief   G3DUtilH3DfgpAN^[
 * @author  soga
 * @date    12.09.27
*/
//===================================================================

#include  "actor_h3d_model.h"

namespace actor {

//----------------------------------------------------------------------------
/**
 *	@brief    RXgN^
 */
//-----------------------------------------------------------------------------
ActorH3DModel::ActorH3DModel() :
  ActorModelBase(),
  mG3DUtil( NULL ),
  mHeap( NULL ),
  mModelID( NO_MODEL_ID )
{
}

//-----------------------------------------------------------------------------
/**
 * @brief fXgN^
 */
//-----------------------------------------------------------------------------
ActorH3DModel::~ActorH3DModel()
{ 
  if( mModelID != NO_MODEL_ID )
  { 
    mG3DUtil->DelH3dModel( mModelID );
    mModelID = NO_MODEL_ID;
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief Update֐i]VEC3Łj
 */
//-----------------------------------------------------------------------------
void  ActorH3DModel::Update( const gfl::math::VEC3& trans, const gfl::math::VEC3& rotate, const gfl::math::VEC3& scale )
{ 
  if( mModelID != NO_MODEL_ID )
  { 
    gfl::grp::g3d::H3dModel* model = mG3DUtil->GetH3dModel( mModelID );
    model->SetTranslate( trans );
    model->SetRotateXYZ( rotate );
    model->SetScale( scale );
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief Update֐i]MTX34Łj
 */
//-----------------------------------------------------------------------------
void  ActorH3DModel::Update( const gfl::math::VEC3& trans, const gfl::math::MTX34& mtx, const gfl::math::VEC3& scale )
{ 
  if( mModelID != NO_MODEL_ID )
  { 
    gfl::grp::g3d::H3dModel* model = mG3DUtil->GetH3dModel( mModelID );
  
    model->SetTranslate( trans );
    model->SetRotateMatrix( mtx );
    model->SetScale( scale );
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief Aj[VZbg
 *
 * @param[in] anm_no ZbgAj[VNo
 * @param[in] is_loop   [v邩ǂH(true:loop false:no_loop)
 */
//-----------------------------------------------------------------------------
void  ActorH3DModel::SetAnime( int anm_no, bool is_loop )
{ 
  // @todo ƊÕ[vw𔽉f
  GFL_UNUSED( is_loop );
  if( mModelID != NO_MODEL_ID )
  { 
    mG3DUtil->ChangeH3dModelAnime( mModelID, anm_no, mHeap );
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief Aj[VI`FbN
 *
 * @param[in] none
 *
 * @retval  true:I false:p
 */
//-----------------------------------------------------------------------------
bool  ActorH3DModel::IsFinishAnime( void )
{ 
  bool  result = true;
  if( mModelID != NO_MODEL_ID )
  { 
    result = mG3DUtil->IsFinishH3dModelAnime( mModelID );
  }
  return result;
}

//-----------------------------------------------------------------------------
/**
 * @brief AddScene
 */
//-----------------------------------------------------------------------------
void  ActorH3DModel::AddSceneModel( void )
{ 
  if( mModelID != NO_MODEL_ID )
  { 
    gfl::grp::g3d::H3dModel* model = mG3DUtil->GetH3dModel( mModelID );
  
    model->SetTreeFlag( true );
    // @todo |PfƋƃGbW㏑̂ŎgGbWLɂKvH
    // TAP̃fGbWLɂƐ^ɂȂĂ܂̂ŁA̓RgAEg
    //mG3DUtil->GetScene()->SwitchEdgeMapModel( mG3DUtil->GetH3dModel( mModelID ), true );
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief RemoveScene
 */
//-----------------------------------------------------------------------------
void  ActorH3DModel::RemoveSceneModel( void )
{ 
  if( mModelID != NO_MODEL_ID )
  { 
    gfl::grp::g3d::H3dModel* model = mG3DUtil->GetH3dModel( mModelID );
  
    model->SetTreeFlag( false );
    SetVisible( false );
    // @todo |PfƋƃGbW㏑̂ŎgGbWLɂKvH
    // TAP̃fGbWLɂƐ^ɂȂĂ܂̂ŁA̓RgAEg
    //mG3DUtil->GetScene()->SwitchEdgeMapModel( mG3DUtil->GetH3dModel( mModelID ), false );
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief SetVisible
 *
 * @param[in] flag  true:\@false:\
 */
//-----------------------------------------------------------------------------
void  ActorH3DModel::SetVisible( bool flag )
{ 
  if( mModelID != NO_MODEL_ID )
  { 
    gfl::grp::g3d::H3dModel* model = mG3DUtil->GetH3dModel( mModelID );
  
    model->SetVisible( flag );
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief GetVisible
 *
 * @retval  true:\ false:\
 */
//-----------------------------------------------------------------------------
bool  ActorH3DModel::GetVisible( void ) const
{
  bool result = false;

  if( mModelID != NO_MODEL_ID )
  { 
    gfl::grp::g3d::H3dModel* model = mG3DUtil->GetH3dModel( mModelID );
  
    result = model->IsVisible();
  }

  return result;
}

//-----------------------------------------------------------------------------
/**
 * @brief SetConstantColor
 *
 * @param[in] col ZbgJ[
 * @param[in] no  ZbgRX^gJ[io[
 */
//-----------------------------------------------------------------------------
void  ActorH3DModel::SetConstantColor( gfl::grp::ColorF32 col, int col_no )
{ 
  if( mModelID != NO_MODEL_ID )
  { 
    gfl::grp::g3d::H3dModel* model = mG3DUtil->GetH3dModel( mModelID );
  
    for( s32 no = 0 ; no < model->GetMaterialCount() ; no++ )
    { 
      model->SetMaterialColorConstant( no, col_no, col );
    }
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief GetNodePosition
 *
 * @param[in]   node  擾m[hCfbNX
 * @param[out]  pos   擾|WV̊i[
 */
//-----------------------------------------------------------------------------
void  ActorH3DModel::GetNodePosition( int node, gfl::math::VEC3* pos )
{ 
  if( mModelID != NO_MODEL_ID )
  { 
    gfl::grp::g3d::H3dModel* model = mG3DUtil->GetH3dModel( mModelID );

    gfl::math::MTX34* mtx = model->GetBoneMatrixPointerOfWorldMatrixPose( node );
    pos->x = mtx->_03;
    pos->y = mtx->_13;
    pos->z = mtx->_23;
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief Model
 */
//-----------------------------------------------------------------------------
void  ActorH3DModel::CreateModel( app::util::G3DUtil* util, gfl::fs::ArcFile* af, gfl::fs::ArcFile::ARCDATID mdlID, app::util::Heap* heap, app::util::G3DUtil::ANIME_DATA* anm, u32 anmMax )
{ 
  // @todo G3dUtil̃\[XǗ@\쐬i\[X̎g܂킵ɑΉł͂j
  mG3DUtil = util;
  mHeap    = heap;
  // @todo f\[X͈k݂̂ǁA񈳏kɂΉ邩v
  mModelID = mG3DUtil->AddH3dModel( af, mdlID, heap, app::util::G3DUtil::ADD_MODEL_ID_FREE, anm, anmMax, true );
  this->RemoveSceneModel();
}

} // namespace actor
