//============================================================================================
/**
 * @file		BattleRecorderSaveData.h
 * @brief		ogR[_[Z[uf[^
 * @author	sogabe
 * @date		12.09.20
 */
//============================================================================================
#if !defined(__BATTLE_RECORDER_SAVE_DATA_H__)
#define __BATTLE_RECORDER_SAVE_DATA_H__

#include  "battle/battle_SetupParam.h"

namespace savedata {  

  class BattleRecorderSaveData
  { 
    GFL_FORBID_COPY_AND_ASSIGN( BattleRecorderSaveData );

    private:

    static  const u16 REC_MAGIC_KEY = 0xe281;
    static  const s32 PP_HALF = pml::PokeParty::MAX_MEMBERS / 2; 
    static  const s32 PP_FULL = pml::PokeParty::MAX_MEMBERS; 
    static  const size_t  SerializeDataSize = pml::pokepara::PokemonParam::DATASIZE * pml::PokeParty::MAX_MEMBERS; 

    //BATTLE_SETUP_PARAMɃZbg邽߂ɕKvȍŒ̗vf𒊏o @todo BATTLE_SETUP_PARAM̍XVɒǐKv
    struct  BTLREC_SETUP_SUBSET
    { 
      gfl::math::Random::Context  recRandContext; //_̎
      BTL_FIELD_SITUATION         fieldSituation; //ʍ\zp
      BSP_BATTLE_EFFECT           battleEffect;   //ogop[^
      CONFIG                      config;         //[URtBO
      SHOOTER_ITEM_BIT_WORK       shooterBitWork; //V[^[gpp[^
      BtlCompetitor               competitor;
      BtlRule                     rule;
      BtlMultiMode                multiMode;
      bool                        skyBattle;
      bool                        sakasaBattle;
      u16                         debugFlag;      //fobOptO@@todo ȂœĂ邩킩ȂiWBj
      u8                          commPos;
      u8                          padding;
    };

    //NCAgeۑobt@
    struct BTLREC_OPERATION_BUFFER
    { 
      u32 size;
      u8  buffer[ BTLREC_OPERATION_BUFFER_SIZE ];
    };

    //^pPokeParty
    struct  BTLREC_POKEPARTY
    { 
      u8  member[ SerializeDataSize ]; 
    };

    //g[i[f[^ @todo battle_SetupParam.hBSP_TRAINER_DATAƍ킹Kv܂
    struct  BTLREC_TRAINER_STATUS
    { 
      u32     tr_id;
      u32     ai_bit;
      u32     btl_eff_id;
      u16     tr_type;           //g[i[^Cviς񂱂AȂǁj
      u16     tr_group;          //g[i[O[vi[_[A`sIAlVAȂǁj
    
      u16     use_item[ BSP_TRAINERDATA_ITEM_MAX ];      //gp

      gfl::str::STRCODE name[ pml::PERSON_NAME_BUFFER_SIZE ]; //g[i[

      //ogTuEFC Wifi-DLg[i[Ƃ̑ΐ펞ɂ̂ݕKv
      PMS_DATA  win_word;   //퓬IbZ[W
      PMS_DATA  lose_word;  //퓬IbZ[W
    };

    //NCAgXe[^X
    typedef enum
    { 
      BTLREC_CLIENT_STATUS_NONE,
      BTLREC_CLIENT_STATUS_PLAYER,
      BTLREC_CLIENT_STATUS_TRAINER,
    }BtlRecClientStatusType;

    struct BTLREC_CLIENT_STATUS
    { 
      BtlRecClientStatusType  type;
      union
      { 
        u8                    player[ savedata::MyStatus::SERIALIZE_DATA_SIZE ];
        BTLREC_TRAINER_STATUS trainer;
      };
    };

    //^Z[uf[^{
    struct  BATTLE_REC_BODY
    { 
      BTLREC_SETUP_SUBSET     setupSubset;
      BTLREC_OPERATION_BUFFER opBuffer;

      BTLREC_POKEPARTY        rec_party[ BTL_CLIENT_NUM ];
      BTLREC_CLIENT_STATUS    clientStatus[ BTL_CLIENT_NUM ];

      u16                     magic_key;
      u16                     padding;

      u32                     crc;
    };

    //^Z[uf[^wb_[

    typedef xy_system::dress_up::SaveFashionBuffer  DressupFashionData;

    struct  BTLREC_PSS_ICON
    { 
      DressupFashionData  fashionData;
      u8                  iconFriend;     //PSSACRIDiFBEm荇j
      u8                  iconStranger;   //PSSACRIDiႢj
    };

    struct  BATTLE_REC_HEADER
    { 
      u8                category;  //ΐ{ݎ regulation::Regulation::CATEGORY_TYPE
      u8                rule;      //ΐ탂[h   regulation::Regulation::BATTLE_TYPE
      u16               magic_key;

      bool              sakasaBattle;

      gfl::str::STRCODE cupname1[ regulation::Regulation::WIFI_PLAYER_TIX_CUPNAME_MOJINUM + gamesystem::EOM_LEN ];
      gfl::str::STRCODE cupname2[ regulation::Regulation::WIFI_PLAYER_TIX_CUPNAME_MOJINUM + gamesystem::EOM_LEN ];
      BTLREC_PSS_ICON   pssIcon[ BTL_CLIENT_NUM ];
      gfl::str::STRCODE name[ BTL_CLIENT_NUM ][ pml::PERSON_NAME_BUFFER_SIZE ];
      u16               mons_no[ pml::PokeParty::MAX_MEMBERS * 2 ];
      u8                form_no[ pml::PokeParty::MAX_MEMBERS * 2 ];
      u8                gender[ pml::PokeParty::MAX_MEMBERS * 2 ];
      bool              rare[ pml::PokeParty::MAX_MEMBERS * 2 ];

      u16               battle_counter; //A
      u8                server_version;
      u8                padding;

      u8                padding_work[ 12 ];   //\i12oCgKvǂ͎biWBjj

      u32               crc;
    };

    //T[oɃAbv[hf[^
    struct BATTLE_REC_UPLOAD_DATA
    { 
      BATTLE_REC_HEADER header;
      BATTLE_REC_BODY   body;
    };

    //SDJ[hɃZ[uf[^
    struct BATTLE_REC_DATA
    { 
      BATTLE_REC_UPLOAD_DATA  upload;
      bool                    upload_flag;
      u32                     dataID;
      u32                     playCount;
      u32                     registDay;
    };

    gfl::heap::HeapBase*  mHeap;
    BATTLE_REC_DATA*      mBattleRecData;   //1̃ogR[_[f[^
    bool                  mIsLoadData;      //ogR[_[f[^ǂݍ񂾂ǂ

    public:
    //--------------------------------------------------------------------------------------------
    /**
     * @brief		RXgN^
     */
    //--------------------------------------------------------------------------------------------
    BattleRecorderSaveData( gfl::heap::HeapBase* heap );

    //--------------------------------------------------------------------------------------------
    /**
     * @brief		fXgN^
     */
    //--------------------------------------------------------------------------------------------
    ~BattleRecorderSaveData();

    //--------------------------------------------------------------------------------------------
    /**
     * @brief		BattleSetupParamRegulationogR[_[Z[uf[^𐶐
     *
     * @param[in] bsp BattleSetupParam
     * @param[in] reg Regulation
     */
    //--------------------------------------------------------------------------------------------
    void  CreateSaveData( const BATTLE_SETUP_PARAM* bsp, const regulation::Regulation::REGULATION* reg );

    //--------------------------------------------------------------------------------------------
    /**
     * @brief		SDJ[hogR[_[Z[uf[^[h
     *
     * @param[in] name  t@C
     */
    //--------------------------------------------------------------------------------------------
    void  LoadData( const char* name );

    //--------------------------------------------------------------------------------------------
    /**
     * @brief		ǂݍ񂾃ogR[_[f[^BattleSetupParam𐶐
     *
     * @param[in] bsp BattleSetupParam
     *
     * @retval  łǂitrue:ł@falseFłȂj
     */
    //--------------------------------------------------------------------------------------------
    bool  CreateBattleSetupParam( BATTLE_SETUP_PARAM* bsp );

    //T[oɃAbv[hf[^TCY擾
    u32 GetBattleRecUploadDataSize( void ) { return sizeof( BATTLE_REC_UPLOAD_DATA ); }
    //SDJ[hɃZ[uf[^TCY擾
    u32 GetBattleRecDataSize( void ) { return sizeof( BATTLE_REC_DATA ); }

  };


} //namespace savedata

#endif
