//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		WazaStringSort.cpp
 *	@brief  Z\[g
 *	@author	Toru=Nagihashi
 *	@date		2012.09.27
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <system/sort_string/WazaStringSort.h>
#include <sort_string.gaix>

GFL_NAMESPACE_BEGIN(xy_system)

//-----------------------------------------------------------------------
// 萔
//-----------------------------------------------------------------------
const WazaNo WazaStringSort::SECRET_WAZA_TABLE[ SECRET_WAZA_TABLE_MAX ] =
{
  WAZANO_DAIYASUTOOMU,    // _CXg[
  WAZANO_SUTIIMUBAASUTO,  // X`[o[Xg
  WAZANO_IZIGENHOORU,     // z[
  WAZANO_SAUZANAROO,      // TEUA[
  WAZANO_SAUZANWHEEBU,    // TEUEF[u
};

//-----------------------------------------------------------------------
// Aj
//-----------------------------------------------------------------------
/**
 * @brief RXgN^
 */
WazaStringSort::WazaStringSort() :
  StringSortBinary()
{
}
/**
 * @brief fXgN^
 */
WazaStringSort::~WazaStringSort()
{
}

//-----------------------------------------------------------------------
// ǂݍ
//-----------------------------------------------------------------------
/**
 * @brief ǂݍ
 *
 * @param heap  q[v
 */
void WazaStringSort::Load( gfl::heap::HeapBase * heap )
{
  this->StringSortBinary::Load( heap,GARC_sort_string_waza_initial_index_DAT,GARC_sort_string_waza_sort_table_DAT );
}

/**
 * @brief BZǂ`FbN
 *
 * @param waza  Z
 *
 * @return  trueȂΉBZ  falseȂΉBȂZ
 */
bool WazaStringSort::IsSecretWaza( WazaNo waza ) const
{
  for( int i = 0; i < SECRET_WAZA_TABLE_MAX; ++i )
  {
    if( SECRET_WAZA_TABLE[i] == waza )
    {
      return true;
    }
  }
  
  return false;
}

GFL_NAMESPACE_END(xy_system)
