//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		StringSortBinary.cpp
 *	@brief  \[gp̃oCiǗNX
 *	@author	Toru=Nagihashi
 *	@date		2012.09.27
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <system/sort_string/StringSortBinary.h>

GFL_NAMESPACE_BEGIN(xy_system)

//-----------------------------------------------------------------------
// Aj
//-----------------------------------------------------------------------
/**
 * @brief RXgN^
 */
StringSortBinary::StringSortBinary() :
  m_sort_table(NULL),
  m_sort_table_size(0),
  m_initial_index(NULL),
  m_initial_index_size(0)
{
}
/**
 * @brief fXgN^
 */
StringSortBinary::~StringSortBinary()
{
  GFL_SAFE_DELETE( m_sort_table );
  GFL_SAFE_DELETE( m_initial_index );
}

//-----------------------------------------------------------------------
// ǂݍ
//-----------------------------------------------------------------------
/**
 * @brief ǂݍ
 *
 * @param heap  q[v
 * @param initial_index_datid CjVCfbNXf[^pA[JCuID
 * @param sort_table_datid  \[ge[uf[^pA[JCuID
 */
void StringSortBinary::Load( gfl::heap::HeapBase * heap, gfl::fs::ArcFile::ARCDATID initial_index_datid, gfl::fs::ArcFile::ARCDATID sort_table_datid )
{
  GFL_SAFE_DELETE( m_sort_table );
  GFL_SAFE_DELETE( m_initial_index );

  gfl::fs::ArcFile file( heap, ARCID_STRING_SORT_BINARY, gfl::fs::ArcFile::OPEN );
  m_initial_index_size  = file.GetDataSize( initial_index_datid );
  m_sort_table_size     = file.GetDataSize( sort_table_datid );
 
  m_initial_index = static_cast<u16*>(GflHeapAllocMemoryAlign( heap, m_initial_index_size, 4 ));
  m_sort_table = static_cast<u16*>(GflHeapAllocMemoryAlign( heap, m_sort_table_size, 4 ));
}

//-----------------------------------------------------------------------
// 擾
//-----------------------------------------------------------------------
/**
 * @brief \[gԂ擾
 *
 * @param index ԁi0DxAMAXDxႢj
 *
 * @return giႦΓ̃e[uȂΓNOĂj
 */
u32 StringSortBinary::GetSortOrder( u32 index ) const
{
  GFL_ASSERT( index < this->GetSortOrderMax() );
  return m_sort_table[ index ];
}

/**
 * @brief \[gԂ̍ő擾
 *
 * @return ԍő
 */
u32 StringSortBinary::GetSortOrderMax( void ) const
{
  return m_sort_table_size / sizeof(u16);
}

/**
 * @brief CfbNX擾
 *
 * @param index giႦΓe[uȂΓNOj
 *
 * @return  CfbNXiCfbNX̒`͂ꂼ̃wb_邱Ɓj
 */
u32 StringSortBinary::GetInitialIndex( u32 index ) const
{
  GFL_ASSERT( index < this->GetInitialIndexMax() );
  return m_initial_index[ index ];
}


/**
 * @brief CfbNX̍ő擾
 *
 * @return  CfbNX̍ő
 */
u32 StringSortBinary::GetInitialIndexMax( void ) const
{
  return m_initial_index_size / sizeof(u16);
}

GFL_NAMESPACE_END(xy_system)
