//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		WazaStringSort.h
 *	@brief  Z\[g
 *	@author	Toru=Nagihashi
 *	@date		2012.09.27
 *
 *
 * Eg
 *      uv̋Ẑݎ擾Ƃ͉Lǂ炩łł܂B
 *      ȂA{ӏ́AʏقڕK{ƂȂ܂̂łӂB
 *
 *      PD\[gԂg
 *        \[gԂۏ؂܂B
 *        for( int i= WAZA_SORT_JPN_START_AA; i< WAZA_SORT_JPN_END_AA; ++i )
 *        {
 *          WazaNo  waza  = hoge.GetSortOrder( i );
 *          if( hoge.IsSecretWaza( waza ) )
 *          {
 *            //BZȂ̂ŏO
 *            continue;
 *          }
 *           
 *          //wazaB
 *        }
 *
 *
 *      QDCfbNXg
 *        \[gԂ͍l܂B
 *        for( int i = 1;  i < WAZANO_MAX; ++i )  //1WAZANO_NULLOĂ
 *        {
 *          u32 initial = hoge.GetInitialIndex(i);
 *          
 *          if( initial == WAZA_INITIAL_INDEX_JPN_AA )
 *          {
 *            if( hoge.IsSecretWaza( waza ) )
 *            {
 *              //BZȂ̂ŏO
 *              continue;
 *            }
 *            //waza
 *          }
 *        }
 *
 *
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#pragma once
#if !defined( __WAZASTRINGSORT_H__)
#define __WAZASTRINGSORT_H__
#include <gflib.h>
#include <system/sort_string/StringSortBinary.h>

//e̓CfbNX
#include "./waza_initial_index_jpn.h"
#include "./waza_initial_index_usa.h"
#include "./waza_initial_index_fra.h"
#include "./waza_initial_index_ita.h"
#include "./waza_initial_index_deu.h"
#include "./waza_initial_index_esp.h"
#include "./waza_initial_index_kor.h"

//ẽ\[ge[uoCfbNX
#include "./waza_sort_table_jpn.h"
#include "./waza_sort_table_usa.h"
#include "./waza_sort_table_fra.h"
#include "./waza_sort_table_ita.h"
#include "./waza_sort_table_deu.h"
#include "./waza_sort_table_esp.h"
#include "./waza_sort_table_kor.h"

GFL_NAMESPACE_BEGIN(xy_system)

class WazaStringSort : public StringSortBinary
{
  GFL_FORBID_COPY_AND_ASSIGN(WazaStringSort);
public:
  //-----------------------------------------------------------------------
  // Aj
  //-----------------------------------------------------------------------
  /**
   * @brief RXgN^
   */
  WazaStringSort();
  /**
   * @brief fXgN^
   */
  virtual ~WazaStringSort();
  
  //-----------------------------------------------------------------------
  // ǂݍ
  //-----------------------------------------------------------------------
  /**
   * @brief ǂݍ
   *
   * @param heap  q[v
   */
  void Load( gfl::heap::HeapBase * heap );
  
  //-----------------------------------------------------------------------
  // 擾
  //  擾n֐StringSortBinaryNXpĂ̂
  //  ȉ̂̂g܂B
  //  u32 GetSortOrder( u32 index ) const;
  //  u32 GetSortOrderMax( void ) const;
  //  u32 GetInitialIndex( u32 index ) const;
  //  u32 GetInitialIndexMax( void ) const;
  //-----------------------------------------------------------------------
  /**
   * @brief BZǂ`FbN
   *
   * @param waza  Z
   *
   * @return  trueȂΉBZ  falseȂΉBȂZ
   */
  bool IsSecretWaza( WazaNo waza ) const;
  
private:
  static const int SECRET_WAZA_TABLE_MAX  = 5;
  static const WazaNo SECRET_WAZA_TABLE[ SECRET_WAZA_TABLE_MAX ];
};


GFL_NAMESPACE_END(xy_system)

#endif		// __WAZASTRINGSORT_H__
