//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		TokuseiStringSort.h
 *	@brief  \[g
 *	@author	Toru=Nagihashi
 *	@date		2012.09.27
 *
 *
 * Eg
 *      uv̓̂ݎ擾Ƃ͉Lǂ炩łł܂B
 *      ȂA{ӏ́AʏقڕK{ƂȂ܂̂łӂB
 *
 *      PD\[gԂg
 *        \[gԂۏ؂܂B
 *        for( int i= TOKUSEI_SORT_JPN_START_AA; i< TOKUSEI_SORT_JPN_END_AA; ++i )
 *        {
 *          TokuseiNo  tokusei  = hoge.GetSortOrder( i );
 *          if( hoge.IsSecretTokusei( tokusei ) ) //łÔ
 *          {
 *            //BȂ̂ŏO
 *            continue;
 *          }
 *           
 *          //tokuseiB
 *        }
 *
 *
 *      QDCfbNXg
 *        \[gԂ͍l܂B
 *        for( int i = 1;  i < TOKUSEI_MAX; ++i )  //1TOKUSEI_NULLOĂ
 *        {
 *          u32 initial = hoge.GetInitialIndex(i);
 *          
 *          if( initial == TOKUSEI_INITIAL_INDEX_JPN_AA )
 *          {
 *            if( hoge.IsSecretTokusei( tokusei ) ) //łÔ
 *            {
 *              //BȂ̂ŏO
 *              continue;
 *            }
 *            //tokusei
 *          }
 *        }
 *
 *
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#pragma once
#if !defined( __TOKUSEISTRINGSORT_H__)
#define __TOKUSEISTRINGSORT_H__
#include <gflib.h>
#include <system/sort_string/StringSortBinary.h>

//e̓CfbNX
#include "./tokusei_initial_index_jpn.h"
#include "./tokusei_initial_index_usa.h"
#include "./tokusei_initial_index_fra.h"
#include "./tokusei_initial_index_ita.h"
#include "./tokusei_initial_index_deu.h"
#include "./tokusei_initial_index_esp.h"
#include "./tokusei_initial_index_kor.h"

//ẽ\[ge[uoCfbNX
#include "./tokusei_sort_table_jpn.h"
#include "./tokusei_sort_table_usa.h"
#include "./tokusei_sort_table_fra.h"
#include "./tokusei_sort_table_ita.h"
#include "./tokusei_sort_table_deu.h"
#include "./tokusei_sort_table_esp.h"
#include "./tokusei_sort_table_kor.h"

GFL_NAMESPACE_BEGIN(xy_system)

class TokuseiStringSort : public StringSortBinary
{
  GFL_FORBID_COPY_AND_ASSIGN(TokuseiStringSort);
public:
  //-----------------------------------------------------------------------
  // Aj
  //-----------------------------------------------------------------------
  /**
   * @brief RXgN^
   */
  TokuseiStringSort();
  /**
   * @brief fXgN^
   */
  virtual ~TokuseiStringSort();
  
  //-----------------------------------------------------------------------
  // ǂݍ
  //-----------------------------------------------------------------------
  /**
   * @brief ǂݍ
   *
   * @param heap  q[v
   */
  void Load( gfl::heap::HeapBase * heap );
  
  //-----------------------------------------------------------------------
  // 擾
  //  擾n֐StringSortBinaryNXpĂ̂
  //  ȉ̂̂g܂B
  //  u32 GetSortOrder( u32 index ) const;
  //  u32 GetSortOrderMax( void ) const;
  //  u32 GetInitialIndex( u32 index ) const;
  //  u32 GetInitialIndexMax( void ) const;
  //-----------------------------------------------------------------------
  /**
   * @brief Bǂ`FbN
   *
   * @param tokusei  
   *
   * @return  trueȂΉB  falseȂΉBȂ
   */
  bool IsSecretTokusei( TokuseiNo tokusei ) const;
  
private:
  static const int SECRET_TOKUSEI_TABLE_MAX  = 1;
  static const TokuseiNo SECRET_TOKUSEI_TABLE[ SECRET_TOKUSEI_TABLE_MAX ];
};


GFL_NAMESPACE_END(xy_system)

#endif		// __TOKUSEISTRINGSORT_H__
