//=============================================================================
/**
 * @file   gflnet_NexMessageClientListener.h
 * @brief  MessageClient֘AʒmCxgnh
 * @author h.suzuki
 */
//=============================================================================

#ifndef __GFLNET_NEX_MESSAGE_CLIENT_LISTENER_H__
#define __GFLNET_NEX_MESSAGE_CLIENT_LISTENER_H__

#include <nn.h>
#include <nex.h>
#include <gflib.h>


GFL_NAMESPACE_BEGIN(gflnet)
GFL_NAMESPACE_BEGIN(nex)

//------------------------------------------------------------------
/*!
 * @brief bZ[WʒmCxgnh
 *
 * @note ZbVԕωCxg֘A̒ʒm󂯎ꍇ́A
 *       {NXpz֐ĂB
 */
//------------------------------------------------------------------
class NexMessageClientListener
{
//  GFL_FORBID_COPY_AND_ASSIGN(NexMessageClientListener); //Rs[RXgN^{֎~
public:

  //------------------------------------------------------------------
  /**
  * @brief bZ[WM̐ʒm
  *
  * @param[in] message MbZ[Wf[^
  */
  //------------------------------------------------------------------
  virtual void OnNexMessageSendingSuccess( nn::nex::TextMessage* message ){};

  //------------------------------------------------------------------
  /**
  * @brief bZ[WM̎sʒm
  *
  * @param[in] message MbZ[Wf[^
  * @param[in] result  s
  */
  //------------------------------------------------------------------
  virtual void OnNexMessageSendingFailed( nn::nex::TextMessage* message, nn::nex::qResult& result ){};

  //------------------------------------------------------------------
  /**
  * @brief bZ[WM̒ʒm
  *
  * @param[in] message MbZ[Wf[^
  */
  //------------------------------------------------------------------
  virtual void OnNexMessageReceived( nn::nex::TextMessage* message ){};
};


GFL_NAMESPACE_END(nex)
GFL_NAMESPACE_END(gflnet)



#endif // __GFLNET_NEX_MESSAGE_CLIENT_LISTENER_H__
