//=============================================================================
/**
 * @file   gflnet_NexMessageClient.h
 *
 * @brief  nn::nex::MessageClient̃bp[NXB
 *
 * @author h.suzuki
 */
//=============================================================================

#ifndef __GFLNET_NEX_MESSAGE_CLIENT_H__
#define __GFLNET_NEX_MESSAGE_CLIENT_H__


#include <nex.h>
#include <nex_P2p.h>

#include <nn/friends.h>
#include <RendezVous/Services/Messaging.h>

#include <gflib.h>
#include <gflnet_NetworkDefine.h>
#include <nex/gflnet_NexTemplate.h>
#include <nex/gflnet_NexMessageClientListener.h>

GFL_NAMESPACE_BEGIN(gflnet)
GFL_NAMESPACE_BEGIN(nex)

//------------------------------------------------------------------
/**
*  @brief MessageClientANZXpNX
*
*  @attention OɃQ[T[oփOCĂ
*
*  @attention NexManager::Dispatch() sɃR[邱Ƃ͂łȂB
*
**/
//------------------------------------------------------------------
class NexMessageClient : public nn::nex::MessagingNotificationHandler
{
  GFL_FORBID_COPY_AND_ASSIGN(NexMessageClient); //Rs[RXgN^{֎~

public:
  NexMessageClient( void );
  virtual ~NexMessageClient();

public:
  //------------------------------------------------------------------
  /**
  * @brief  MessageClient̏
  *
  * @param[in]  credentials     Q[T[o[OC
  *
  * @return ɐȂtrueԋp
  */
  //------------------------------------------------------------------
  bool Initialize( nn::nex::Credentials* credentials );

  //------------------------------------------------------------------
  /**
  * @brief  MessageClient̏I
  */
  //------------------------------------------------------------------
  void Finalize( void );

public:
  //------------------------------------------------------------------
  /**
  * @brief bZ[WpXi̓o^
  *
  * @param[in] listener o^Ώۂ̃bZ[WpXiB
  *
  * @return o^ɐȂtrueԋp
  */
  //------------------------------------------------------------------
  bool RegistMessageClientListener( NexMessageClientListener* listener );

  //------------------------------------------------------------------
  /**
  * @brief bZ[WpXỉ
  *
  * @param[in] listener 폜Ώۂ̃bZ[WpXiB
  */
  //------------------------------------------------------------------
  void UnregistMessageClientListener( NexMessageClientListener* listener );

public:
  //------------------------------------------------------------------
  /**
  * @brief w胆[U[ɃbZ[W𑗐M
  *
  * @param[in] pid         MΏۃ[U[̃vVoID
  * @param[in] subject     ^CgB͓[NɃRs[B
  * @param[in] messageBody M郁bZ[WB͓[NɃRs[B
  *
  * @note {֐sꍇNexMessageClientListenerCxg̓R[ȂB
  * @note SendChat()Ƃ͔rƂȂׁAL֐ƓɎs͕sB
  *
  * @return sʁBtrueԋpB
  */
  //------------------------------------------------------------------
  bool SendInstant( const nn::nex::PrincipalID pid, const gfl::str::STRCODE * subject, const gfl::str::STRCODE* messageBody );

  //------------------------------------------------------------------
  /**
  * @brief }b`CNQ[U[i܂ށjɃbZ[W𑗐M
  *
  * @param[in] gid    MΏۃ}b`CÑMUOID
  * @param[in] subject     ^CgB͓[NɃRs[B
  * @param[in] messageBody M郁bZ[WB͓[NɃRs[B
  *
  * @note {֐sꍇNexMessageClientListenerCxg̓R[ȂB
  * @note SendInstant()Ƃ͔rƂȂׁAL֐ƓɎs͕sB
  *
  * @return sʁBtrueԋpB
  */
  //------------------------------------------------------------------
  bool SendChat( const nn::nex::GatheringID gid, const gfl::str::STRCODE* subject, const gfl::str::STRCODE* messageBody );

public:
  //------------------------------------------------------------------
  /**
   * @brief  bZ[WM񓯊̊ʒmmp֐
   *
   * @attention R[obN֐ɂ̂݊J邽߁A[U[gp֎~I
   *
   * @param[in,out]  pContext ʒmΏۂƂȂReLXg
   */
  //------------------------------------------------------------------
  void OnSendingCompletion(nn::nex::CallContext *pContext);

  //------------------------------------------------------------------
  /**
   * @brief  MessagingNotificationHandlerpMessageMCxg
   *
   * @attention R[obN֐ɂ̂݊J邽߁A[U[gp֎~I
   *
   * @param[in]  hMsg MbZ[W
   */
  //------------------------------------------------------------------
  virtual void DeliverInstantMessage( const nn::nex::DataHolder &hMsg );


private:
  //------------------------------------------------------------------
  /**
  * @brief MessageHolder̃ZbgAbv
  *
  * @param[in] subject     ^CgB͓[NɃRs[B
  * @param[in] messageBody M郁bZ[WB͓[NɃRs[B
  */
  //------------------------------------------------------------------
  void SetupMessageHolder( const gfl::str::STRCODE* subject, const gfl::str::STRCODE* messageBody );

private:
  static const u32      LISTENER_NUM = 4;

  bool                                m_isInit;                 //!< tO
  bool                                m_isSending;              //!< MtO
  //
  nn::nex::MessagingClient*           m_messageClient;          //!< bZ[WNCAg
  //
  NexMessageClientListener*           m_listener[LISTENER_NUM]; //!< bZ[WpXi
  nn::nex::UserMessageDataHolder*     m_messageHolder;          //!< bZ[Wz_
  nn::nex::String*                    m_messageSubject;         //!< M^Cg
  nn::nex::String*                    m_messageBody;            //!< MbZ[W
};

GFL_NAMESPACE_END(nex)
GFL_NAMESPACE_END(gflnet)

#endif  // __GFLNET_NEX_MESSAGE_CLIENT_H__
