//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *  @file   hangul_composer.cpp
 *  @brief  nO͎̎ꌋ
 *  @author ichibayashi_hironori@Nintendo
 *  @data   2010.09.09
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system/hangul.h"
#include "system/hangul_composer.h"


//----------------------------------------------------------------------------
/**
 *  @brief  nO  
 *          tHg͏ɃZbĝłAs\ȏꍇNULLw肵A
 *          gpO HangulComposer::SetFont Őݒ肵ĂB
 *
 *  @param  font    Ot̎擾ɎgptHg
 */
//-----------------------------------------------------------------------------
HangulComposer::HangulComposer(const nw::font::Font* font)
{
  this->font = font;
}


//----------------------------------------------------------------------------
/**
 *  @brief  nO  tHgݒBCreateɃtHgNULLw肵ꍇÂ߂1񂾂ĂԂƂłB
 *
 *  @param  font    Ot̎擾ɎgptHg
 */
//-----------------------------------------------------------------------------
void HangulComposer::SetFont(const nw::font::Font* font)
{
  GFL_ASSERT(this->font == NULL);
  GFL_ASSERT(font != NULL);
  this->font = font;
}

//----------------------------------------------------------------------------
/**
 *  @brief  nO  1
 *
 *  @param  ksjamo        
 *  @param  composed_code [out]͂̌ʁAm肵nOBm肵Ȃ0B
 *  @param  is_last_code  obt@̍ŌォAȂ킿łȂɂĊm肵ė~Ȃǂ
 *
 *  @return is_last_code̎wɂē͂łȂfalseBȊȌꍇ͓͂łtrueB
 */
//-----------------------------------------------------------------------------
bool HangulComposer::InputCode(gfl::str::STRCODE ksjamo, gfl::str::STRCODE *composed_code, bool is_last_code)
{
  GFL_ASSERT(this->font);
  GFL_ASSERT(Hangul::IsKSJamo(ksjamo));

  // ̃nOȂƂ́Aksjamo͂ꂽԂɂ
  if (this->hangul_log_idx == 0)
  {
    AddCompositionLog(ksjamo, ksjamo);
    *composed_code = 0;
    return true;
  }
  // ̃nOƂ́As
  else
  {
    gfl::str::STRCODE new_hangul1, new_hangul2, deprived_ksjamo;
    
    CombineHangul(
      this->hangul_log[this->hangul_log_idx-1], ksjamo,
      &new_hangul1, &new_hangul2, &deprived_ksjamo);
    
    // P
    if (new_hangul2 == 0)
    {
      AddCompositionLog(new_hangul1, ksjamo);
      *composed_code = 0;
      return true;
    }
    else
    {
      // ϊ悤ȓ͕͂sB2󂫂Ȃ΂ȂȂ
      if (is_last_code)
      {
        *composed_code = 0;
        return false;
      }
      // ÕnO玚苎ČꍇAbackspaceł͂̎ɖ߂
      if (deprived_ksjamo != 0)
      {
        HangulComposer::ClearComposition();
        AddCompositionLog(deprived_ksjamo, deprived_ksjamo);
        AddCompositionLog(new_hangul2, ksjamo);
      }
      else 
      {
        HangulComposer::ClearComposition();
        AddCompositionLog(new_hangul2, ksjamo);
      }
      
      // m
      *composed_code = new_hangul1;
      return true;
    }
  }
}

//----------------------------------------------------------------------------
/**
 *  @brief  nO  ̃nO玚폜
 *
 *  @return ꂪ폜łȂtrueBꂪ폜łȂ΁ĩnO݂Ȃ΁jfalseB
 */
//-----------------------------------------------------------------------------
bool HangulComposer::BackSpace()
{
  if(this->hangul_log_idx > 0)
  { 
    // nOÔڂ
    this->hangul_log_idx --;

    return true;
  }

  return false;
}

//----------------------------------------------------------------------------
/**
 *  @brief  nO  ̃nOm肵ĕԂ
 *
 *  @return nOB݂Ȃ0B
 */
//-----------------------------------------------------------------------------
gfl::str::STRCODE HangulComposer::FixComposition()
{
  gfl::str::STRCODE code = HangulComposer::GetCompositionChar();
  HangulComposer::ClearComposition();
  return code;
}

//----------------------------------------------------------------------------
/**
 *  @brief  nO  ̃nONA
 */
//-----------------------------------------------------------------------------
void HangulComposer::ClearComposition()
{
  this->hangul_log_idx = 0;
}

//----------------------------------------------------------------------------
/**
 *  @brief  nO  ̃nO݂邩
 *
 *  @return ̃nO݂邩
 */
//-----------------------------------------------------------------------------
bool HangulComposer::HasCompositionChar() const
{
  return this->hangul_log_idx > 0;
}

//----------------------------------------------------------------------------
/**
 *  @brief  nO  ̃nO擾
 *
 *  @return ̃nOB݂Ȃ0B
 */
//-----------------------------------------------------------------------------
gfl::str::STRCODE HangulComposer::GetCompositionChar() const
{
  if (HangulComposer::HasCompositionChar())
  {
    return this->hangul_log[this->hangul_log_idx-1];
  }
  else {
    return 0;
  }
}

//----------------------------------------------------------------------------
/**
 *  @brief  nO  ̃nOɊ܂܂鎚̐
 *
 *  @return ̃nOɊ܂܂鎚̐B݂Ȃ0B
 */
//-----------------------------------------------------------------------------
int HangulComposer::GetCompositionJamoCount() const
{
  return this->hangul_log_idx;
}

//----------------------------------------------------------------------------
/**
 *  @brief  nO  nOϊOǉ
 *
 *  @param  hangul              ̃nO
 *  @param  ksjamo              ͂ KS X1001 
 */
//-----------------------------------------------------------------------------
void HangulComposer::AddCompositionLog(gfl::str::STRCODE hangul, gfl::str::STRCODE ksjamo)
{
  int index = this->hangul_log_idx;
  GFL_ASSERT(this->hangul_log_idx < HANGUL_LOG_LEN);
  this->hangul_log[index] = hangul;
  this->jamo_log[index] = ksjamo;
  this->hangul_log_idx = index + 1;
}

//----------------------------------------------------------------------------
/**
 *  @brief  nO  nO
 *          o͂́A3p^[F
 *          Ehangul玚菜Č (*deprived_ksjamo != 0)
 *          EP (*out_hangul2 == 0)
 *          EȂ (*out_hangul1 == hangul, *out_hangul2 == ksjamo)
 *
 *  @param  hangul               ÕnO
 *  @param  *out_hangul1         o
 *  @param  *out_hangul2         o
 *  @param  *out_deprived_ksjamo o
 */
//-----------------------------------------------------------------------------
void HangulComposer::CombineHangul(
  const gfl::str::STRCODE hangul, const gfl::str::STRCODE ksjamo,
  gfl::str::STRCODE *out_hangul1, gfl::str::STRCODE *out_hangul2, gfl::str::STRCODE *out_deprived_ksjamo)
{
  int leadcons, vowel, patchim; // hangul̕
  gfl::str::STRCODE deprived_ksjamo = 0;
  gfl::str::STRCODE combined_code = 0;  // ̃nO

  GFL_ASSERT(out_hangul1 != NULL);
  GFL_ASSERT(out_hangul2 != NULL);
  GFL_ASSERT(out_deprived_ksjamo != NULL);

  GFL_ASSERT(Hangul::IsHangul(hangul)); // ł
  GFL_ASSERT(Hangul::IsKSJamo(ksjamo)); //  i.e. KS X1001qꉹ

  // ÕnOPƂłꍇ
  if (!Hangul::Decompose(hangul, &leadcons, &vowel, &patchim))
  {
    // hangulqksjamoꉹȂ猋
    if (Hangul::IsKSCons(hangul) && Hangul::IsKSVowel(ksjamo))
    {
      combined_code = Hangul::ComposeKSConsAndKSVowel(hangul, ksjamo);
    }
    // ȂΌs
    else
    {
      combined_code = 0;
    }
  }
  // Ōオpb`̏ꍇ
  else if (patchim != 0)
  {
    // ksjamoꉹȂ炻ƌ
    if (Hangul::IsKSVowel(ksjamo))
    {
      GFL_ASSERT(this->hangul_log_idx >= 3); // pb`݂3ȏ
      deprived_ksjamo = this->jamo_log[this->hangul_log_idx-1];
      combined_code = Hangul::ComposeKSConsAndKSVowel(deprived_ksjamo, ksjamo);
    }
    // ksjamoqȂpb`ւ̒ǉ݂
    else
    {
      GFL_ASSERT(Hangul::IsKSCons(ksjamo));
      patchim = Hangul::ClusterPatchim(patchim, Hangul::KSConsToLeadConsIndex(ksjamo));

      // A
      if (patchim != -1)
      {
        combined_code = Hangul::Compose(leadcons, vowel, patchim);
      }
      // sAs
      else
      {
        combined_code = 0;
      }
    }

  }
  // Ōオꉹ̏ꍇ
  else
  {
    // ksjamoqȂpb`Ƃ
    if (Hangul::IsKSCons(ksjamo))
    {
      int add_patchim = Hangul::KSConsToPatchimIndex(ksjamo);
      if (add_patchim != -1)
      {
        combined_code = Hangul::AddPatchim(hangul, add_patchim);
      }
      else
      {
        combined_code = 0;
      }
    }
    // Ȃ΁Aꉹɂ邱Ƃ݂
    else
    {
      GFL_ASSERT(Hangul::IsKSVowel(ksjamo));
      vowel = Hangul::CompoundVowel(vowel, Hangul::KSVowelToVowelIndex(ksjamo));

      // A
      if (vowel != -1)
      {
        combined_code = Hangul::Compose(leadcons, vowel, patchim);
      }
      // sAs
      else
      {
        combined_code = 0;
      }
    }
  }

  // nÕOtĂȂ猋sɂ
  if (combined_code != 0)
  {
    if (!this->font->HasGlyph(combined_code)) 
    {
      deprived_ksjamo = 0;
      combined_code = 0;
    }
  }

  if (deprived_ksjamo != 0)
  {
    *out_hangul1 = this->hangul_log[this->hangul_log_idx-2];
    *out_hangul2 = combined_code;
    *out_deprived_ksjamo = deprived_ksjamo;
  }
  else if (combined_code != 0)
  {
    *out_hangul1 = combined_code;
    *out_hangul2 = 0;
    *out_deprived_ksjamo = 0;
  }
  else
  {
    *out_hangul1 = hangul;
    *out_hangul2 = ksjamo;
    *out_deprived_ksjamo = 0;
  }
}
