//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *  @file   hangul.cpp
 *  @brief  nO
 *  @author ichibayashi_hironori@Nintendo
 *  @data   2010.04.22
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system/hangul.h"

// UnicodegpĂȂ̂OƂȂĂ

// ̕ω\
const gfl::str::STRCODE Hangul::ParticleTable[2][PARTICLE_ID_COUNT] =
{
  // Ȃ,        ,        ,        ,        ,        ,        ,     
  { L'\0', L'\xb294', L'\xb97c', L'\xac00', L'\xc640',     L'\0',     L'\0', L'\xc57c' },  // pb`Ȃ
  { L'\0', L'\xc740', L'\xc744', L'\xc774', L'\xacfc', L'\xc73c', L'\xc774', L'\xc544' },  // pb`
};

//----------------------------------------------------------------------------
/**
 *  @brief  nO߁ii.e. łȂnOjł邩
 *
 *  @param  gfl::str::STRCODE code  
 *
 *  @return nO߂łtrue
 */
//-----------------------------------------------------------------------------
bool Hangul::IsSyllable(gfl::str::STRCODE code)
{
  return Hangul::SYLLABLE_BASE <= code && code < Hangul::SYLLABLE_BASE+Hangul::SYLLABLE_COUNT;
}

//----------------------------------------------------------------------------
/**
 *  @brief  nO߂̕Apb`擾
 *
 *  @param  gfl::str::STRCODE code  nO߂̕
 *
 *  @return pb`̔ԍi0:Ȃ`28j
 */
//-----------------------------------------------------------------------------
int Hangul::GetPatchim(gfl::str::STRCODE code)
{
  GFL_ASSERT(Hangul::IsSyllable(code));
  return (code - Hangul::SYLLABLE_BASE) % Hangul::PATCHIM_COUNT;
}

//----------------------------------------------------------------------------
/**
 *  @brief  IDƁA̒O̕A̕ω`𓾂
 *
 *  @param  gfl::str::STRCODE last_char ̒O̕
 *  @param  int particle_id   ID
 *
 *  @return ̕i0łΕȂj
 */
//-----------------------------------------------------------------------------
gfl::str::STRCODE Hangul::GetParticle(gfl::str::STRCODE last_char, uint particle_id)
{
  GFL_ASSERT(particle_id < PARTICLE_ID_COUNT);
  if (PARTICLE_ID_COUNT <= particle_id)
  {
    return 0;
  }

  int has_patchim;
  if (Hangul::IsSyllable(last_char))
  {
    int patchim_id = Hangul::GetPatchim(last_char);
    if (particle_id == PARTICLE_ID_NI)
    {
      has_patchim = (patchim_id != 0 && patchim_id != 8) ? 1 : 0;
    }
    else
    {
      has_patchim = (patchim_id != 0) ? 1 : 0;
    }
  }
  else if (L'0' <= last_char && last_char <= L'9')
  {
    int number = last_char - L'0';
    if (particle_id == PARTICLE_ID_NI)
    {
      has_patchim = (PATCHIM_BITS_NUMBER_NI >> number) & 1;
    }
    else
    {
      has_patchim = (PATCHIM_BITS_NUMBER    >> number) & 1;
    }
  }
  else {
    has_patchim = 0;
  }

  return ParticleTable[has_patchim][particle_id];
}



//
// 艺̓nO͂łgpȂiIW[ɒǂo\j
//


//----------------------------------------------------------------------------
/**
 *  @brief  nOi܂ށjł邩
 *
 *  @param  gfl::str::STRCODE code  
 *
 *  @return nOłtrue
 */
//-----------------------------------------------------------------------------
bool Hangul::IsHangul(gfl::str::STRCODE code)
{
  return Hangul::IsKSJamo(code) || Hangul::IsSyllable(code);
}

//----------------------------------------------------------------------------
/**
 *  @brief  KS X1001ł邩
 *
 *  @param  gfl::str::STRCODE code  
 *
 *  @return łtrue
 */
//-----------------------------------------------------------------------------
bool Hangul::IsKSJamo(gfl::str::STRCODE code)
{
  return Hangul::KS_JAMO_BASE <= code && code < Hangul::KS_JAMO_BASE+Hangul::KS_JAMO_COUNT;
}

//----------------------------------------------------------------------------
/**
 *  @brief  KS X1001̎qł邩
 *
 *  @param  gfl::str::STRCODE code  
 *
 *  @return qłtrue
 */
//-----------------------------------------------------------------------------
bool Hangul::IsKSCons(gfl::str::STRCODE code)
{
  return Hangul::KS_CONS_BASE <= code && code < Hangul::KS_CONS_BASE+Hangul::KS_CONS_COUNT;
}

//----------------------------------------------------------------------------
/**
 *  @brief  KS X1001̕ꉹł邩
 *
 *  @param  gfl::str::STRCODE code  
 *
 *  @return ꉹłtrue
 */
//-----------------------------------------------------------------------------
bool Hangul::IsKSVowel(gfl::str::STRCODE code)
{
  return Hangul::KS_VOWEL_BASE <= code && code < Hangul::KS_VOWEL_BASE+Hangul::KS_VOWEL_COUNT;
}

//----------------------------------------------------------------------------
/**
 *  @brief  KS X1001qAUnicodeq̃CfbNXɕϊ
 *
 *  @param  gfl::str::STRCODE kscons  KS X1001q
 *
 *  @return Unicodeq̃CfbNXBΉUnicodeq݂Ȃ-1
 */
//-----------------------------------------------------------------------------
int Hangul::KSConsToLeadConsIndex(gfl::str::STRCODE kscons)
{
  // ÑnO͒̕`ĂȂ
  static s8 table[Hangul::KS_CONS_COUNT] = {
     0,  1, -1,  2, -1, -1,  3,  4,  // U+3131
     5, -1, -1, -1, -1, -1, -1, -1,  // U+3139
     6,  7,  8, -1,  9, 10, 11, 12,  // U+3141
    13, 14, 15, 16, 17, 18           // U+3149
  };
  if (!Hangul::IsKSCons(kscons))
  {
    return -1;
  }
  return table[kscons - Hangul::KS_CONS_BASE];
}

//----------------------------------------------------------------------------
/**
 *  @brief  KS X1001ꉹAUnicodeꉹ̃CfbNXɕϊ
 *
 *  @param  gfl::str::STRCODE ksvowel  KS X1001ꉹ
 *
 *  @return Unicodeꉹ̃CfbNXBΉUnicodeꉹ݂Ȃ-1
 */
//-----------------------------------------------------------------------------
int Hangul::KSVowelToVowelIndex(gfl::str::STRCODE ksvowel)
{
  if (!Hangul::IsKSVowel(ksvowel))
  {
    return -1;
  }
  return ksvowel - Hangul::KS_VOWEL_BASE;
}

//----------------------------------------------------------------------------
/**
 *  @brief  KS X1001qAUnicodepb`̃CfbNXɕϊ
 *
 *  @param  gfl::str::STRCODE kscons  KS X1001q
 *
 *  @return Unicodepb`̃CfbNXBΉUnicodepb`݂Ȃ-1
 */
//-----------------------------------------------------------------------------
int Hangul::KSConsToPatchimIndex(gfl::str::STRCODE kscons)
{
  // ÑnO͒̕`ĂȂ
  static s8 table[Hangul::KS_CONS_COUNT] = {
     1,  2, -1,  4, -1, -1,  7, -1,  // U+3131
     8, -1, -1, -1, -1, -1, -1, -1,  // U+3139
    16, 17, -1, -1, 19, 20, 21, 22,  // U+3141
    -1, 23, 24, 25, 26, 27           // U+3149
  };
  if (!Hangul::IsKSCons(kscons))
  {
    return -1;
  }
  return table[kscons - Hangul::KS_CONS_BASE];
}

//----------------------------------------------------------------------------
/**
 *  @brief  ꉹ2Aꉹɕϊ
 *          L[{[h璼ړ͂łȂꉹ̐Ɏgp
 *
 *  @param  int vowel1  UnicodeꉹCfbNX
 *  @param  int vowel2  UnicodeꉹCfbNX
 *
 *  @return Unicodeꉹ̃CfbNXBłȂ-1
 */
//-----------------------------------------------------------------------------
int Hangul::CompoundVowel(int vowel1, int vowel2)
{
  static struct
  {
    s8 vowel1;
    s8 vowel2;
    s8 compounded_vowel;
  } table[] = 
  {
    {  8,  0,  9}, // o + a  = wa
    {  8,  1, 10}, // o + ae = wae
    {  8, 20, 11}, // o + i  = oe
    { 13,  4, 14}, // u + eo = wo
    { 13,  5, 15}, // u + e  = we
    { 13, 20, 16}, // u + i  = wi
    { 18, 20, 19}, // eu+ i  = ui
  };
  int i;

  for (i = 0; i < GFL_NELEMS(table); i ++)
  {
    if (table[i].vowel1 == vowel1 && table[i].vowel2 == vowel2)
    {
      return table[i].compounded_vowel;
    }
  }

  return -1;
}

//----------------------------------------------------------------------------
/**
 *  @brief  pb`ɎqtāAq2Ȃpb`𐶐
 *          L[{[h璼ړ͂łȂpb`̐Ɏgp
 *
 *  @param  int patchim Unicodepb`CfbNX
 *  @param  int cons    UnicodeqCfbNX
 *
 *  @return Unicodepb`̃CfbNXBłȂ-1
 */
//-----------------------------------------------------------------------------
int Hangul::ClusterPatchim(int patchim, int cons)
{
  static struct
  {
    s8 patchim;
    s8 cons;
    s8 clustered_patchim;
  } table[] = 
  {
    {  1,  9,  3}, // k + s
    {  4, 12,  5}, // n + j
    {  4, 18,  6}, // n + h
    {  8,  0,  9}, // r + k
    {  8,  6, 10}, // r + m
    {  8,  7, 11}, // r + b
    {  8,  9, 12}, // r + s
    {  8, 16, 13}, // r + t
    {  8, 17, 14}, // r + p
    {  8, 18, 15}, // r + h
    { 17,  9, 18}, // p + s
  };
  int i;

  for (i = 0; i < GFL_NELEMS(table); i ++)
  {
    if (table[i].patchim == patchim && table[i].cons == cons)
    {
      return table[i].clustered_patchim;
    }
  }

  return -1;
}

//----------------------------------------------------------------------------
/**
 *  @brief  nOA擪̎qAꉹApb`̃CfbNXɕ
 *          L[{[h璼ړ͂łȂpb`̐Ɏgp
 *
 *  @param  gfl::str::STRCODE hangul        nO
 *  @param  int *p_leadcons_index [out] qCfbNX
 *  @param  int *p_vowel_index    [out] ꉹCfbNX
 *  @param  int *p_patchim_index  [out] pb`CfbNX
 *
 *  @return łtrueAłȂȉꍇjfalse
 */
//-----------------------------------------------------------------------------
bool Hangul::Decompose(gfl::str::STRCODE hangul, int *p_leadcons_index, int *p_vowel_index, int *p_patchim_index)
{
  if (!Hangul::IsSyllable(hangul))
  {
    return false;
  }
  else
  {
    int hangul_index = hangul - Hangul::SYLLABLE_BASE;

    if (p_leadcons_index != NULL)
    {
      *p_leadcons_index = hangul_index / (Hangul::PATCHIM_COUNT*Hangul::VOWEL_COUNT);
    }
    if (p_vowel_index != NULL)
    {
      *p_vowel_index = (hangul_index / Hangul::PATCHIM_COUNT) % Hangul::VOWEL_COUNT;
    }
    if (p_patchim_index != NULL) 
    {
      *p_patchim_index = hangul_index % Hangul::PATCHIM_COUNT;
    }
    return true;
  }
}

//----------------------------------------------------------------------------
/**
 *  @brief  擪̎qAꉹApb`̃CfbNXAnO
 *
 *  @param  int leadcons_index qCfbNX
 *  @param  int vowel_index    ꉹCfbNX
 *  @param  int patchim_index  pb`CfbNX
 *
 *  @return nO
 */
//-----------------------------------------------------------------------------
gfl::str::STRCODE Hangul::Compose(int leadcons_index, int vowel_index, int patchim_index)
{
  return Hangul::SYLLABLE_BASE +
    (leadcons_index * Hangul::VOWEL_COUNT + vowel_index) * Hangul::PATCHIM_COUNT + patchim_index;
}

//----------------------------------------------------------------------------
/**
 *  @brief  KS X1001qƕꉹAnO
 *
 *  @param  gfl::str::STRCODE kscons   KS X1001q
 *  @param  gfl::str::STRCODE ksvowel  KS X1001ꉹ
 *
 *  @return nOBłȂ0
 */
//-----------------------------------------------------------------------------
gfl::str::STRCODE Hangul::ComposeKSConsAndKSVowel(gfl::str::STRCODE kscons, gfl::str::STRCODE ksvowel)
{
  int cons_index, vowel_index;

  if (!Hangul::IsKSCons(kscons) || !Hangul::IsKSVowel(ksvowel))
  {
    return 0;
  }

  cons_index = Hangul::KSConsToLeadConsIndex(kscons);
  if (cons_index == -1)
  {
    return 0;
  }
  
  vowel_index = Hangul::KSVowelToVowelIndex(ksvowel);
  if (vowel_index == -1)
  {
    return 0;
  }

  return Hangul::SYLLABLE_BASE + (cons_index * Hangul::VOWEL_COUNT + vowel_index) * Hangul::PATCHIM_COUNT;
}

//----------------------------------------------------------------------------
/**
 *  @brief  pb`̂ȂnOɃpb`ǉ
 *
 *  @param  gfl::str::STRCODE hangul     nO
 *  @param  int patchim_index  pb`CfbNX
 *
 *  @return pb`ǉnOBǉłȂ0
 */
//-----------------------------------------------------------------------------
gfl::str::STRCODE Hangul::AddPatchim(gfl::str::STRCODE hangul, int patchim_index)
{
  if (!Hangul::IsSyllable(hangul) || (Hangul::GetPatchim(hangul) != 0))
  {
    return 0;
  }

  return hangul + patchim_index;
}
