//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *  @file   hangul_composer.cpp
 *  @brief  nO͎̎ꌋ
 *  @author ichibayashi_hironori@Nintendo
 *  @data   2010.09.09
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#ifndef __HANGUL_COMPOSER_H__
#define __HANGUL_COMPOSER_H__
#pragma once

class HangulComposer
{
  GFL_FORBID_COPY_AND_ASSIGN(HangulComposer);
public:
  HangulComposer(const nw::font::Font* font);

  void SetFont(const nw::font::Font* font);

  // 
  bool InputCode(gfl::str::STRCODE ksjamo, gfl::str::STRCODE *composed_code, bool is_last_code);
  bool BackSpace();

  // nOim蕶j̑
  gfl::str::STRCODE FixComposition();
  void ClearComposition();

  // nOim蕶j̎擾
  bool              HasCompositionChar() const;
  gfl::str::STRCODE GetCompositionChar() const;
  int               GetCompositionJamoCount() const;

private:
  void AddCompositionLog(gfl::str::STRCODE hangul, gfl::str::STRCODE ksjamo);
  void CombineHangul(
    gfl::str::STRCODE hangul, gfl::str::STRCODE ksjamo,
    gfl::str::STRCODE *out_hangul1, gfl::str::STRCODE *out_hangul2, gfl::str::STRCODE *deprived_ksjamo);

  static const int HANGUL_LOG_LEN = 6;
  // Ot݂邩肷邽߂̃tHg
  const nw::font::Font* font;
  // nOOB͂ƂɁÃnOL^
  gfl::str::STRCODE hangul_log[HANGUL_LOG_LEN];  
  // ꃍOB͂ƂɋL^
  gfl::str::STRCODE jamo_log[HANGUL_LOG_LEN];
  //nOO
  u16               hangul_log_idx;   
};

#endif // #ifndef __HANGUL_COMPOSER_H__
