//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *  @file   hangul.h
 *  @brief  nO
 *  @author ichibayashi_hironori@Nintendo
 *  @data   2010.04.22
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#ifndef __HANGUL_H__
#define __HANGUL_H__
#pragma once

class Hangul
{
private:
  Hangul(); // CX^XłȂ

public:
  static bool IsSyllable(gfl::str::STRCODE code);
  static int GetPatchim(gfl::str::STRCODE code);
  static gfl::str::STRCODE GetParticle(gfl::str::STRCODE last_char, uint particle_id);

  static bool IsHangul(gfl::str::STRCODE code);
  static bool IsKSJamo(gfl::str::STRCODE code);
  static bool IsKSCons(gfl::str::STRCODE code);
  static bool IsKSVowel(gfl::str::STRCODE code);

  static int KSConsToLeadConsIndex(gfl::str::STRCODE kscons);
  static int KSVowelToVowelIndex(gfl::str::STRCODE ksvowel);
  static int KSConsToPatchimIndex(gfl::str::STRCODE kscons);

  static int CompoundVowel(int vowel1, int vowel2);
  static int ClusterPatchim(int patchim, int cons);

  static gfl::str::STRCODE Compose(int leadcons_index, int vowel_index, int patchim_index);
  static bool Decompose(gfl::str::STRCODE hangul, int *p_leadcons_index, int *p_vowel_index, int *p_patchim_index);

  static gfl::str::STRCODE ComposeKSConsAndKSVowel(gfl::str::STRCODE kscons, gfl::str::STRCODE ksvowel);
  static gfl::str::STRCODE AddPatchim(gfl::str::STRCODE cons_vowel, int kscons);

private:
  // KS X1001 ̒萔BA{̎qƕꉹ̂
  static const gfl::str::STRCODE KS_JAMO_BASE   = 0x3131; // ŏ̎̃R[h
  static const gfl::str::STRCODE KS_CONS_BASE   = 0x3131; // ŏ̎q̃R[h
  static const gfl::str::STRCODE KS_VOWEL_BASE  = 0x314f; // ŏ̕ꉹ̃R[h
  static const int KS_JAMO_COUNT  = 0x33;   // ̐
  static const int KS_CONS_COUNT  = 0x1e;   // q̐
  static const int KS_VOWEL_COUNT = 0x15;   // ꉹ̐

  static const gfl::str::STRCODE SYLLABLE_BASE  = 0xac00; // ŏ̃nO߂̃R[h
  static const int SYLLABLE_COUNT    = 11172; // nO߂̐
  static const int LEADCONS_COUNT    = 19;    // qiŏj̎ސ
  static const int VOWEL_COUNT       = 21;    // ꉹ̎ސ
  static const int PATCHIM_COUNT     = 28;    // pb`̎ސ

  static const int PARTICLE_ID_COUNT = 8;     // ̐
  static const int PARTICLE_ID_NI    = 5;     // uɁvID

  // pb`ǂiLSB=0j
  // iuɁvpb`uȁv̏ꍇ́Apb`ȂƓɂj
  static const int PATCHIM_BITS_NUMBER    = 0x1CB;    // uɁvȊO   0,1,3,6,7,8 c pb`  2,4,5,9 c pb`Ȃ
  static const int PATCHIM_BITS_NUMBER_NI = 0x049;    // uɁv̏ꍇ 1,7,8 c pb`uȁvȂ̂Ńpb`Ȃ

  static const gfl::str::STRCODE ParticleTable[2][PARTICLE_ID_COUNT];
};

#endif // #ifndef __HANGUL_H__
