//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		SequenceBigFourWater.cpp
 *	@brief  lVCxg̗ij
 *	@author	Masayuki Onoue
 *	@date		2012.09.04
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "SequenceBigFourWater.h"
#include "gimmic_sequence.gaix"

namespace field {


/* -------------------------------------------------------------------------*/
/**
 * @brief RXgN^
 *
 * @param mp_fieldmap tB[h}bv
 * @param p_heap      gpq[v
 */
/* -------------------------------------------------------------------------*/
SequenceBigFourWater::SequenceBigFourWater(field::Fieldmap*  p_fieldmap,gfl::heap::HeapBase* p_heap)
  :mp_seq_arc(NULL),
  mp_seq_sys(NULL),
  mp_seq_file(NULL),
  mp_fieldmap(NULL),
  mp_unique_sequence(NULL)
{
  // p[^ݒ
  mp_fieldmap = p_fieldmap;
  mp_unique_sequence = reinterpret_cast<FieldUniqueSequenceBigFourWater*>(mp_fieldmap->GetFieldUniqueSequence());
  mp_heap = p_heap;

  // V[PXݒ
  tool::seqeditor::InitParam initParam =
  {
    mp_heap,
    NULL
  };
  mp_seq_sys = GFL_NEW(mp_heap)tool::seqeditor::SeqSystem(initParam);

}

/* -------------------------------------------------------------------------*/
/**
 * @brief RXgN^
 */
/* -------------------------------------------------------------------------*/
SequenceBigFourWater::~SequenceBigFourWater()
{
  GFL_SAFE_DELETE( mp_seq_arc );
  GFL_SAFE_DELETE( mp_seq_sys );
}

/* -------------------------------------------------------------------------*/
/**
 * @brief 
 */
/* -------------------------------------------------------------------------*/
void SequenceBigFourWater::Initialize( void )
{
  // A[JCut@CǍݏ
  u32 init_flag = gfl::fs::ArcFile::OPEN;
#if PM_DEBUG
  if( field::FieldDebug::DebugPCLoadFlag ) {
    init_flag |= gfl::fs::ArcFile::HIO;
  }
#endif
  mp_seq_arc = GFL_NEW( mp_heap ) gfl::fs::ArcFile( mp_heap, ARCID_BIG_FOUR_SEQ, init_flag );
  LoadSeqFile();
}

/* -------------------------------------------------------------------------*/
/**
 * @brief V[PXt@C̓ǂݍ
 */
/* -------------------------------------------------------------------------*/
void SequenceBigFourWater::LoadSeqFile( void )
{
  mp_seq_file = mp_seq_sys->LoadFile( mp_seq_arc , GARC_gimmic_sequence_big_four_water_BSEQ , this );
}

/* -------------------------------------------------------------------------*/
/**
 * @brief Abvf[g
 */
/* -------------------------------------------------------------------------*/
void SequenceBigFourWater::Update(void)
{
  if( mp_seq_sys )
  {
    mp_seq_sys->UpdateFrame();
  }
}

/* -------------------------------------------------------------------------*/
/**
 * @brief ݂̃t[擾
 *
 * @return ݂̃t[
 */
/* -------------------------------------------------------------------------*/
int SequenceBigFourWater::GetSeqFrame(void)
{
  if( mp_seq_file )
  {
    return mp_seq_file->GetFrame();
  }
  return 0;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief R}hR[obN
 *
 * @param seqFile V[PXt@C
 * @param param   p[^
 */
/* -------------------------------------------------------------------------*/
void SequenceBigFourWater::CommnadCallback( tool::seqeditor::SeqFile *seqFile , const tool::seqeditor::CommandParam &param )
{
  int se_no;
  gfl::math::VEC3 col_vec;
  gfl::math::VEC4 start_col;
  gfl::math::VEC4 end_col;
  FieldStereoCamera*  p_camera;
  int sync;
  int get_col;
  int int_param;

  switch( param.commandNo )
  {
  case EVENT_SEQ_ID_PLAYT_SE:
    seqFile->LoadDataInt( &se_no );
    xy_snd::PlaySE( se_no );
    break;
  // tF[hAEg
  case EVENT_SEQ_ID_START_FEAD_OUT:
    // VN
    seqFile->LoadDataInt( &sync );
    // JnF
    seqFile->LoadDataVec3( &col_vec );
    start_col.x = col_vec.x;
    start_col.y = col_vec.y;
    start_col.z = col_vec.z;
    seqFile->LoadDataF32( &start_col.w );
    // IF
    seqFile->LoadDataVec3( &col_vec );
    end_col.x = col_vec.x;
    end_col.y = col_vec.y;
    end_col.z = col_vec.z;
    seqFile->LoadDataF32( &end_col.w );
    gfl::grp::Fade_RequestOut(gfl::grp::Fade::DISP_APPER, &start_col, &end_col, sync ,true );
    break;
  // tF[hC
  case EVENT_SEQ_ID_START_FEAD_IN:
    seqFile->LoadDataInt( &sync );
    gfl::grp::Fade_RequestIn(gfl::grp::Fade::DISP_APPER, sync );
    break;
  // Jh
  case EVENT_SEQ_ID_START_CAM_SHAKE:
    p_camera = mp_fieldmap->GetGraphics()->GetCamera();
    FieldStereoCamera::FldCamAnmShakeArg arg;
    // h
    seqFile->LoadDataInt( &int_param );
    arg.param.time    = static_cast<u8>(int_param);
    // hɂV
    seqFile->LoadDataInt( &int_param );
    arg.param.sync    = static_cast<u32>(int_param);
    // hꕝ
    seqFile->LoadDataInt( &int_param );
    arg.param.width   = static_cast<s16>(int_param);
    seqFile->LoadDataInt( &int_param );
    // hꍂ
    arg.param.height  = static_cast<s16>(int_param);
    p_camera->StartFldCamAnmShake(arg);
    break;
  case EVENT_SEQ_ID_START_SEN01:
    mp_unique_sequence->StartAnimation( 
        FieldUniqueSequenceBigFourWater::MDLID_WHEEL );
    break;
  case EVENT_SEQ_ID_START_BAKU01:
    mp_unique_sequence->StartAnimation( 
        FieldUniqueSequenceBigFourWater::MDLID_WATER01 );
    break;
  case EVENT_SEQ_ID_START_MIZU:
    mp_unique_sequence->StartAnimation( 
        FieldUniqueSequenceBigFourWater::MDLID_WATER02 );
    break;
  case EVENT_SEQ_ID_SET_LIGHT01:
    mp_unique_sequence->SetLight( 
        FieldUniqueSequenceBigFourWater::LIGHT_SETTING_01 );
    break;
  default:
    GFL_ASSERT_MSG(0,"sȃR}h\n");
    break;
  }
}

}

