//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		EventBigFourWater.cpp
 *	@brief  lVCxg()
 *	@author	Masayuki Onoue
 *	@date		2012.09.04
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "EventBigFourWater.h"
#include "sound/sound.h"
#include "field/FieldUniqueSequence.h"

namespace field {

//-----------------------------------------------------------------------------
/**
 *					NX`
*/
//-----------------------------------------------------------------------------

//--------------------------------------------------------------
/**
 * @brief   Cxg𓮂Ă悢ǂ̔֐ z֐
 * @param   gmgr       Q[}l[W[NX
 * @retval  true  NĂ悢
 * @retval  false NȂ
 */
//--------------------------------------------------------------
bool EventBigFourWater::BootChk(gamesystem::GameManager* gmgr)
{
  GFL_UNUSED(gmgr);
  return true;
}

//-----------------------------------------------------------------------------
/*
 *  @brief         p[^ݒ
 *                 ɌĂŉB
 *
 *  @param[in]     fieldmap          tB[h}bv
 */
//-----------------------------------------------------------------------------
void EventBigFourWater::SetParameter(field::Fieldmap* fieldmap)
{
  mp_fieldmap = fieldmap;
  mp_unique_sequence = reinterpret_cast<FieldUniqueSequenceBigFourWater*>(mp_fieldmap->GetFieldUniqueSequence());
  mp_camera = mp_fieldmap->GetGraphics()->GetCamera();
}

//--------------------------------------------------------------
/**
 * @brief   bootchktruȅꍇɂĂяo鏉֐ z֐
 * @param   gmgr       Q[}l[W[NX
 */
//--------------------------------------------------------------
void EventBigFourWater::InitFunc(gamesystem::GameManager* gmgr)
{
   
  // Cxgq[vgp
  gfl::heap::HeapBase *p_heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_EVENT );
  mp_event_seq = GFL_NEW( p_heap ) field::SequenceBigFourWater( mp_fieldmap ,p_heap );
  mp_event_seq->Initialize();
  GFL_UNUSED(gmgr);
}

//--------------------------------------------------------------
/**
 * @brief   Ăяo֐ z֐
 * @param   gmgr       Q[}l[W[NX
 * @return  GMEVENT_RESULT  Cxg֐̖߂l
 */
//--------------------------------------------------------------
gamesystem::GMEVENT_RESULT EventBigFourWater::MainFunc(gamesystem::GameManager* gmgr)
{
  switch( m_seq )
  {
  case 0:
    {
      // vC[̍擾֎~
      PlayerGrid* p_player = mp_fieldmap->GetFieldPlayer();
      GFL_ASSERT(p_player);
      if( p_player )
      {
        mmodel::MoveModel* p_model = p_player->GetModel();
        p_model->OnStatusBit( field::mmodel::MoveModelBase::STABIT_HEIGHT_GET_OFF ); 
      }
      // [U[J
      mp_camera->SetUserCameraControl(FieldStereoCamera::USER_CONTROL_NORMAL);
      // ftHgJʒu擾
      m_cam_pos_ofs_y = mp_camera->GetParameterPositionOffsetY();
      m_cam_distance  = mp_camera->GetParameterDistance();
      // oJݒ
      mp_camera->SetParameterPositionOffsetY(DEFAULT_CAM_OFS_Y);
      mp_camera->SetParameterDistance(DEFAULT_CAM_DISTANCE);
      // Gx[^ʒuC
      m_elevator_y_ofs = DEFAULT_ELEVATOR_POS_Y;
      m_seq ++;
    }
    // through break
  case 1:
    {
      // Gx[^̈ړ
      mp_unique_sequence->SetElevatorYOfs( m_elevator_y_ofs );
      m_elevator_y_ofs += DEFAULT_ELEVATOR_SPEED;
      if( m_elevator_y_ofs >= 0 )
      {
        mp_unique_sequence->SetElevatorYOfs( 0 );
        xy_snd::PlaySE( SEQ_SE_FLD_047 );
        m_seq ++;
      }
      else
      {
        return gamesystem::GMEVENT_RES_CONTINUE;
      }
    }
    // through break
  case 2:
    {
      // SequencẽAbvf[g
      mp_event_seq->Update();
      if( mp_event_seq->IsFinishAll() )
      {
        m_seq ++;
      }
    }
    return gamesystem::GMEVENT_RES_CONTINUE;
  case 3:
    {
      // t[i߂
      m_cam_event_frame++;
      // 2_Ԃ`⊮
      f32 rate = m_cam_event_frame/CAM_EVENT_FRAME;
      if( rate > 1.0f){ rate = 1.0f;}
      f32 dist  = (1.0f-rate)*DEFAULT_CAM_DISTANCE+rate*m_cam_distance;
      f32 ofs_y = (1.0f-rate)*DEFAULT_CAM_OFS_Y+rate*m_cam_pos_ofs_y;
      mp_camera->SetParameterDistance(dist);
      mp_camera->SetParameterPositionOffsetY(ofs_y);
      // I
      if( CAM_EVENT_FRAME < m_cam_event_frame )
      {
        m_seq ++;
      }
    }
    return gamesystem::GMEVENT_RES_CONTINUE;
  case 4:
    {
      // vC[̍擾Jn
      PlayerGrid* p_player = mp_fieldmap->GetFieldPlayer();
      GFL_ASSERT(p_player);
      if( p_player )
      {
        mmodel::MoveModel* p_model = p_player->GetModel();
        p_model->OffStatusBit( mmodel::MoveModelBase::STABIT_HEIGHT_GET_OFF ); 
      }
      // [U[JI
      mp_camera->SetUserCameraControl(FieldStereoCamera::USER_CONTROL_NONE);
    }
    // CxgI
    return gamesystem::GMEVENT_RES_FINISH;
  }
    
  return gamesystem::GMEVENT_RES_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   Ăяo֐ z֐
 * @param   gmgr       Q[}l[W[NX
 */
//--------------------------------------------------------------
void EventBigFourWater::EndFunc(gamesystem::GameManager* gmgr)
{
  GFL_SAFE_DELETE( mp_event_seq );
  GFL_UNUSED(gmgr);
}

}  // namespace field

