//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		FieldUniqueSequenceBigFourWater.cpp
 *	@brief  lV()Fj[NV[PX
 *	@author	Masayuki Onoue
 *	@date		2012.09.04
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

// gflib
#include <gflib.h>

// field
#include "field/Fieldmap.h"
#include "field/FieldGimmickWorkAccessor.h"

// arc
#include "arc/arc_def.h"                   // ARCID_*
#include "arc/big_four_water.gaix"
#include "big_four_water.h"

#include "gimmick_mdl_setup.h"

#include "FieldUniqueSequenceBigFourWater.h"

namespace field {

#include "FieldUniqueSequenceBigFourWater.cdat"  // fݒt@C

//----------------------------------------------------------------------------
/**
 *	@brief  RXgN^
 *
 *	@param	*pFieldmap tB[h}bv|C^
 *
 *	@retval
 */
//-----------------------------------------------------------------------------
FieldUniqueSequenceBigFourWater::FieldUniqueSequenceBigFourWater(Fieldmap* pFieldmap)
  : FieldUniqueSequence(pFieldmap),
  m_setup_seq(SETUP_LOAD_ARC),
  mp_work_buffer(NULL),
  m_arc_id(ARCID_BIG_FOUR_WATER),
  mcp_setup_table(big_four_water_setup_data),
  m_assigne_id(GIMMICK_ID_BIG_FORE_WATER),
  m_light_setting_index(LIGHT_SETTING_MAX),
  m_is_first_setup(false)
{
  mp_fieldmap = pFieldmap;
  {
    gfl::heap::HeapBase*     heap_memory      = mp_fieldmap->GetHeapField();
    gfl::heap::HeapBase*     device_memory    = mp_fieldmap->GetDeviceHeapField();
    mp_gmk_mdl_setup = GFL_NEW( heap_memory ) gimmick::GimmickMdlSetup( heap_memory, device_memory, BIG_FOUR_WATER_RES_NUM );
  }
}

//----------------------------------------------------------------------------
/**
 *	@brief@fXgN^
 */
//-----------------------------------------------------------------------------
FieldUniqueSequenceBigFourWater::~FieldUniqueSequenceBigFourWater()
{
}

//----------------------------------------------------------------------------
/**
 *	@brief  lV()pkff[^̎擾A
 *
 *	@param	none
 *
 *	@retval TRUEŏI
 */
//-----------------------------------------------------------------------------
b32 FieldUniqueSequenceBigFourWater::SetupLast(void)
{
  switch( m_setup_seq )
  {
  case SETUP_LOAD_ARC:
    {
      mp_gmk_mdl_setup->LoadArc( m_arc_id );
      m_setup_seq++;
    }
    break;
  case SETUP_LOAD_ARC_WAIT:
    {
      //[h҂
      if( mp_gmk_mdl_setup->LoadArcWait() )
      {
        m_setup_seq++;
      }
      else
      {
        break;
      }
    }
    // through break
  case SETUP_GMK_WORK:
    {
      /// M~bN[N̏
      gamesystem::GameData* p_gdata = m_pFieldmap->GetGameManager()->GetGameData();
      xy_system::weather::LightManager* light = m_pFieldmap->GetGameManager()->GetWeatherLightManager();

      // ATC̏ԂmFď
      b32 is_assigned = GimmickWorkAccessor::IsAssigned(
          p_gdata, m_assigne_id);
      // ATCs
      GimmickWorkAccessor::SecondAssign( p_gdata, m_assigne_id);
      // obt@[ۑ
      mp_work_buffer = GimmickWorkAccessor::GetWork( p_gdata );

      // ATCĂȂԂ̏ꍇ̓f[^
      if( is_assigned == FALSE )
      {
        BIG_FOUR_WATER_WORK gmk_work;
        gfl::std::MemClear( &gmk_work, sizeof(BIG_FOUR_WATER_WORK) );
        BufferAccessorType<BIG_FOUR_WATER_WORK>::SetValue(mp_work_buffer,0,gmk_work);
        // ZbgAbvtOݒ
        m_is_first_setup= true;
      }

      // lightpbN𖳌ɂ
      light->SetLightPackUpdateFlag(false);

      //---------------------------
      /// M~bN[N̏
      m_setup_seq = SETUP_MDL_DATA_SEQ;
    }
    return TRUE;
  }

  return FALSE;
}

void FieldUniqueSequenceBigFourWater::ReadyLastOnce(void)
{
  /// f̃ZbgAbv
  mp_gmk_mdl_setup->SetupResource( mcp_setup_table,
                           mp_fieldmap->GetDeviceHeapFieldAllocator() );
  gfl::grp::g3d::Scene* p_scene = mp_fieldmap->GetGraphics()->GetScene();

  //---------------------------
  /// 
  {
    // XP^Aj
    mp_gmk_mdl_setup->CreateAnime( 
        BL_IDX_BIG_FOUR_WATER_SW_GC_SEN01_BCSKLA,
        &m_anim[ANMID_WHEEL_SKLA] ,
        gfl::grp::g3d::Resource::ANIMATION_RESOURCE_TYPE_SKELETAL );
    // }eAAj
    mp_gmk_mdl_setup->CreateAnime( 
        BL_IDX_BIG_FOUR_WATER_SW_GC_SEN01_BCMATA,
        &m_anim[ANMID_WHEEL_MAT],
        gfl::grp::g3d::Resource::ANIMATION_RESOURCE_TYPE_MATERIAL );
    // Aj[VXg
    gfl::grp::g3d::ResAnim* anime_list[] = { 
      &m_anim[ANMID_WHEEL_SKLA],
      &m_anim[ANMID_WHEEL_MAT] ,
    };
    // f̍쐬
    mp_gmk_mdl_setup->CreateModel(
        mp_fieldmap->GetDeviceHeapFieldAllocator(),
        mp_fieldmap->GetHeapFieldAllocator(),
        BL_IDX_BIG_FOUR_WATER_SW_GC_SEN01_BCMDL,
        &mp_model[MDLID_WHEEL],
        anime_list,2);

    p_scene->AddSceneNode(mp_model[MDLID_WHEEL]);
    mp_model[MDLID_WHEEL]->SetVisible( false );
    mp_model[MDLID_WHEEL]->SetAnimationLoop(false,0);
    mp_model[MDLID_WHEEL]->SetAnimationLoop(false,1);
  }

  //---------------------------
  /// 01
  {
    // XP^Aj
    mp_gmk_mdl_setup->CreateAnime( 
        BL_IDX_BIG_FOUR_WATER_SW_GC_BAKU01_BCSKLA,
        &m_anim[ANMID_WATER01_SKLA] ,
        gfl::grp::g3d::Resource::ANIMATION_RESOURCE_TYPE_SKELETAL );
    // }eAAj
    mp_gmk_mdl_setup->CreateAnime( 
        BL_IDX_BIG_FOUR_WATER_SW_GC_BAKU01_BCSHDR,
        &m_anim[ANMID_WATER01_CSHADER],
        gfl::grp::g3d::Resource::ANIMATION_RESOURCE_TYPE_MATERIAL );
    // }eAAj
    mp_gmk_mdl_setup->CreateAnime( 
        BL_IDX_BIG_FOUR_WATER_SW_GC_BAKU01_BCMATA,
        &m_anim[ANMID_WATER01_MAT],
        gfl::grp::g3d::Resource::ANIMATION_RESOURCE_TYPE_MATERIAL );
    // Aj[VXg
    gfl::grp::g3d::ResAnim* anime_list[] = { 
      &m_anim[ANMID_WATER01_SKLA],
      &m_anim[ANMID_WATER01_CSHADER],
      &m_anim[ANMID_WATER01_MAT],
    };
    // f̍쐬
    mp_gmk_mdl_setup->CreateModel(
        mp_fieldmap->GetDeviceHeapFieldAllocator(),
        mp_fieldmap->GetHeapFieldAllocator(),
        BL_IDX_BIG_FOUR_WATER_SW_GC_BAKU01_BCMDL,
        &mp_model[MDLID_WATER01],
        anime_list,3);

    p_scene->AddSceneNode(mp_model[MDLID_WATER01]);
    mp_model[MDLID_WATER01]->SetVisible( true );
    mp_model[MDLID_WATER01]->SetAnimationLoop(false,0);
    mp_model[MDLID_WATER01]->SetAnimationLoop(false,1);
    mp_model[MDLID_WATER01]->SetAnimationLoop(false,2);
  }

  //---------------------------
  /// 02
  {
    // XP^Aj
    mp_gmk_mdl_setup->CreateAnime( 
        BL_IDX_BIG_FOUR_WATER_SW_GC_MIZU01_BCSKLA,
        &m_anim[ANMID_WATER02_SKLA] ,
        gfl::grp::g3d::Resource::ANIMATION_RESOURCE_TYPE_SKELETAL );
    // }eAAj
    mp_gmk_mdl_setup->CreateAnime( 
        BL_IDX_BIG_FOUR_WATER_SW_GC_MIZU01_BCSHDR,
        &m_anim[ANMID_WATER02_CSHADER],
        gfl::grp::g3d::Resource::ANIMATION_RESOURCE_TYPE_MATERIAL );
    // }eAAj
    mp_gmk_mdl_setup->CreateAnime( 
        BL_IDX_BIG_FOUR_WATER_SW_GC_MIZU01_BCMATA,
        &m_anim[ANMID_WATER02_MAT],
        gfl::grp::g3d::Resource::ANIMATION_RESOURCE_TYPE_MATERIAL );
    // Aj[VXg
    gfl::grp::g3d::ResAnim* anime_list[] = { 
      &m_anim[ANMID_WATER02_SKLA],
      &m_anim[ANMID_WATER02_CSHADER],
      &m_anim[ANMID_WATER02_MAT],
    };
    // f̍쐬
    mp_gmk_mdl_setup->CreateModel(
        mp_fieldmap->GetDeviceHeapFieldAllocator(),
        mp_fieldmap->GetHeapFieldAllocator(),
        BL_IDX_BIG_FOUR_WATER_SW_GC_MIZU01_BCMDL,
        &mp_model[MDLID_WATER02],
        anime_list,3);

    p_scene->AddSceneNode(mp_model[MDLID_WATER02]);
    mp_model[MDLID_WATER02]->SetVisible( true );
    mp_model[MDLID_WATER02]->SetAnimationLoop(true,0);
    mp_model[MDLID_WATER02]->SetAnimationLoop(true,1);
    mp_model[MDLID_WATER02]->SetAnimationLoop(true,2);
  }

  //---------------------------
  /// n`
  {
    // f̍쐬
    mp_gmk_mdl_setup->CreateModel(
        mp_fieldmap->GetDeviceHeapFieldAllocator(),
        mp_fieldmap->GetHeapFieldAllocator(),
        BL_IDX_BIG_FOUR_WATER_SW_GC_LAND01_BCMDL,
        &mp_model[MDLID_LAND] );
    p_scene->AddSceneNode(mp_model[MDLID_LAND]);
    mp_model[MDLID_LAND]->SetVisible( true );
  }
  
  // Gx[^f̍쐬
  mp_gmk_mdl_setup->CreateModel(
      mp_fieldmap->GetDeviceHeapFieldAllocator(),
      mp_fieldmap->GetHeapFieldAllocator(),
      BL_IDX_BIG_FOUR_WATER_SW_GC_ELE_01_BCMDL,
      &mp_model[MDLID_ELEVATOR] );

  //---------------------------
  ///  Cg01
  {
    // Cgݒ(Cg01)
    mp_gmk_mdl_setup->CreateSceneEnvironmentSetting(
        mp_fieldmap->GetDeviceHeapFieldAllocator(),
        mp_fieldmap->GetHeapFieldAllocator(),
        BL_IDX_BIG_FOUR_WATER_SW_GC_LIGHT01_BCSCN,
        &m_light_setting[LIGHT_SETTING_01]);

    // Cg쐬
    int anm_ofs = 0;
    for( int i=0; i < LIGHT01_NUM; i++ )
    {
      const char* key = big_four_steel_light01_setup_data[i].key;
      // Cg쐬
      mp_gmk_mdl_setup->CreateLight(
          mp_fieldmap->GetDeviceHeapFieldAllocator(),
          mp_fieldmap->GetHeapFieldAllocator(),
          BL_IDX_BIG_FOUR_WATER_SW_GC_LIGHT01_BCLGT,
          key,
          &m_light01[i] ,
          false);
    }
  }

  //---------------------------
  /// ʒuw
  static const gfl::math::VEC3 DEFAULT_POS(0.0f, 0.0f, 0.0f);

  // Gx[^
  p_scene->AddSceneNode(mp_model[MDLID_ELEVATOR]);
  gfl::math::VEC3 ev_pos(EV_DEFAULT_POS_X,EV_DEFAULT_POS_Y,EV_DEFAULT_POS_Z);
  // Gx[^̃ftHgʒuݒ
  mp_model[MDLID_ELEVATOR]->SetTranslate(ev_pos);
  mp_model[MDLID_ELEVATOR]->SetVisible( true );
 
  // ׂẴtB[hCgۑ
  for( int i = 0; i < LIGHT_NUM; i++ )
  {
    m_field_light[i] = mp_fieldmap->GetGraphics()->GetLight(i);
    p_scene->RemoveSceneNode( m_field_light[i] );
  }

  // Cg𔽉f
  SetLight( LIGHT_SETTING_01 );
  
  if( !m_is_first_setup )
  {
    // fŏIt[ɐݒ肷
    for( int i = MDLID_VISIBLE_SET_MAX; i < MDLID_MAX ;i++ )
    {
      u32 slot_num = mp_model[i]->GetAnimationSlotNum();
      for( int n = 0; n < slot_num; n++ )
      {
        f32 end_frame = mp_model[i]->GetAnimationEndFrame(n);
        mp_model[i]->SetAnimationFrame(end_frame,n);
      }
      mp_model[i]->SetVisible(true);
    }
  }

  // ZbgAbvV[PXɐݒ肷
  m_setup_seq = SETUP_END_SEQ;

}

void FieldUniqueSequenceBigFourWater::UpdateFirst(void)
{
  // ZbgAbvIĂs
  if( m_setup_seq != SETUP_END_SEQ )
  {
    return;
  }
  
  /*
   * for( int i = 0; i < MDLID_VISIBLE_SET_MAX; i++ )
   * {
   *   if( this->CheckLoopAnimation(i) == false )  // loopɂ͒~Ȃ
   *   {
   *     if( this->CheckEndAnimation(i) == true )
   *     {
   *       this->SetVisible(i,false);
   *     }
   *   }
   * }
   */
}

//----------------------------------------------------------------------------
/**
 *  @brief   CALCULATĚɌĂ΂֐
 *
 *	@param	none
 *
 *	@retval
 */
//-----------------------------------------------------------------------------
void FieldUniqueSequenceBigFourWater::CalculateAfter(void)
{
}

void FieldUniqueSequenceBigFourWater::FreeFirstOnce(void)
{
  gfl::grp::g3d::Scene* p_scene = mp_fieldmap->GetGraphics()->GetScene();

  //---------------------------
  /// eJ
  for( int i = 0; i < MDLID_MAX; i++ )
  {
    GFL_DELETE mp_model[i];
    mp_model[i] = NULL;
  }
  // Aj
  for( int i = 0; i < ANMID_MAX; i++ )
  {
    m_anim[i].Destroy();
  }

  GFL_DELETE mp_gmk_mdl_setup;
  mp_gmk_mdl_setup = NULL;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief fAj[VĐ
 *
 * @param mdl_idx fID
 */
/* -------------------------------------------------------------------------*/
void FieldUniqueSequenceBigFourWater::StartAnimation( int mdl_idx )
{
  u32 slot_num = mp_model[mdl_idx]->GetAnimationSlotNum();

  // ׂẴXbgLɂ
  for( int i = 0; i < slot_num; i++ )
  {
    mp_model[mdl_idx]->SetAnimationStepFrame(1.0f,i);
    mp_model[mdl_idx]->SetAnimationFrame(0.0f,i);
  }
  mp_model[mdl_idx]->SetVisible( true );
}

/* -------------------------------------------------------------------------*/
/**
 * @brief CgAj[VĐ
 *
 * @param light_idx CgID
 */
/* -------------------------------------------------------------------------*/
void FieldUniqueSequenceBigFourWater::SetLight( int light_idx )
{
  gfl::grp::g3d::Scene* p_scene = mp_fieldmap->GetGraphics()->GetScene();
  
  // Cg̃[u
  if( m_light_setting_index == LIGHT_SETTING_01 )
  {
    for( int i = 0; i < LIGHT01_NUM; i++ )
    {
      p_scene->RemoveSceneNode( &m_light01[i] );
    }
  }

  // Cg̐ݒ
  if( light_idx == LIGHT_SETTING_01 )
  {
    // Cgݒ肷
    for( int i = 0; i < LIGHT01_NUM; i++ )
    {
      p_scene->AddSceneNode(&m_light01[i]);
      m_light01[i].SetEnable( true );
      bool is_use_anm= big_four_water_light01_setup_data[i].is_use_anm;
      if( is_use_anm )
      {
        m_light01[i].SetAnimationStepFrame(1.0f);
      }
    }
  }

  // lightݒ蔽fO
  p_scene->Initialize(); 

  // V[̎QƉsݒ肵܂B
  p_scene->SetSceneEnvironmentSetting( &m_light_setting[light_idx] );

  // Cg̐ݒ菊ۑ
  m_light_setting_index = light_idx;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief fAj[V̏I
 *
 * @param mdl_idx fID
 *
 * @return true̎I
 */
/* -------------------------------------------------------------------------*/
bool FieldUniqueSequenceBigFourWater::CheckEndAnimation( int mdl_idx )
{
  u32 slot_num = mp_model[mdl_idx]->GetAnimationSlotNum();

  // ׂẴXbg`FbNɂ
  for( int i = 0; i < slot_num; i++ )
  {
    if( mp_model[mdl_idx]->IsAnimationFrameEndFrame(i) == false )
    {
      return false;
    }
  }
  return true;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief fAj[Ṽ[v
 *
 * @param mdl_idx fID
 *
 * @return true̎loop
 */
/* -------------------------------------------------------------------------*/
bool FieldUniqueSequenceBigFourWater::CheckLoopAnimation( int mdl_idx )
{
  u32 slot_num = mp_model[mdl_idx]->GetAnimationSlotNum();

  // ׂẴXbg`FbNɂ
  for( int i = 0; i < slot_num; i++ )
  {
    if( mp_model[mdl_idx]->IsAnimationLoop(i) == true )
    {
      return true;
    }
  }
  return false;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief f̕\Ԑݒ
 *
 * @param visible true̎`悳
 */
/* -------------------------------------------------------------------------*/
void FieldUniqueSequenceBigFourWater::SetVisible( int mdl_idx,bool visible )
{
  mp_model[mdl_idx]->SetVisible( visible );
}

/* -------------------------------------------------------------------------*/
/**
 * @brief Gx[^̃ItZbgʒuݒ肷iYWj
 *
 * @param ofs_y YItZbg
 */
/* -------------------------------------------------------------------------*/
void FieldUniqueSequenceBigFourWater::SetElevatorYOfs( f32 ofs_y )
{
  // vC[݂ȂƂsȂ
  PlayerGrid* p_player = mp_fieldmap->GetFieldPlayer();
  if( p_player ){
    field::mmodel::MoveModel* p_mmodel = p_player->GetModel();
    Mapper* p_mapper = mp_fieldmap->GetMapper();
    Position pos( p_mapper->GetRailSystem(), p_mapper );
    gfl::math::VEC3 player_pos(PLAYER_DEFAULT_POS_X,PLAYER_DEFAULT_POS_Y,PLAYER_DEFAULT_POS_Z);
    player_pos.y += ofs_y;
    pos.SetTranslate(&player_pos);
    p_mmodel->UpdateVectorPos(pos);
  }
    
  // Gx[^̈ʒuύX
  gfl::math::VEC3 ev_pos(EV_DEFAULT_POS_X,EV_DEFAULT_POS_Y,EV_DEFAULT_POS_Z);
  ev_pos.y += ofs_y;
  mp_model[MDLID_ELEVATOR]->SetTranslate(ev_pos);
}


} // namespace field

