# -*- coding: shift-jis -*-
#==============================================================================
# @brief trainer.txt𐶐
# @brief trtype_conv.rbx[Xɉ
# @file trtype_conv.rb
# @author obata_toshihiro changed by soga
# @date 2012.09.03
#
# 0: g[i[^Cve[u(.csv)̃pX
#============================================================================== 

TRTYPE_TABLE            = ARGV[0] 


#------------------------------------------------------------------------------
# R[h
#------------------------------------------------------------------------------
class TrainerType
  def initialize
    @ID = nil        # g[i[^CvID
    @kind = nil      # g[i[
    @sex = nil       # 
    @group = nil     # g[i[^CvO[v
    @eyeBGM = nil    # BGM
    @effect = nil    # ogGtFNg
    @comment = nil   # Rg
  end 
  attr_accessor :ID, :kind, :sex, :group, :eyeBGM, :effect, :comment
end 

file = File.open( TRTYPE_TABLE, "r" )
records = file.readlines
file.close 

tr_type_array = Array.new

records.each do |record|
  record.gsub!( '"', '' ) # "
  fields = record.split(',')
  tr_type = TrainerType.new
  tr_type.ID         = fields[0]
  tr_type.kind       = fields[1]
  tr_type.sex        = fields[2]
  tr_type.group      = fields[3]
  tr_type.eyeBGM     = fields[4]
  tr_type.effect     = fields[5]
  tr_type.comment    = fields[6].chomp
  tr_type_array << tr_type
end

#------------------------------------------------------------------------------ 
# trainer.txto
#------------------------------------------------------------------------------ 
file = File.open( "trainer.txt", 'w' )
0.upto( tr_type_array.size - 1 ) do |i|
  tr_type = tr_type_array[i]
  file.puts "#{tr_type.ID.sub("TRTYPE_","")}#{tr_type.sex}#{tr_type.kind}"
end
file.close

