//==============================================================================
/**
 * @file	friend_entry_view.h
 * @brief	tho^	OtBbN
 * @author	ichiraku_katsuhiko(x[X̂)
 * @data	2012/08/31, 3:27
 */
// =============================================================================

#if !defined( __FRIEND_ENTRY_VIEW_H__ )
#define	__FRIEND_ENTRY_VIEW_H__

#include <app/util/app_util_heap.h>
#include <app/util/app_util_2d.h>
#include <app/ui/UIView.h>
#include <app/ui/UIInputListener.h>

#include "friend_entryUIListener.h"

GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(friend_entry)

/**
 *	r[
 */
class ViewWork : public app::ui::UIView, public app::ui::UIInputListener
{
	GFL_FORBID_COPY_AND_ASSIGN(ViewWork);
public:

	//-------------------------------------
  ///	{^`
  //=====================================
	enum{
		BUTTON_1,	///< {^1
		BUTTON_2,	///< {^2
		BUTTON_3,	///< {^3
	};

private:
	typedef enum{
		LAYOUT_ID_UPPER,
		LAYOUT_ID_LOWER,
		LAYOUT_ID_MAX,
	}LAYOUT_ID;


	// LAj[V
	static const u32 SHARE_BUTTON_NUM = 3;
	enum AnimationDataId {
		ANIMATION_DATA_SELECT_2,			// {^2
		ANIMATION_DATA_SELECT_3,			// {^3
		ANIMATION_DATA_BUTTON_ON_TOUCH_DUMMY,
		ANIMATION_DATA_BUTTON_ON_CANCEL_DUMMY,
		ANIMATION_DATA_BUTTON_ON_RELEASE_DUMMY,
		ANIMATION_DATA_BUTTON_ON_ACTIVE_DUMMY,
		ANIMATION_DATA_BUTTON_ON_PASSIVE_DUMMY,
		ANIMATION_DATA_NUM,
	};
	enum AnimetionId {
		// ȉALAj[V
		ANIMATION_BUTTON_01_ON_TOUCH		= ANIMATION_DATA_NUM,
		ANIMATION_BUTTON_01_ON_CANCEL		= ANIMATION_BUTTON_01_ON_TOUCH	+ SHARE_BUTTON_NUM,
		ANIMATION_BUTTON_01_ON_RELEASE	= ANIMATION_BUTTON_01_ON_CANCEL	+ SHARE_BUTTON_NUM,
		ANIMATION_BUTTON_01_ON_ACTIVE		= ANIMATION_BUTTON_01_ON_RELEASE+ SHARE_BUTTON_NUM,
		ANIMATION_BUTTON_01_ON_PASSIVE	= ANIMATION_BUTTON_01_ON_ACTIVE	+ SHARE_BUTTON_NUM,
		ANIMATION_NUM										= ANIMATION_BUTTON_01_ON_PASSIVE+ SHARE_BUTTON_NUM,
	};
	
public:
  // RXgN^
  ViewWork( app::util::Heap * heap );

  // fXgN^
  virtual ~ViewWork( void );

public:
	void SetFriendEntryUIListener( FriendEntryUIListener *listener );

public:
	virtual void Update( void );
	virtual void Draw( void );

public:
  // yCANVʒmpXi
  virtual bool OnLayoutPaneEvent( const u32 painId );
  // L[͒ʒmpXi
  virtual bool OnKeyAction( gfl::ui::Button* pKey, gfl::ui::VectorDevice* pStick);

private:
	void Initialize2D( app::util::Heap *heap );
	void CreateShareAnime( void );

private:
	app::util::Heap*			m_heap;		///< q[v

	FriendEntryUIListener*		m_uiListener;		///< UICxgXi
};


GFL_NAMESPACE_END(friend_entry)
GFL_NAMESPACE_END(netapp)

#endif	/* __FRIEND_ENTRY_VIEW_H__ */

