//==============================================================================
/**
 * @file	friend_entry_main.h
 * @brief	tho^Av	C
 * @author	ichiraku_katsuhiko(x[X̂)
 * @data	2012/08/30, 22:01
 */
// =============================================================================

#if !defined( __FRIEND_ENTRY_MAIN_H__ )
#define	__FRIEND_ENTRY_MAIN_H__


#include <netapp/friend_entry/friend_entry.h>

#include "friend_entry_view.h"
#include "friend_entryUIListener.h"

GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(friend_entry)

class MainSystem : public FriendEntryUIListener
{
private:
	//-------------------------------------
	/// CV[PX`
  //=====================================
	typedef enum {
		MAINSEQ_INIT = 0,
		MAINSEQ_MAIN,
		MAINSEQ_FADE_OUT,
		MAINSEQ_RELEASE,
		MAINSEQ_END,
	}ENUM_MAIN_SEQ;

public:
  // RXgN^
  MainSystem( APP_PARAM *prm );
  // fXgN^
  virtual ~MainSystem( void );

public:
	bool Update( void );
	void Draw( void );

	//--------------------------------------------------------------
	// UIXi[
	virtual void OnSelectButton( int button_no );

private:
	void CreateSubWork( void );
	void DeleteSubWork( void );

	void SetFadeIn( void );
	void SetFadeOut( void );
	void SetFinish( void );	// Iݒ
	void SetMainSeq( ENUM_MAIN_SEQ seq );
	
	bool DoSeqProcess( void );

	// EFCg
	void SetWait( const int wait );
	bool IsEndWait( void ) const;

private:
	// CV[PX
	void MainSeq_Init( void );
	bool MainSeq_Release( void );
	void MainSeq_Fade( ENUM_MAIN_SEQ seq );
	void MainSeq_Main( void );

private:
  static const u32 APP_HEAP_SIZE    = 0x12000;   // Avp[Jq[vTCY
  static const u32 DEVICE_HEAP_SIZE = 0xD8000;   // Avp[JfoCXq[vTCY

private:
	ViewWork*								m_view;						///< `Ǘ
  app::util::Heap         m_heap;           ///< q[vǗ
  APP_PARAM*              m_appParam;       ///< Np[^
  ENUM_MAIN_SEQ 					m_seq;						///< JgV[PX
  bool                    m_isFinish;       ///< fItO

	u16											m_subseq;					///< TuV[PX
	int											m_wait;						///< EFCg

};


GFL_NAMESPACE_END(friend_entry)
GFL_NAMESPACE_END(netapp)



#endif	/* __FRIEND_ENTRY_MAIN_H__ */

