//==============================================================================
/**
 * @file	friend_entry_main.cpp
 * @brief	tho^Av	C
 * @author	ichiraku_katsuhiko(x[X̂)
 * @data	2012/08/31, 3:11
 */
// =============================================================================


#include <gamesystem/ForcedReturnManager.h>
#include "friend_entry_main.h"


GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(friend_entry)


// RXgN^
MainSystem::MainSystem( APP_PARAM *prm )
{
	m_view			= NULL;
	m_isFinish	= false;
	m_subseq		= 0;

	m_appParam	= prm;

	SetMainSeq( MAINSEQ_INIT );
}

// fXgN^
MainSystem::~MainSystem( void )
{
	DeleteSubWork();
}

//--------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 * 
 * @retval	true:
 * @retval	false:ȊO
 */
//--------------------------------------------------------------------------
bool MainSystem::Update( void )
{
	bool isRunning = DoSeqProcess();

	if( m_view != NULL ) 
	{
		m_view->Update();
	}

	return isRunning;
}

//--------------------------------------------------------------------------
/**
 * @brief		`揈
 */
//--------------------------------------------------------------------------
void MainSystem::Draw( void )
{
	if( m_view != NULL )
	{
		m_view->Draw();
	}
}

//--------------------------------------------------------------------------
/**
 * @brief		{^Iʒm
 * @param		{^ԍ 0-2
 */
//--------------------------------------------------------------------------
void MainSystem::OnSelectButton( int button_no )
{
  xy_snd::PlaySE( SEQ_SE_DECIDE1 );
	ICHI_PRINT("{^%d ꂽ\n", button_no );
#if 0
	{
		switch( button_no ){
		case 0: SetFinish( END_MODE_BUTTON1 ); break; // ͂
		case 1: SetFinish( END_MODE_BUTTON2 ); break; // 
		}
	}
#endif
}

//--------------------------------------------------------------------------
/**
 * @brief		V[PXʃvZX
 * 
 * @retval	true:
 * @retval	false:ȊO
 */
//--------------------------------------------------------------------------
bool MainSystem::DoSeqProcess( void )
{
	switch( m_seq ){
	case MAINSEQ_INIT:			MainSeq_Init();											break;
	case MAINSEQ_MAIN:			MainSeq_Main();											break;
	case MAINSEQ_FADE_OUT:	MainSeq_Fade( MAINSEQ_RELEASE );		break;
	case MAINSEQ_RELEASE:
		if( !MainSeq_Release()	){
			break;
		}
		/* break through */
	case MAINSEQ_END:
		return false;
	}
	return true;
}

//--------------------------------------------------------------------------
/**
 * @brief		EFCgݒ
 * 
 * @param		wait
 * 
 * @note	IsEndWaitŏI𔻒肷
 */
//--------------------------------------------------------------------------
void MainSystem::SetWait( const int wait )
{
	m_wait = wait;
}

//--------------------------------------------------------------------------
/**
 * @brief		EFCgI
 * 
 * @retval	true:I
 * @retval	false:EFCg
 */
//--------------------------------------------------------------------------
bool MainSystem::IsEndWait( void ) const
{
	return ( m_wait == 0 );
}

//--------------------------------------------------------------------------
/**
 * @brief		Tu[N쐬
 */
//--------------------------------------------------------------------------
void MainSystem::CreateSubWork( void )
{
#if 1 // q[vcʃ`FbN
	{
      gfl::heap::HeapBase* app_heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
      gfl::heap::HeapBase* dev_heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );
      GFL_PRINT( "HEAPID_FREE: 0x%x/0x%x, 0x%x/0x%x\n", 
          app_heap->GetTotalFreeSize(), app_heap->GetTotalSize(),
          dev_heap->GetTotalFreeSize(), dev_heap->GetTotalSize() );
	}
#endif
	

  m_heap.Create( gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP ),
	               gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE ),
	               HEAPID_FRIEND_ENTRY_APP, APP_HEAP_SIZE, HEAPID_FRIEND_ENTRY_DEVICE, DEVICE_HEAP_SIZE );


	m_view = GFL_NEW( m_heap.pHeap ) ViewWork( &m_heap );

	m_view->SetFriendEntryUIListener( this );
}

//--------------------------------------------------------------------------
/**
 * @brief		Tu[N폜
 */
//--------------------------------------------------------------------------
void MainSystem::DeleteSubWork( void )
{
	GFL_SAFE_DELETE( m_view );
	m_heap.Delete();
}

//--------------------------------------------------------------------------
/**
 * @brief		tF[hCZbg
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------
void MainSystem::SetFadeIn( void )
{
  gfl::grp::Fade_Reset( gfl::grp::Fade::DISP_DOUBLE );
}

//--------------------------------------------------------------------------
/**
 * @brief		tF[hAEgZbg
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------
void MainSystem::SetFadeOut( void )
{
  gfl::grp::Fade_RequestOut( gfl::grp::Fade::DISP_DOUBLE, gfl::grp::Fade::OUTTYPE_BLACK, 8, false );
}

//==========================================================================
/**
 *					CV[PX
 */
//==========================================================================
//--------------------------------------------------------------------------
/**
 * @brief		CV[PXF
 *
 * @param		none
 *
 * @return	̃V[PX
 */
//--------------------------------------------------------------------------
void MainSystem::MainSeq_Init( void )
{
	m_isFinish	= false;

	// Tu[N쐬
	CreateSubWork();

	// tF[hC
	SetFadeIn();
	SetMainSeq( MAINSEQ_MAIN );
}

//--------------------------------------------------------------------------
/**
 * @brief		CV[PXF
 *
 * @param		none
 *
 * @retval	true:
 * @retval	true:쒆
 */
//--------------------------------------------------------------------------
bool MainSystem::MainSeq_Release( void )
{
	// Tu[N폜
	DeleteSubWork();
	SetMainSeq( MAINSEQ_END );

	return true;
}

//--------------------------------------------------------------------------
/**
 * @brief		CV[PXFtF[h҂
 *
 * @param		seq	̃V[PX
 */
//--------------------------------------------------------------------------
void MainSystem::MainSeq_Fade( ENUM_MAIN_SEQ seq )
{
	if( gfl::grp::Fade_IsEnd() ){
	  SetMainSeq( seq );
	}
}

//--------------------------------------------------------------------------
/**
 * @brief		CV[PXFtF[h҂
 *
 * @param		seq	̃V[PX
 */
//--------------------------------------------------------------------------
void MainSystem::MainSeq_Main( void )
{

	// wait
	if( m_wait > 0 ){ m_wait--; };
	
  if( m_isFinish ||
      GFL_SINGLETON_INSTANCE(gamesystem::ForcedReturnManager)->IsReturn(gamesystem::ForcedReturnManager::FORCERETURN_APP) )
  {
		SetFadeOut();
    SetMainSeq( MAINSEQ_FADE_OUT );
  }
}

//------------------------------------------------------------------
/**
 * @brief CV[PXݒ
 *
 * @param  seq   ؂ւΏۂƂȂV[PX
 */
//------------------------------------------------------------------
void MainSystem::SetMainSeq( ENUM_MAIN_SEQ seq )
{
  m_seq = seq;
}

//------------------------------------------------------------------
/**
 * @brief  j[̏Iݒ
 */
//------------------------------------------------------------------
void MainSystem::SetFinish( void )
{
	m_isFinish = true;
  // ȍ~̃L[֎~
  m_view->SetInputEnabled( false );
}

GFL_NAMESPACE_END(friend_entry)
GFL_NAMESPACE_END(netapp)
