//=============================================================================
/**
 * @file    TrainerTypeData.cpp
 * @brief   g[i[^Cṽf[^
 * @date    2012.08.29
 * @author  tamada
 */
//=============================================================================

#include "trainer/TrainerTypeData.h"
#include "trainer/tr_bt_gra_no.h"

GFL_NAMESPACE_BEGIN(trainer);

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
TrainerTypeData::TrainerTypeData():
  mTrType(-1)
{
  gfl::std::MemClear( &mCoreData, sizeof(TRTYPE_DATA) );
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
void TrainerTypeData::LoadData( gfl::heap::HeapBase* pHeap, TrType trtype )
{
  mTrType = trtype;
  gfl::fs::ArcFile* pArc = GFL_NEW( pHeap->GetLowerHandle() )
    gfl::fs::ArcFile( pHeap, ARCID_TRTYPE_DATA, gfl::fs::ArcFile::OPEN );

  if( pArc ){
    pArc->LoadData( trtype, &mCoreData );
    GFL_DELETE( pArc );
  }
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
u8 TrainerTypeData::GetSex( void )
{
  return mCoreData.sex;
}

u8 TrainerTypeData::GetGroup( void )
{
  return mCoreData.group;
}

u32 TrainerTypeData::GetEyeBGM( void )
{
  return mCoreData.eye_bgm;
}

u32 TrainerTypeData::GetBattleEffectID( void )
{
  return mCoreData.btl_eff_id;
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
int TrainerTypeData::GetBattleModelID( void )
{
 int btlTrId = -1;

  switch( mTrType )
  {
  case trainer::TRTYPE_HERO:   // |Pg[i[  l
  case trainer::TRTYPE_RIVALM: // |Pg[i[  l
    btlTrId = TR_BT_GRA_0001;
    break;
  case trainer::TRTYPE_HEROINE:// |Pg[i[  l
  case trainer::TRTYPE_RIVALW: // |Pg[i[  l
    btlTrId = TR_BT_GRA_0002;
    break;

  case trainer::TRTYPE_FRIEND1:// Ƃ  B
    btlTrId = TR_BT_GRA_0003;
    break;
  case trainer::TRTYPE_FRIEND2:// Ƃ  C
    btlTrId = TR_BT_GRA_0004;
    break;
  case trainer::TRTYPE_FRIEND3:// Ƃ  D
    btlTrId = TR_BT_GRA_0005;
    break;

  case trainer::TRTYPE_FLAREW:// tA  
    btlTrId = TR_BT_GRA_0027;
    break;
  case trainer::TRTYPE_FLAREM:// tA  
    btlTrId = TR_BT_GRA_0026;
    break;
  case trainer::TRTYPE_FLAREKANBU2:// tA  
    btlTrId = TR_BT_GRA_0023;
    break;
  case trainer::TRTYPE_FLAREKANBU1: // tA  
    btlTrId = TR_BT_GRA_0022;
    break;
  }
  return btlTrId;
}

//-----------------------------------------------------------------------------
/**
 */
//-----------------------------------------------------------------------------
int TrainerTypeData::GetBattle2DID( void )
{
  int gra_id = -1;
#if 0
  switch ( mTrType )
  {
  }
#endif
  return gra_id;
}

GFL_NAMESPACE_END(trainer);

