//=============================================================================
/**
 * @file    TrainerTypeData.h
 * @brief   g[i[^Cṽf[^
 * @date    2012.08.29
 * @author  tamada
 */
//=============================================================================
#if !defined(__TRAINERTYPEDATA_H__)
#define __TRAINERTYPEDATA_H__

#include <gflib.h>

GFL_NAMESPACE_BEGIN(trainer)

//-----------------------------------------------------------------------------
/**
 * @class TrainerTypeData
 */
//-----------------------------------------------------------------------------
class TrainerTypeData
{
public:
  TrainerTypeData();
  ~TrainerTypeData() {};

  void LoadData( gfl::heap::HeapBase* pHeap, TrType trtype );

  u8 GetSex( void );
  u8 GetGroup( void );
  u32 GetEyeBGM( void );
  u32 GetBattleEffectID( void );
  int GetBattleModelID( void );
  int GetBattle2DID( void );

private:
  s32 mTrType;
  TRTYPE_DATA mCoreData;

};


GFL_NAMESPACE_END(trainer);

#endif  // __TRAINERTYPEDATA_H__
