//===================================================================================================
/*
 *  @file   ScriptFuncSetPopupMsg.cpp
 *  @brief  |bvAbvbZ[WM~bN XNvgR}hZbg
 *  @author iwasawa
 *  @date   12.08.27
 *
 *  @note   ScriptFuncSetGimmick.cppincludeėp
 */
//===================================================================================================

#include "field/FieldUniqueSequenceC02.h"

static popmsg::PopupMsgSystem* _GetPopupMsgSystem( gamesystem::GameManager* p_gman )
{
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  
  FieldUniqueSequenceC02* uniqueSeq = static_cast<FieldUniqueSequenceC02*>(p_fieldmap->GetFieldUniqueSequence());
  return uniqueSeq->GetPopupMsgSystem();
}

//-----------------------------------------------------------------------------
/**
 *  @brief  |bvAbvbZ[W NCxg
 *
 *  @retval true  Nł 
 *  @retval false NłȂ
 */
//-----------------------------------------------------------------------------
cell AMX_NATIVE_CALL FuncSetGimmick::PopupMsgStartEvent(AMX * amx, const cell * ptr)
{
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  
  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  Work* p_script_work = p_obj->GetWork();
  int event_id = p_script_work->GetCurrentEventDataID();

  popmsg::PopupMsgSystem* pPopupMsgSys = _GetPopupMsgSystem(p_gman);

  if( pPopupMsgSys->Start( event_id ) ){
    //R[hZbg
    savedata::MyStatus* status = p_gman->GetGameData()->GetPlayerStatus();
    WordSet* wset = pThis->GetSystemWork()->GetWordSet();

    wset->RegisterPlayerName( 0, status );  //vC[
    wset->RegisterPlayerNickName( 1, status ); //vC[jbNl[
    return true;
  }
  return false;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  |bvAbvbZ[W p[^Zbg 
 *
 *  @retval true:I
 */
//-----------------------------------------------------------------------------
cell AMX_NATIVE_CALL FuncSetGimmick::PopupMsgParamSetCore(AMX * amx, const cell * ptr)
{
  u8  idx       = ptr[1];
  s32 str_id    = ptr[2];
  s32 win_pos_x = ptr[3];
  s32 win_pos_y = ptr[4];
  u16 win_type  = ptr[5];
  s32 timer     = ptr[6];
  u32 option    = ptr[7];

  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
 
  popmsg::PopupMsgSystem* pPopupMsgSys = _GetPopupMsgSystem(p_gman);

  // NGXgf[^쐬ANGXg𔭍s
  MsgWinUnit::WindowCallParam param;
  MsgWinUnit::WindowCallParamInitUtil(&param, WIN_ID_AUTO, option);

  param.win_pos.x         = win_pos_x;
  param.win_pos.y         = win_pos_y;
  param.win_type          = win_type;
  param.timer             = timer;
  param.is_no_tail        = true;

  //p[^ʒm
  pPopupMsgSys->SetUnitParam( idx, str_id, &param,  pThis->GetSystemWork()->GetWordSet() );

//  win_id = p_msgwin->SetMessageRequest( param );
  
  return NULL;
}

