//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		PopupMsgSystem.cpp
 *	@brief  tB[h |bvAbvbZ[WM~bN
 *	@author iwasawa	
 *	@date		2012.08.26
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include <pmlib.h>
#include <arc/arc_def.h>

#include "PopupMsgSystem.h"
#include "savedata/MyStatus.h"
namespace field{
  namespace popmsg{

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------
    //----------------------------------------------------------------------------
    /**
     *	@brief  PopupMsgSystemRXgN^ 
     */
    //-----------------------------------------------------------------------------
    PopupMsgSystem::PopupMsgSystem( gamesystem::GameData* p_gdata, Fieldmap* p_field ):
      m_pGameData( p_gdata ),
      m_pFieldmap( p_field ),
      m_pHeap( NULL ),
      m_pPlayer( NULL ),
      m_unitNum( 0 ),
      m_pUnitAry( NULL ),
      m_pMsgBuf( NULL ),
      m_pMsgData( NULL ),
      m_init_f( false ),
      m_zoneID( ZONE_ID_MAX ),
      m_eventID( EVENT_ID_NONE )
    {
      gfl::std::MemClear( &m_posEvData, sizeof(POS_EVENT_DATA) );
    }
    
    //----------------------------------------------------------------------------
    /**
     *	@brief  PopupMsgSystemCjVCY
     */
    //-----------------------------------------------------------------------------
    void PopupMsgSystem::Initialize( ZoneID zone_id, gfl::heap::HeapBase* p_heap )
    {
      m_pHeap = p_heap;

      //][IDۑ
      //m_zoneID = zone_id;

      //vC[ۑ
      m_pPlayer = m_pFieldmap->GetFieldPlayer();

      //jbg
      m_unitNum = UNIT_MAX;
      m_pUnitAry = GFL_NEW_ARRAY( p_heap ) PopupMsgUnit*[ m_unitNum ];

      for( int i = 0;i < m_unitNum; ++i ){
        m_pUnitAry[i] = GFL_NEW( p_heap ) PopupMsgUnit( p_heap, m_pFieldmap );
      }
      
      //bZ[Wt@Cp
      {
        gfl::fs::FileReadManager* p_fileman = m_pFieldmap->GetFileReadManager();
        p_fileman->AppendManageFile( p_heap->GetLowerHandle(), ARCID_MESSAGE );
        p_fileman->AddReadRequest( &m_pMsgBuf, NULL, p_heap, 4, ARCID_MESSAGE, GARC_message_popmsg_c02_DAT, false );
      }
    }
    //----------------------------------------------------------------------------
    /**
     *	@brief  PopupMsgSystemCjVCY҂
     *	@retval true  ZbgAbvI
     */
    //-----------------------------------------------------------------------------
    bool PopupMsgSystem::InitializeWait( void )
    {
      if( m_init_f ) return true; //ǂݍݏI̊֐Ă΂đvȂ悤ɍĂ

      gfl::fs::FileReadManager* p_fileman = m_pFieldmap->GetFileReadManager();

      if( p_fileman->IsReadFinished( &m_pMsgBuf ) )
      {
        m_pMsgData = GFL_NEW( m_pHeap ) gfl::str::MsgData( m_pMsgBuf, m_pHeap );
        p_fileman->RemoveManageFile(ARCID_MESSAGE);
        m_init_f = true;
      }
      return m_init_f; 
    }

    //----------------------------------------------------------------------------
    /**
     *	@brief  PopupMsgSystemt@CiCY
     */
    //-----------------------------------------------------------------------------
    void PopupMsgSystem::Finalize( void )
    {
      //bZ[Wf[^
      GFL_DELETE( m_pMsgData );
      GflHeapSafeFreeMemory( m_pMsgBuf );

      //jbg
      for( int i = 0;i < m_unitNum; ++i ){
        GFL_DELETE( m_pUnitAry[i] );
      }
      GFL_DELETE_ARRAY m_pUnitAry;
      m_unitNum = 0;
     //   mp_unique_sequence = reinterpret_cast<FieldUniqueSequenceGymFairy*>(mp_fieldmap->GetFieldUniqueSequence());
  
#if 0
      PositionData pos_data;
      EventWork* evwork = reqData.p_gamedata->GetEventWork();
      EventDataSystem* evsys = reqData.p_gamedata->GetEventDataSystem();
      reqData.cp_now_pos->GetTranslate( &pos_data );
#endif
    }
    
    //----------------------------------------------------------------------------
    /**
     *	@brief  PopupMsgSystem N`FbN
     *
     *	@retval true  N 
     */
    //-----------------------------------------------------------------------------
    bool PopupMsgSystem::Start( int event_id )
    {
      EventDataSystem* evsys = m_pGameData->GetEventDataSystem();
      
      //ɋNς݂H
      if( m_eventID != EVENT_ID_NONE){
        return false;
      }
      //Cxgf[^擾
      if( evsys->GetPosEventData( &m_posEvData, event_id, true ) == false ){
        return false; //f[^Ȃ(ƃf[^ݒ肳Ă΂蓾Ȃ)
      }
      m_eventID = event_id;
      m_zoneID =  m_pFieldmap->GetZoneID();
      return true;
    }
    
    //----------------------------------------------------------------------------
    /**
     *	@brief  PopupMsgSystem I 
     */
    //-----------------------------------------------------------------------------
    void PopupMsgSystem::End( void )
    {
      for( int i = 0;i < UNIT_MAX; ++i ){
        m_pUnitAry[i]->Finalize();
      }
      gfl::std::MemClear( &m_posEvData, sizeof(POS_EVENT_DATA) );
      m_eventID = EVENT_ID_NONE;
      m_zoneID = ZONE_ID_MAX;
    }
    
    //----------------------------------------------------------------------------
    /**
     *	@brief  PopupMsgSystem Abvf[g 
     */
    //-----------------------------------------------------------------------------
    void PopupMsgSystem::Update( void )
    {
      ZoneID zoneID = m_pFieldmap->GetZoneID();
      PositionData pos_data;
      m_pPlayer->GetPosition()->GetTranslate(&pos_data);

      if( m_zoneID != zoneID || PosEventData::Check( &m_posEvData, &pos_data, true ) == false ){
        //GAOꂽ
        End();
        return;
      }
      //vC[ʒuGA`FbN
      for( int i = 0;i < UNIT_MAX; ++i ){
        if( m_pUnitAry[i]->IsEnable() ){
          m_pUnitAry[i]->Update();
        }
      }
    }

    //----------------------------------------------------------------------------
    /**
     *	@brief  PopupMsgSystem EBhEp[^o^
     */
    //-----------------------------------------------------------------------------
    void PopupMsgSystem::SetUnitParam( u8 idx, int str_id, MsgWinUnit::WindowCallParam* param, WordSet* p_wset )
    {
      m_pUnitAry[idx]->Initialize( str_id, param, m_pMsgData, p_wset );
    }
#if 0 
    //----------------------------------------------------------------------------
    /**
     *	@brief  PopupMsgSystem N 
     */
    //-----------------------------------------------------------------------------
    void PopupMsgSystem::Start( WordSet* p_wset, int event_id )
    {
      m_eventID = event_id;

      savedata::MyStatus* status = m_pGameData->GetPlayerStatus();
      p_wset->RegisterPlayerName( 0, status );  //vC[
      p_wset->RegisterPlayerNickName( 1, status ); //vC[jbNl[

      //bZ[W
      for( int i = 0;i < UNIT_MAX; ++i ){
        m_pMsgData->GetString( msg_id, tmpbuf);
        p_wset->Expand(&strbuf, &tmpbuf);
      }

      // N[Y
      //p_msgwin->Close( win_id );

    }
#endif

  } // namespace popmsg 
} // namespace field
