#include <stdlib.h>
#include <gflib.h>
#include "CecIntervalReset.h"

#include <netapp/cfg/NetConfig.h>
#include <system/thread_priority.h>
#include <net/net_define.h>
#include <netapp/cec/CecSystem.h>

namespace test {
namespace kosaka {

//-------------------------------------
// For Debug
//-------------------------------------
//-------------------------------------
	
//============================================================================================


CecIntervalReset::CecIntervalReset() 
: m_isFinish(false)
, m_state(0)
, pCec(NULL)
{
	m_heap.Create( HEAPID_GIFT_APP, GIFT_APP_HEAP_SIZE, HEAPID_GIFT_DEVICE, GIFT_DEVICE_HEAP_SIZE );
}

CecIntervalReset::~CecIntervalReset()
{
	m_heap.Delete();
}

gfl::proc::Result CecIntervalReset::InitFunc( gfl::proc::Manager * proc_manager )
{
	GFL_PRINT("ႢʐM8ԐZbgJn:B{^ŏI\n");
	 pCec = GFL_NEW( m_heap.pHeap ) netapp::cec::CecSystem;

    pCec->Initialize( m_heap.pHeap );

	nn::Result result = nn::cec::CecControl::StartScanning(true);
	if( !result.IsSuccess() )
	{//G[
		GFL_PRINT("Zbgs\n");
	}
	else
	{
		GFL_PRINT("ZbgI\nB{^ŏIAzObɓAӂƂႢʐMs܂B\n");
	}
	
	return gfl::proc::RES_FINISH;
}

gfl::proc::Result CecIntervalReset::EndFunc( gfl::proc::Manager * proc_manager )
{
	GFL_PRINT("ႢʐM8ԐZbgI\n");
	
	pCec->Finalize();
	
	GFL_SAFE_DELETE( pCec );
	
	return gfl::proc::RES_FINISH;
}

gfl::proc::Result CecIntervalReset::UpdateFunc( gfl::proc::Manager * proc_manager )
{
	gamesystem::GameManager* game_manager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
	gfl::ui::Button * pButton = game_manager->GetUiDeviceManager()->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
	
	if( pButton->IsTrigger( gfl::ui::BUTTON_B ) )
	{
		return gfl::proc::RES_FINISH;
	}
	
	
	return gfl::proc::RES_CONTINUE;
	//return gfl::proc::RES_FINISH;
}

void CecIntervalReset::DrawFunc( gfl::proc::Manager * proc_manager )
{
}



} // namespace kosaka
} // namespace test

