//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *  @file    sv_cec_history.cpp
 *  @brief  ႢʐM
 *  @author  Shin Kosaka
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <savedata/sv_cec_history.h>

GFL_NAMESPACE_BEGIN(savedata)

//=============================================================================
//@brief RXgN^EfXgN^
//=============================================================================
/**
 * @brief RXgN^
 */
CecHistory::CecHistory()
{
  this->Clear(NULL);
}

/**
 * @brief fXgN^
 */
CecHistory::~CecHistory()
{

}


//=============================================================================
//@brief 擾E
//=============================================================================
/**
* @brief Ⴂ{bNXf[^oo^
*
* @note őo^𒴂ꍇ̓L[Ȃ
*
* @param date o^
* @param serialId o^vVpID
*/
void CecHistory::PushCecHistory( const u32 principalId , const nn::fnd::DateTimeParameters& date )
{
  if( IsExistCecHistory(principalId,date) ){
    return; // ɓo^ς
  }

  // 󂫂݂ȂH
  if( m_data.m_historyNum >= HISTORY_MAX )
  {
    DeleteOldestHistory();
  }

  m_data.m_principalId[m_data.m_historyNum] = principalId;
  m_data.m_date[m_data.m_historyNum] = date;
  m_data.m_historyNum++;
}


/**
* @brief o^L[Ⴂ{bNXf[^oɓo^Ă邩
*
* @param date o^
* @param serialId o^vVpID
*
* @return ɑ݂Ȃtrueԋp
*/
bool CecHistory::IsExistCecHistory( const u32 principalId , const nn::fnd::DateTimeParameters& date )
{
  for( u32 i = 0; i < m_data.m_historyNum; i++ )
  {
    if( m_data.m_principalId[i] == principalId )
  	{//tr
  		bool isExists = true;
  		isExists &= ( m_data.m_date[i].year == date.year );
  		isExists &= ( m_data.m_date[i].month == date.month );
  		isExists &= ( m_data.m_date[i].day == date.day );
  		isExists &= ( m_data.m_date[i].week == date.week );
  		isExists &= ( m_data.m_date[i].hour == date.hour );
  		isExists &= ( m_data.m_date[i].minute == date.minute );
  		isExists &= ( m_data.m_date[i].second == date.second );
  		isExists &= ( m_data.m_date[i].milliSecond == date.milliSecond );

    	if( isExists )
    	{
      		return true;
    	}
    }
  }
  return false;
}


/**
 * @brief łÂBOSSA[JCu擾폜
 *
 * @param none
 *
 * @return none
 */
void CecHistory::DeleteOldestHistory( void )
{
  if( m_data.m_historyNum >= HISTORY_MAX )
  {
    u32 num = HISTORY_MAX-1;

    for( u32 i = 0; i < num; i++ )
    {
      	m_data.m_principalId[i] = m_data.m_principalId[i+1];
    	m_data.m_date[i] = m_data.m_date[i+1];
    }

    m_data.m_historyNum = num;
  }
}


//=============================================================================
//@brief SaveDataInterface
//=============================================================================
/**
 *  @brief    ǂݍ񂾃f[^Zbg֐
  * @param    pData   擪̃|C^
 */
void CecHistory::SetData(void* data)
{
  gfl::std::MemCopy(data, &m_data, this->GetDataSize() );
}

/**
 *  @brief    f[^̐擪|C^𓾂֐
  * @return   擪̃|C^
 */
void* CecHistory::GetData(void)
{
  return reinterpret_cast<void*>(&m_data);
}

/**
 *  @brief    f[^TCY
 *  @retval   oCg
 */
size_t CecHistory::GetDataSize(void)
{
  return sizeof( CoreData );
}

/**
 * @brief Z[uf[^̃NA
 * @param heap@NAɎgpe|q[v
 */
void CecHistory::Clear( gfl::heap::HeapBase * /*heap*/ )
{
  gfl::std::MemClear( &m_data, this->GetDataSize() );
}


GFL_NAMESPACE_END(savedata)
