//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		FieldUniqueSequence3DDungeon.h
 *	@brief  3D_W
 *	@author	Masayuki Onoue
 *	@date		2012.08.29
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#if !defined( __FIELDUNIQUESEQUENCE3DDUNGEON_H__ )
#define __FIELDUNIQUESEQUENCE3DDUNGEON_H__



// gflib
#include <gflib.h>

#include "trainer/trid_def.h"

// field
#include "field/Fieldmap.h"
#include "field/FieldUniqueSequence.h"
#include "system/ShaderModel.h"
#include "gimmick_mdl_setup.h"

namespace field {

class FieldUniqueSequence3DDungeon : public FieldUniqueSequence
{
  GFL_FORBID_COPY_AND_ASSIGN(FieldUniqueSequence3DDungeon);
private:
  //-------------------------------------
  ///	ZbgAbvV[PX`
  //=====================================
  enum{
    SETUP_ENEMY,
    SETUP_END_SEQ,
  };

  //-------------------------------------
  ///	ZbgAbvV[PX`
  //=====================================
  enum{
    FIELD_ENEMY_MAX = 5,
  };

  //-------------------------------------
  ///	Gf[^
  //=====================================
  typedef struct {
    u16 event_flag;
  } ENEMY_DATA;
 
  //-------------------------------------
  ///	M~bN[N
  //=====================================
  typedef struct {
    s32 hoge;
  } DUNGEON_WORK;
 
private:
  Fieldmap* mp_fieldmap;          ///< tB[h}bv
  void* mp_work_buffer;           ///< M~bN[Nobt@[
  u32   m_assigne_id;             ///< ATCID
  bool  m_is_first_setup;         ///< ZbgAbvtO
  gfl::heap::HeapBase* mp_heap;   ///< q[v
  ENEMY_DATA* mp_enemy_list;      ///< GXg
  u32   m_enemy_cnt;              ///< G̐
  EventWork* mp_evwork;           ///< Cxg[N
  s32 m_setup_seq;                ///< ZbgAbvV[PX
  mmodel::Manager* mp_modelman;    ///< 샂f}l[W

public:
  //----------------------------------------------------------------------------
  /**
   *  @brief   RXgN^
   *
   *  @param   pFieldmap  tB[h}bv(̃NXŕێ܂)
   */
  //-----------------------------------------------------------------------------
  FieldUniqueSequence3DDungeon(Fieldmap* pFieldmap);

  //----------------------------------------------------------------------------
  /**
   *  @brief   fXgN^
   */
  //-----------------------------------------------------------------------------
  virtual ~FieldUniqueSequence3DDungeon(){};

  //----------------------------------------------------------------------------
  /**
   *  @brief   SETUP̍ŌɌĂ΂֐
   */
  //-----------------------------------------------------------------------------
  virtual b32 SetupLast(void);
 
  //----------------------------------------------------------------------------
  /**
   *  @brief   READY̍Ō1񂾂Ă΂֐
   */
  //-----------------------------------------------------------------------------
  virtual void ReadyLastOnce(void);

  //----------------------------------------------------------------------------
  /**
   *  @brief   UPDATE̍ŏɌĂ΂֐
   */
  //-----------------------------------------------------------------------------
  virtual void UpdateFirst(void){};

  //----------------------------------------------------------------------------
  /**
   *  @brief   UPDATE̍ŌɌĂ΂֐
   */
  //-----------------------------------------------------------------------------
  virtual void UpdateLast(void);

  //----------------------------------------------------------------------------
  /**
   *  @brief   CALCULATĚɌĂ΂֐
   */
  //-----------------------------------------------------------------------------
  virtual void CalculateAfter(void){};

  //----------------------------------------------------------------------------
  /**
   *  @brief   FREE̍ŏ1񂾂Ă΂֐
   */
  //-----------------------------------------------------------------------------
  virtual void FreeFirstOnce(void);

  /* -------------------------------------------------------------------------*/
  /**
   * @brief G̐
   */
  /* -------------------------------------------------------------------------*/
  void InitEnemyCnt(void);

  /* -------------------------------------------------------------------------*/
  /**
   * @brief G[N𐶐
   */
  /* -------------------------------------------------------------------------*/
  void CreateEnemyWork(void);

  /* -------------------------------------------------------------------------*/
  /**
   * @brief G̕\Ԃ擾
   *  
   * @param enemy_index GCfbNX
   *
   * @return TRUE̎\
   */
  /* -------------------------------------------------------------------------*/
  bool IsVanish(u16 enemy_index );

  /* -------------------------------------------------------------------------*/
  /**
   * @brief G̏񒊑I
   */
  /* -------------------------------------------------------------------------*/
  void SetupFirstEnemy( void );

  /* -------------------------------------------------------------------------*/
  /**
   * @brief z_ɕёւ
   *
   * @param p_array z
   * @param size    zTCY
   * @param seed    V[h
   */
  /* -------------------------------------------------------------------------*/
  void ShuffleIndexList( u16 *p_array , u16 size,u32 seed );

  /* -------------------------------------------------------------------------*/
  /**
   * @brief G̕\Ԃݒ肷
   *
   * @param index       GCfbNX
   * @param is_vanish   ojbVtO
   */
  /* -------------------------------------------------------------------------*/
  void SetEnemyVanish( u16 index ,bool is_vanish );

  /* -------------------------------------------------------------------------*/
  /**
   * @brief Gf擾
   *
   * @param index GCfbNX
   *
   * @return 擾샂f
   */
  /* -------------------------------------------------------------------------*/
  mmodel::MoveModel* GetEnemyModel( u16 index );

};

} // namespace field


#endif		// __FIELDUNIQUESEQUENCE3DDUNGEON_H__

