//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		FieldUniqueSequence3DDungeon.cpp
 *	@brief  3D_W
 *	@author	Masayuki Onoue
 *	@date		2012.08.29
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

// gflib
#include <gflib.h>

// field
#include "field/Fieldmap.h"
#include "field/FieldGimmickWorkAccessor.h"
#include "field/FieldUniqueSequence3DDungeon.h"
#include "sound/sound.h"

namespace field {

#include "arc/arc_def.h"                   // ARCID_*
#include "gimmick_mdl_setup.h"
#include "FieldUniqueSequence3DDungeon.cdat"

//----------------------------------------------------------------------------
/**
 *  @brief   RXgN^
 *
 *  @param   pFieldmap  tB[h}bv(̃NXŕێ܂)
 */
//-----------------------------------------------------------------------------
FieldUniqueSequence3DDungeon::FieldUniqueSequence3DDungeon(Fieldmap* pFieldmap)
  : FieldUniqueSequence(pFieldmap),
  mp_work_buffer(NULL),
  m_assigne_id(GIMMICK_ID_DUNGEONOF3D),
  m_is_first_setup(false),
  m_setup_seq(SETUP_ENEMY)
{
  mp_fieldmap = pFieldmap;
  mp_heap = mp_fieldmap->GetHeapField();
  mp_modelman = mp_fieldmap->GetMoveModelManager();

}

//----------------------------------------------------------------------------
/**
 *  @brief   SETUP̍ŌɌĂ΂֐
 */
//-----------------------------------------------------------------------------
b32 FieldUniqueSequence3DDungeon::SetupLast(void)
{
  // V[PX̃ZbgAbv
  switch(m_setup_seq)
  {
  case SETUP_ENEMY:
    {
      // ATC̏ԂmFď
      gamesystem::GameData* p_gdata = m_pFieldmap->GetGameManager()->GetGameData();
      b32 is_assigned = GimmickWorkAccessor::IsAssigned( p_gdata, m_assigne_id);
      // ATCs
      GimmickWorkAccessor::SecondAssign( p_gdata, m_assigne_id);
      // obt@[ۑ
      mp_work_buffer = GimmickWorkAccessor::GetWork( p_gdata );

      // ATCĂȂԂ̏ꍇ̓f[^
      if( is_assigned == FALSE )
      {
        DUNGEON_WORK gmk_work;
        gfl::std::MemClear( &gmk_work, sizeof(DUNGEON_WORK) );
        BufferAccessorType<DUNGEON_WORK>::SetValue(mp_work_buffer,0,gmk_work);
        // ZbgAbvtOݒ
        m_is_first_setup= true;
      }

      // G̐[N𐶐
      CreateEnemyWork();

      m_setup_seq = SETUP_END_SEQ;
    }
    break;
  }
  
  return true;
}
 
//----------------------------------------------------------------------------
/**
 *  @brief   READY̍Ō1񂾂Ă΂֐
 */
//-----------------------------------------------------------------------------
void FieldUniqueSequence3DDungeon::ReadyLastOnce(void)
{
}

/* -------------------------------------------------------------------------*/
/**
 * @brief Abvf[g
 */
/* -------------------------------------------------------------------------*/
void FieldUniqueSequence3DDungeon::UpdateLast(void)
{
}

/* -------------------------------------------------------------------------*/
/**
 * @brief 
 */
/* -------------------------------------------------------------------------*/
void FieldUniqueSequence3DDungeon::FreeFirstOnce(void)
{
  GFL_SAFE_DELETE_ARRAY( mp_enemy_list );
}

/* -------------------------------------------------------------------------*/
/**
 * @brief G̐
 */
/* -------------------------------------------------------------------------*/
void FieldUniqueSequence3DDungeon::InitEnemyCnt(void)
{
  u32 mdl_no = 0;
  m_enemy_cnt = 0;
  mmodel::MoveModel* p_model;
  // 샂f}l[W炷ׂĂ̓G擾
  while( (p_model = static_cast<mmodel::MoveModel*>(mp_modelman->SearchUseWork(&mdl_no))) != NULL ){
    if( p_model->GetOBJCode() == mmodel::ENEMY3D )
    {
      m_enemy_cnt++;
    }
  }
}

/* -------------------------------------------------------------------------*/
/**
 * @brief G[N𐶐
 */
/* -------------------------------------------------------------------------*/
void FieldUniqueSequence3DDungeon::CreateEnemyWork(void)
{
  u32 index = 0;
  u32 mdl_no = 0;
  mmodel::MoveModel* p_model;

  // G̐JEg
  InitEnemyCnt();

  // G[N𐶐
  mp_enemy_list = GFL_NEW_ARRAY( mp_heap ) ENEMY_DATA[ m_enemy_cnt ];

  // 샂f̏擾
  while( (p_model = static_cast<mmodel::MoveModel*>(mp_modelman->SearchUseWork(&mdl_no))) != NULL )
  {
    // \R[h`FbN
    if( p_model->GetOBJCode() == mmodel::ENEMY3D )
    {
      // f[^̃NA
      gfl::std::MemClear( &mp_enemy_list[index], sizeof(ENEMY_DATA) );
      index++;
    }
  }

  // ͓Gzu
  if( m_is_first_setup != false )
  {
    SetupFirstEnemy();
  }

  for( int i=0; i < m_enemy_cnt; i++ )
  {
    ONOUE_PRINT("%d = %u\n",i,IsVanish(i));
  }

  ONOUE_PRINT("m_enemy_cnt = %d\n",m_enemy_cnt);
}

/* -------------------------------------------------------------------------*/
/**
 * @brief G̕\Ԃ擾
 *  
 * @param enemy_index GCfbNX
 *
 * @return TRUE̎\
 */
/* -------------------------------------------------------------------------*/
bool FieldUniqueSequence3DDungeon::IsVanish(u16 enemy_index )
{
  mmodel::MoveModel* p_model = GetEnemyModel(enemy_index);
  if( p_model->CheckStatusBit( mmodel::MoveModelBase::STABIT_VANISH ) != false )
  {
    return true;
  }

  return false;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief G̏񒊑I
 */
/* -------------------------------------------------------------------------*/
void FieldUniqueSequence3DDungeon::SetupFirstEnemy( void )
{
  // S̓G\
  for( int i = 0; i < m_enemy_cnt; i++ )
  {
    SetEnemyVanish(i,true);
  }
  
  // CfbNXXg쐬
  u16* p_index_list = GFL_NEW_LOW_ARRAY( mp_heap ) u16[ m_enemy_cnt ];
  for( int i = 0; i < m_enemy_cnt; i++ )
  {
    p_index_list[i] = i;
  }

  // _ȃV[hŔzёւ
  u32 seed = xy_system::GflUse::GetPublicRand();
  ShuffleIndexList( p_index_list ,m_enemy_cnt ,seed );
 
  // _Ɏw萔̓G̃ojbVOFFɂ
  for( int i = 0; i < FIELD_ENEMY_MAX; i++ )
  {
    // GCfbNX擾
    u16 enemy_index = p_index_list[i];
    // \tOݒ肷
    SetEnemyVanish(enemy_index,false);
  }

  // [N
  GFL_SAFE_DELETE_ARRAY( p_index_list );
}

/* -------------------------------------------------------------------------*/
/**
 * @brief z_ɕёւ
 *
 * @param p_array z
 * @param size    zTCY
 * @param seed    V[h
 */
/* -------------------------------------------------------------------------*/
void FieldUniqueSequence3DDungeon::ShuffleIndexList( u16 *p_array , u16 size,u32 seed )
{
  // ŒV[hŗ쐬
  gfl::math::Random rand;
  rand.Initialize( seed );

  int i;
  u32 tmp;
  for( i = 0; i < size ;i++ )
  {
    u32 rnd = rand.Next( size );
    tmp = p_array[rnd];
    p_array[rnd] = p_array[i];
    p_array[i] = tmp;
  }
}

/* -------------------------------------------------------------------------*/
/**
 * @brief G̕\Ԃݒ肷
 *
 * @param index       GCfbNX
 * @param is_vanish   ojbVtO
 */
/* -------------------------------------------------------------------------*/
void FieldUniqueSequence3DDungeon::SetEnemyVanish( u16 index ,bool is_vanish )
{
  mmodel::MoveModel* p_model = GetEnemyModel(index);
  if( is_vanish == true )
  {
    p_model->OnStatusBit( mmodel::MoveModelBase::STABIT_VANISH );
    p_model->OnStatusBit( mmodel::MoveModelBase::STABIT_FELLOW_HIT_NON );
    // p_model->GetDrawModel()->SetShadow( false );
  }
  else
  {
    p_model->OffStatusBit( mmodel::MoveModelBase::STABIT_VANISH );
    p_model->OffStatusBit( mmodel::MoveModelBase::STABIT_FELLOW_HIT_NON );
    // p_model->GetDrawModel()->SetShadow( true );
  }
}

/* -------------------------------------------------------------------------*/
/**
 * @brief Gf擾
 *
 * @param index GCfbNX
 *
 * @return 擾샂f
 */
/* -------------------------------------------------------------------------*/
mmodel::MoveModel* FieldUniqueSequence3DDungeon::GetEnemyModel( u16 index )
{
  u32 obj_id = sc_3d_dungeon_enemy_list[index];
  mmodel::MoveModel* p_model = mp_modelman->SearchObjIdWork(obj_id);
  GFL_ASSERT(p_model);
  return  p_model;
}


} // namespace field

