//======================================================================
/**
 * @file  btlv_timer.h
 * @brief og` UI Q[W֌W
 * @author  ariizumi
 * @data  10/11/15
 */
//======================================================================
#if !defined( __BTLV_UI_TIMER_H__ )
#define __BTLV_UI_TIMER_H__

#pragma once

#include "btlv_ui_base.h"

namespace btl
{
enum
{
  //LAjp
  TIMER_ANM_NUM_BASE,

  TIMER_ANM_NUM_GAME_M1,
  TIMER_ANM_NUM_GAME_M2,
  TIMER_ANM_NUM_GAME_S1,
  TIMER_ANM_NUM_GAME_S2,

  TIMER_ANM_NUM_COM_1,
  TIMER_ANM_NUM_COM_2,
  TIMER_ANM_NUM_COM_3,

  TIMER_ANM_NUM_DUMMY,
  
  TIMER_ANM_MAX
};

class BtlvUiTimer:public BtlvUiWork
{
public:
  BtlvUiTimer(BattleViewSystem* core,BtlvUi* ui);
  virtual ~BtlvUiTimer(){};
  

  //
  virtual void Create(void);
  //
  virtual void Delete(void);
  //XV
  virtual void Update(void);

  //Layout擾
  virtual BtlvLayout* GetLayout( const int type  = 0);

  void SetTime( int gameTime , int com_time );
  void DispTimer( BTLV_TIMER_TYPE type , bool isReset );
  void HideTimer( BTLV_TIMER_TYPE type );
  bool IsFinish( BTLV_TIMER_TYPE type );


private:

  BtlvLayout mLytTimer;
  
  const BTL_POKEPARAM *mBpp;
  const BTL_LEVELUP_INFO *mLvupInfo;
  
  class Timer
  {
  public:
    void SetTimeLimit( int time );
    int GetLeastTime(void);
    bool IsFinish(void);
    void StartTimer(void);
  private:
    int mTimeLimit;
    nn::os::Tick mStartTick;

  };
  
  Timer mGameTimer;
  Timer mCommandTimer;
  bool mIsDispGameTimer;
  bool mIsDispCommandTimer;
};


}//namespace btl





#endif // __BTLV_UI_TIMER_H__
