//======================================================================
/**
 * @file  btlv_timer.cpp
 * @brief og` UI Q[W֌W
 * @author  ariizumi
 * @data  10/11/15
 */
//======================================================================
#include <gflib.h>


#include "btlv_ui.h"
#include "btlv_ui_timer.h"

namespace btl
{

BtlvUiTimer::BtlvUiTimer(BattleViewSystem* core,BtlvUi* ui)
  :BtlvUiWork( core,ui )
{
}

//
void BtlvUiTimer::Create(void)
{
  gfl::fs::ArcFile* arc = mBtlvUi->GetResArc();

  gfl::grp::g2d::LytArcIndex anmIdxTbl[] = 
  {
    LYTRES_BTLV_LYT_BTL_TIME_NUM_ANIME_BCLAN,
  };

  const BTLV_LAYOUT_PARAM timerParam =
  {
    gfl::fs::ArcFile::ARCID_NULL,
    LYTRES_BTLV_LYT_BTL_TIME_BCLYT ,
    {
      gfl::math::VEC3(0,0,0),   // pos
      gfl::math::VEC2(1,1),     // scale
      gfl::math::VEC3(0,0,0),   // rotate
      1,                        // priority
      BTLV_LAYOUT_FRONT,
    },
    GFL_NELEMS(anmIdxTbl),
    anmIdxTbl,
    TIMER_ANM_MAX
  };

  mLytTimer.CreateLayout( arc , &timerParam , mBtlvCore );
  //mLytTimer.GetLytWk()->SetPriority(64);
  mLytTimer.SetVisible(true);

  mLytTimer.GetLytWk()->UnBindAnime( TIMER_ANM_NUM_BASE );

  mLytTimer.SetShareAnime( TIMER_ANM_NUM_GAME_M1 , LYTRES_BTLV_LYT_BTL_TIME_NUM_ANIME_BCLAN , 7 , PANENAME_BTL_TIME_GROUP_NUM_SHARE );

  
  mLytTimer.SetVisiblePane( PANENAME_BTL_TIME_PANE_GAME_BASE , false );
  mLytTimer.SetVisiblePane( PANENAME_BTL_TIME_PANE_COMMAND_BASE , false );
  
  mIsDispGameTimer = false;
  mIsDispCommandTimer = false;
/*  
  SetTime( 5900,300 );
  DispTimer( BTLV_TIMER_TYPE_GAME_TIME , true );
  DispTimer( BTLV_TIMER_TYPE_COMMAND_TIME , true );
*/
}

//
void BtlvUiTimer::Delete(void)
{
  mLytTimer.DeleteLayout(mBtlvCore);
}

//XV
void BtlvUiTimer::Update(void)
{
  if( mIsDispGameTimer )
  {
    int time = mGameTimer.GetLeastTime();
    if( time < 0 )
    {
      time = 0;
    }
    
    const int min = time/60;
    const int sec = time%60;
    
    //
    if( min > 0 )
    {
      mLytTimer.SetAnimeFrame( TIMER_ANM_NUM_GAME_M1 , min%10 );
      if( min < 10 )
      {
        mLytTimer.SetAnimeFrame( TIMER_ANM_NUM_GAME_M2 , 10 );
      }
      else
      {
        mLytTimer.SetAnimeFrame( TIMER_ANM_NUM_GAME_M2 , min/10 );
      }
      mLytTimer.SetVisiblePane( PANENAME_BTL_TIME_PANE_GAME_COLON , true );
    }
    else
    {
      mLytTimer.SetVisiblePane( PANENAME_BTL_TIME_PANE_GAME_COLON , false );
      mLytTimer.SetAnimeFrame( TIMER_ANM_NUM_GAME_M1 , 10 );
      mLytTimer.SetAnimeFrame( TIMER_ANM_NUM_GAME_M2 , 10 );
    }

    //b
    mLytTimer.SetAnimeFrame( TIMER_ANM_NUM_GAME_S1 , sec%10 );
    if( min < 10 )
    {
      mLytTimer.SetAnimeFrame( TIMER_ANM_NUM_GAME_S2 , 10 );
    }
    else
    {
      mLytTimer.SetAnimeFrame( TIMER_ANM_NUM_GAME_S2 , sec/10 );
    }
  }

  if( mIsDispCommandTimer )
  {
    int time = mCommandTimer.GetLeastTime();
    if( time < 0 )
    {
      time = 0;
    }
    
    if( time < 100 )
    {
      mLytTimer.SetAnimeFrame( TIMER_ANM_NUM_COM_3 , 10 );
    }
    else
    {
      mLytTimer.SetAnimeFrame( TIMER_ANM_NUM_COM_3 , time/100 );
    }
    if( time < 10 )
    {
      mLytTimer.SetAnimeFrame( TIMER_ANM_NUM_COM_2 , 10 );
    }
    else
    {
      mLytTimer.SetAnimeFrame( TIMER_ANM_NUM_COM_2 , (time%100)/10 );
    }
    mLytTimer.SetAnimeFrame( TIMER_ANM_NUM_COM_1 , time%10 );
  }
}

//Layout擾
BtlvLayout* BtlvUiTimer::GetLayout( const int type )
{
  GFL_UNUSED(type);
  
  return &mLytTimer;
}

void BtlvUiTimer::SetTime( int gameTime , int com_time )
{
  mGameTimer.SetTimeLimit(gameTime);
  mCommandTimer.SetTimeLimit(com_time);
  //ꉞĂł
  mGameTimer.StartTimer();
  mCommandTimer.StartTimer();

}

void BtlvUiTimer::DispTimer( BTLV_TIMER_TYPE type , bool isReset )
{
  if( type == BTLV_TIMER_TYPE_GAME_TIME )
  {
    mLytTimer.SetVisiblePane( PANENAME_BTL_TIME_PANE_GAME_BASE , true );
    if( isReset )
    {
      mGameTimer.StartTimer();
    }
    mIsDispGameTimer = true;
  }
  else
  {
    mLytTimer.SetVisiblePane( PANENAME_BTL_TIME_PANE_COMMAND_BASE , true );
    if( isReset )
    {
      mCommandTimer.StartTimer();
    }
    mIsDispCommandTimer = true;
  }
}

void BtlvUiTimer::HideTimer( BTLV_TIMER_TYPE type )
{
  if( type == BTLV_TIMER_TYPE_GAME_TIME )
  {
    mLytTimer.SetVisiblePane( PANENAME_BTL_TIME_PANE_GAME_BASE , false );
    mIsDispGameTimer = false;
  }
  else
  {
    mLytTimer.SetVisiblePane( PANENAME_BTL_TIME_PANE_COMMAND_BASE , false );
    mIsDispCommandTimer = false;
  }
}

bool BtlvUiTimer::IsFinish( BTLV_TIMER_TYPE type )
{
  if( type == BTLV_TIMER_TYPE_GAME_TIME )
  {
    return mGameTimer.IsFinish();
  }
  else
  {
    return mCommandTimer.IsFinish();
  }
  
}


//^C}[NX

void BtlvUiTimer::Timer::SetTimeLimit(int time)
{
  mTimeLimit = time;
}

void BtlvUiTimer::Timer::StartTimer(void)
{
  mStartTick = nn::os::Tick::GetSystemCurrent();
}

int BtlvUiTimer::Timer::GetLeastTime(void)
{
  nn::os::Tick nowTick = nn::os::Tick::GetSystemCurrent();
  
  s64 nowTime = (nowTick-mStartTick).ToSeconds();
  
  return mTimeLimit-nowTime;
}

bool BtlvUiTimer::Timer::IsFinish(void)
{
  if( GetLeastTime() < 0 )
  {
    return true;
  }
  return false;
}

}//namespace btl

