//============================================================================================
/**
 * @brief ԊO̐ڑssNX
 *        {NXł́AWireless̐ؒfEĊJ͒SȂB
 *        OEWireless̐ؒfEĊJsKvB
 */
//============================================================================================
#include <netapp/ir/IrConnectRunner.h>
#include <net/net_define.h>

namespace netapp {
namespace ir {



//--------------------------------------------------------------------------------------------
/**
 * @brief  RXgN^
 *
 * @param[in/out]  heap           gpq[v
 * @param[in/out]  devHeap        gpfoCXq[v
 * @param[in]      reciveDataSize Mf[^pɊmۂobt@TCY
 */
//--------------------------------------------------------------------------------------------
IrConnectRunner::IrConnectRunner( gfl::heap::HeapBase* heap, gfl::heap::HeapBase* devHeap, u32 reciveDataSize ) :
    m_step(E_STEP_NONE),
    m_reciveSize(reciveDataSize),
    m_sendDataBuffer(NULL),
    m_sendSize(0),
    m_heap(heap),
    m_devHeap(devHeap),
    m_listener(NULL)
{
  m_reciveDataBuffer = GflHeapAllocMemoryAlign( heap, reciveDataSize, 8 );

  GFL_ASSERT( m_reciveDataBuffer );
  GFL_ASSERT( heap );
  GFL_ASSERT( devHeap );
}

//------------------------------------------------------------------
/**
 * @brief   fXgN^
 */
//------------------------------------------------------------------
IrConnectRunner::~IrConnectRunner()
{
  if( m_reciveDataBuffer != NULL )
  {
    GflHeapFreeMemory( m_reciveDataBuffer );
    m_reciveDataBuffer = NULL;
  }
  GFL_SAFE_DELETE( m_netGame     );
  GFL_SAFE_DELETE( m_autoConnect );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   ԊO̐ڑJni񓯊j
 *
 * @note    ؒfIrConnectListener::OnIrConnectSuccess()R[
 * @note    Mf[^|C^́AM̊Ԃ͏ɕێĂƁB
 *
 * @param   timingId  ڑɎgp鎯ʃR[hB\ȌdȂ悤l邱
 * @param   data      Mf[^ւ̃|C^
 * @param   dataSize  Mf[^TCY
 *
 * @return  sꂽ̂łtrueԋp
 */
//--------------------------------------------------------------------------------------------
bool IrConnectRunner::StartConnecting( u32 timingId, void* data, u32 dataSize )
{
  if( m_step != E_STEP_NONE ){
    return false;
  }
  m_step     = E_SET_CONNECT_START;
  m_initNum  = 0;
  m_timingId = timingId;
  m_sendDataBuffer = data;
  m_sendSize       = dataSize;

  GFL_SAFE_DELETE( m_autoConnect );
  m_autoConnect = GFL_NEW(m_heap) netapp::ir::AutoIrConnect( m_heap,m_devHeap,D_CONNECT_MAX,netapp::AutoMatch::AUTOMATCH_BOTH );

  GFL_ASSERT( m_sendDataBuffer );
  GFL_ASSERT( m_autoConnect    );

  GFL_PRINT( "IrConnectRunner::StartConnecting()\n" );

  return true;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   ԊO̐ڑؒfi񓯊j
 *
 * @note    ؒfIrConnectListener::OnIrDisconnectSuccess()R[
 *
 * @param   none
 *
 * @return  sꂽ̂łtrueԋp
 */
//--------------------------------------------------------------------------------------------
bool IrConnectRunner::StartDisconnecting( void )
{
  if( m_step >= E_SET_DICONNECT_SHUTDOWN ){
    return false;   // ɐؒf
  }
  m_step = E_SET_DICONNECT_SHUTDOWN;

  if( m_autoConnect != NULL )
  {
    if( m_autoConnect->isConnect() ){
      m_autoConnect->Finalize();
    }
  }
  GFL_SAFE_DELETE( m_netGame );

  GFL_PRINT( "IrConnectRunner::StartDisconnecting()\n" );

  return true;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   ԊOŃf[^đM
 *
 * @attention {֐͂łɃRlNVmĂKv
 *
 * @param   data      Mf[^ւ̃|C^
 * @param   dataSize  Mf[^TCY
 *
 * @return  sꂽ̂łtrueԋp
 */
//--------------------------------------------------------------------------------------------
bool IrConnectRunner::StartSending( void* data, u32 dataSize )
{
  if( (m_step != E_SET_CONNECTING) || (m_netGame==NULL) ){
    return false;   //ڑ҂Ȃ
  }
  m_sendDataBuffer = data;
  m_sendSize       = dataSize;
  m_step           = E_SET_SENDING;

  return true;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   ԊOCxgXi̓o^
 *
 * @param   listener o^ʒm惊Xiւ̃|C^BNULLwŉ
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void IrConnectRunner::SetListener( IrConnectListener* listener )
{
  m_listener = listener;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   XV
 *
 * @param   none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void IrConnectRunner::Update( void )
{
  switch( m_step )
  {
    case  E_STEP_NONE:                    //!< ʐM
      break;

    case  E_SET_CONNECT_START:            //!< ڑJn
      DoConnectingStart();
      break;

    case  E_SET_CONNECT_NETGAME_CREATE:   //!< NetGame쐬
      DoCreatingNetGame();
      break;

    case  E_SET_CONNECT_NETGAME_INIT:     //!< NetGame
      DoInitializingNetGame();
      break;

    case  E_SET_CONNECT_WAIT_TIMING:      //!< IsTimingEndI҂
      DoSyncTiming();
      break;

    case  E_SET_SENDING:                  //!< M
      DoSending();
      break;

    case  E_SET_RECIVING:                 //!< M
      DoReciving();
      break;

    case  E_SET_CONNECTING:               //!< ʐMҋ@
      // Ȃ
      break;

    case  E_SET_DICONNECT_SHUTDOWN:       //!< I
      DoDisonnecting();
      break;
  }
}


//--------------------------------------------------------------------------------------------
/**
 * @brief ڑJn
 */
//--------------------------------------------------------------------------------------------
void IrConnectRunner::DoConnectingStart( void )
{
  if( m_autoConnect->isConnect() )
  {
    gflnet::p2p::GameInitialize  initialize;

    initialize.max         = D_CONNECT_MAX;
    initialize.pHeapSystem = m_heap;
    m_netGame = GFL_NEW(m_heap) gflnet::p2p::NetGame( &initialize, NULL );

    GFL_PRINT( "DoConnectingStart() success\n" );
    m_step = E_SET_CONNECT_NETGAME_CREATE;
  }
}


//--------------------------------------------------------------------------------------------
/**
 * @brief NetGame
 */
//--------------------------------------------------------------------------------------------
void IrConnectRunner::DoCreatingNetGame( void )
{
  m_netGame->Initialize();

  GFL_PRINT( "DoCreatingNetGame() success\n" );

  m_step = E_SET_CONNECT_NETGAME_INIT;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief NetGamȅI҂
 */
//--------------------------------------------------------------------------------------------
void IrConnectRunner::DoInitializingNetGame( void )
{
  if( m_netGame->IsInitialize() )
  {
    m_netGame->TimingStart(m_timingId);

    GFL_PRINT( "DoInitializingNetGame() success\n" );

    m_step = E_SET_CONNECT_WAIT_TIMING;
  }
}


//--------------------------------------------------------------------------------------------
/**
 * @brief NetGame̓҂
 */
//--------------------------------------------------------------------------------------------
void IrConnectRunner::DoSyncTiming( void )
{
  if( m_netGame->IsTimingEnd(m_timingId) )
  {
    if( m_listener != NULL ){
      m_listener->OnIrConnectSuccess();
    }

    GFL_PRINT( "DoSyncTiming() success\n" );

    m_step = E_SET_SENDING;
  }
}


//--------------------------------------------------------------------------------------------
/**
 * @brief f[^M
 */
//--------------------------------------------------------------------------------------------
void IrConnectRunner::DoSending( void )
{
  if( (m_sendDataBuffer==NULL) || m_netGame->SendData( (char*)m_sendDataBuffer, m_sendSize ) )
  {
    GFL_PRINT( "DoSending() success\n" );

    m_step = E_SET_RECIVING;
  }
}


//--------------------------------------------------------------------------------------------
/**
 * @brief f[^M
 */
//--------------------------------------------------------------------------------------------
void IrConnectRunner::DoReciving( void )
{
  u16 size;

  if( m_netGame->RecvData( 0, static_cast<char*>(m_reciveDataBuffer), static_cast<int>(m_reciveSize), &size ) )
  {
    GFL_PRINT( "DoReciving() success\n" );

    if( m_listener != NULL ){
      m_listener->OnIrReciveData( m_reciveDataBuffer, size );
    }
    m_step = E_SET_CONNECTING;
  }
}


//--------------------------------------------------------------------------------------------
/**
 * @brief ؒf
 */
//--------------------------------------------------------------------------------------------
void IrConnectRunner::DoDisonnecting( void )
{
  if( (m_autoConnect==NULL) || !m_autoConnect->isConnect() || m_autoConnect->IsFinalized() )
  {
    GFL_SAFE_DELETE( m_autoConnect );

    if( m_listener != NULL ){
      m_listener->OnIrDisconnectSuccess();
    }

    m_step = E_STEP_NONE;
  }
}





} // namespace ir
} // namespace netapp
