//============================================================================================
/**
 * @file IrConnectRunnner.h
 */
//============================================================================================
#ifndef __XY_PROJECT_IR_CONNECT_RUNNNER_H__
#define __XY_PROJECT_IR_CONNECT_RUNNNER_H__


#include <gflib.h>
#include <gflnet.h>
#include <gamesystem/GameProc.h>
#include <gamesystem/GameManager.h>
#include <nex/gflnet_NexManager.h>
#include <netapp/ir/IrConnectListener.h>

namespace netapp {

/**
 * @namespace netapp::ir
 * @brief     ԊOڑEؒfvZX֘A
 */
namespace ir {

  class AutoIrConnect;

  //--------------------------------------------------------------------------------------------
  /**
  * @brief ԊOڑssNX
  *
  * @attention  {NXł́AWireless̐ؒfEĊJ͒SȂB
  *             OEWireless̐ؒfEĊJsKvB
  */
  //--------------------------------------------------------------------------------------------
  class IrConnectRunner
  {
    public:
      //--------------------------------------------------------------------------------------------
      /**
       * @brief  RXgN^
       *
       * @param[in/out]  heap           gpq[v
       * @param[in/out]  devHeap        gpfoCXq[v
       * @param[in]      reciveDataSize Mf[^pɊmۂobt@TCY
       */
      //--------------------------------------------------------------------------------------------
      IrConnectRunner( gfl::heap::HeapBase* heap, gfl::heap::HeapBase* devHeap, u32 reciveDataSize );

      //--------------------------------------------------------------------------------------------
      /**
       * @brief   fXgN^
       */
      //--------------------------------------------------------------------------------------------
      virtual  ~IrConnectRunner();

    public:
      //--------------------------------------------------------------------------------------------
      /**
       * @brief   ԊO̐ڑJni񓯊j
       *
       * @note    ؒfIrConnectListener::OnIrConnectSuccess()R[
       *
       * @param   timingId ڑɎgp鎯ʃR[hB\ȌdȂ悤l邱
       *
       * @return  sꂽ̂łtrueԋp
       */
      //--------------------------------------------------------------------------------------------
      bool StartConnecting( u32 timingId, void* data, u32 dataSize );

      //--------------------------------------------------------------------------------------------
      /**
       * @brief   ԊO̐ڑؒfi񓯊j
       *
       * @note    ؒfIrConnectListener::OnIrDisconnectSuccess()R[
       *
       * @param   none
       *
       * @return  sꂽ̂łtrueԋp
       */
      //--------------------------------------------------------------------------------------------
      bool StartDisconnecting( void );

      //--------------------------------------------------------------------------------------------
      /**
       * @brief   ԊOŃf[^đM
       *
       * @attention {֐͂łɃRlNVmĂKv
       *
       * @param   data      Mf[^ւ̃|C^
       * @param   dataSize  Mf[^TCY
       *
       * @return  sꂽ̂łtrueԋp
       */
      //--------------------------------------------------------------------------------------------
      bool StartSending( void* data, u32 dataSize );

      //--------------------------------------------------------------------------------------------
      /**
       * @brief   ԊOCxgXi̓o^
       *
       * @param   listener o^ʒm惊Xiւ̃|C^BNULLwŉ
       *
       * @return  none
       */
      //--------------------------------------------------------------------------------------------
      void SetListener( IrConnectListener* listener );

      //--------------------------------------------------------------------------------------------
      /**
       * @brief   XV
       *
       * @param   none
       *
       * @return  none
       */
      //--------------------------------------------------------------------------------------------
      void Update( void );

    private:
      void DoConnectingStart( void );
      void DoCreatingNetGame( void );
      void DoInitializingNetGame( void );
      void DoSyncTiming( void );
      void DoSending( void );
      void DoReciving( void );
      void DoDisonnecting( void );

    private:
      static const u32            D_CONNECT_MAX    = 2;         //!< őڑl


      typedef enum
      {
        E_STEP_NONE,                    //!< ʐM
        //
        E_SET_CONNECT_START,            //!< ڑJn
        E_SET_CONNECT_NETGAME_CREATE,   //!< NetGame쐬
        E_SET_CONNECT_NETGAME_INIT,     //!< NetGame
        E_SET_CONNECT_WAIT_TIMING,      //!< IsTimingEndI҂
        //
        E_SET_SENDING,                  //!< M
        E_SET_RECIVING,                 //!< M
        //
        E_SET_CONNECTING,               //!< ʐMҋ@
        //
        E_SET_DICONNECT_SHUTDOWN,       //!< I
      }E_PROC_STEP;

    private:
      E_PROC_STEP                 m_step;                       //!<
      u32                         m_counter;                    //!<
      u32                         m_errorCode;                  //!<
      //
      u32                         m_initNum;                    //!< ڑςݐl
      u32                         m_timingId;                   //!< pʃR[h
      //
      void*                       m_reciveDataBuffer;           //!< Mf[^i[̈
      u32                         m_reciveSize;                 //!< Mf[^TCY
      //
      void*                       m_sendDataBuffer;             //!< Mf[^i[̈
      u32                         m_sendSize;                   //!< Mf[^TCY
      //
      gfl::heap::HeapBase*        m_heap;                       //!< q[v
      gfl::heap::HeapBase*        m_devHeap;                    //!< foCXq[v
      netapp::ir::AutoIrConnect*  m_autoConnect;                //!< ԊOڑǗNX
      gflnet::p2p::NetGame*       m_netGame;                    //!< lbgQ[
      IrConnectListener*          m_listener;                   //!< ʒmCxgXi
  };


} // namespace ir
} // namespace netapp

#endif // __XY_PROJECT_IR_CONNECT_RUNNNER_H__

