//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_zukan_Model.cpp
 *	@brief  }ӗp|Pf
 *	@author	Toru=Nagihashi
 *	@date		2012.08.29
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "app_zukan_Model.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(zukan)

//-----------------------------------------------------------------------
// Ej
//-----------------------------------------------------------------------
/**
 * @brief RXgN^
 *
 * @param heap VXeq[v
 * @param file_read_manager ǂݍ݃VXe
 */
Model::Model( app::util::Heap * heap, gfl::fs::FileReadManager* file_read_manager )
{
  m_poke_model = GFL_NEW( heap->GetSystemHeap() ) app::tool::BoxPokeModel( heap->GetSystemHeap(), heap->GetSystemAllocator(), heap->GetDeviceAllocator(), file_read_manager );
  m_poke_model->SetListener( this );
}

/**
 * @brief fXgN^
 */
Model::~Model()
{
  GFL_SAFE_DELETE( m_poke_model );
}
/**
 * @brief 
 *
 * @return trueŏ falseŏ
 */
bool Model::Initialize( void )
{
  return true;
}
/**
 * @brief j
 *
 * @return trueŔj falseŔj
 */
bool Model::Finalize( void )
{
  return m_poke_model->Delete();
}
//-----------------------------------------------------------------------
// XV
//-----------------------------------------------------------------------
/**
 * @brief XV
 */
void Model::Update( void )
{ 
  if( m_poke_model->GetPokeModel() )
  {
    m_poke_model->GetPokeModel()->SetPosition( &m_translate );
  }
  m_poke_model->Update();
  
  m_poke_model->UpdateSystem();
  m_poke_model->UpdateAnime();
}

//-----------------------------------------------------------------------
// 
//-----------------------------------------------------------------------
/**
 * @brief f\XV
 *
 * @param core_param  RAp
 * @param scene V[
 */
void Model::RequestChangePokeModel( const poke_tool::SimpleParam &param, gfl::grp::g3d::Scene * scene )
{
  m_poke_model->Create( param, scene );
}

/**
 * @brief f
 */
void Model::CancelPokeModel( void )
{
  m_poke_model->SetVisible( false );
}

/**
 * @brief ʒuݒ
 *
 * @param vec ׂƂ
 */
void Model::SetPosition( const gfl::math::VEC3 & vec )
{
  m_translate = vec;
  if( m_poke_model->GetPokeModel() )
  {
    m_poke_model->GetPokeModel()->SetPosition( &m_translate );
  }
}

//-----------------------------------------------------------------------
// app::tool::BoxPokeModelListener̎
//-----------------------------------------------------------------------
/**
 * @brief |Pfǂݍ݌̃Xi
 *
 * @param poke_model  |Pf
 */
void Model::OnFinishLoadPokeModel( poke_tool::PokeModel *poke_model )
{
  
  static const gfl::math::VEC3 POKE_MODEL_POSITION( -160.0f, -40.0f, -401.0f );

  poke_model->Create();

  poke_model->SetAdjustScaleType( poke_tool::POKE_ADJUST_STATUS );

  proj::motion::BaseMotionCharacter* motion_data = poke_model->GetMotionData();
  if( motion_data ) {
    motion_data->SetAttributeOn( proj::motion::Motion::M_ATTR_NO_IK );
  }

  this->SetPosition( POKE_MODEL_POSITION );
  poke_model->ChangeAnime( poke_tool::MODEL_ANIME_KW_WAIT );  // 퓬[VAőҋ@
  poke_model->PlayAnime();
  
  const f32 MODEL_COMMON_SCALE = 1.34f;
  poke_model->SetScale( MODEL_COMMON_SCALE );

  xy_system::PokemonShaderModel* shader_model = poke_model->GetShaderModel();
  shader_model->SetLightVec( gfl::math::VEC4(1, 0, 0, 1) );
  shader_model->SetLightColor( gfl::math::VEC4(1, 1, 1, 1) );

  poke_model->SetFpsIs30(false);
}


GFL_NAMESPACE_END(zukan)
GFL_NAMESPACE_END(app)
