//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *  GAME FREAK inc.
 *
 *  @file   Intro2d.cpp
 *  @brief  Cg
 *  @author Junya Ikuta
 *  @date   2012.08.27
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#if 0



#endif

#include "Intro2d.h"
#include "message/msg_intro.h"

namespace app {
namespace intro {


const gfl::grp::g2d::LytWkSetUp INTRO_2D_LAYOUT_WORK_SETUP =
{
  gfl::math::VEC3(0,0,0),   // pos
  gfl::math::VEC2(1,1),     // scale
  gfl::math::VEC3(0,0,0),   // rotate
  1,                        // priority
};

const u32 INTRO_2D_STR_ID_TABLE[ 15 ] = {
  msg_introduction_01,
  msg_introduction_02,
  msg_introduction_03,
  msg_introduction_04,
  msg_introduction_05,
  msg_introduction_06,
  msg_introduction_07,
  msg_introduction_08,
  msg_introduction_09,
  msg_introduction_10,
  msg_introduction_11,
  msg_introduction_12,
  msg_introduction_13,
  msg_introduction_14,
  msg_introduction_15
};
s32 INTRO_2D_WINDOW_CLOSE_TIMER(60);


const u32 INTRO_2D_STRBUF_LENGTH(256);

//-----------------------------------------------------------------------------
/**
 *          NX̑O錾
 */
//-----------------------------------------------------------------------------



//-----------------------------------------------------------------------------
/**
 *          NX錾
 */
//-----------------------------------------------------------------------------

// @brief      RXgN^
Intro2d::Intro2d(
  app::util::Heap*         util_heap,
  gfl::heap::HeapBase*     heap_memory,
  gfl::heap::HeapBase*     device_memory,
  gfl::heap::NwAllocator*  heap_allocator,
  gfl::heap::NwAllocator*  device_allocator,
  gamesystem::GameManager* game_manager
) :
  m_util_heap( util_heap ),
  m_heap_memory( heap_memory ),
  m_device_memory( device_memory ),
  m_heap_allocator( heap_allocator ),
  m_device_allocator( device_allocator ),
  m_game_manager( game_manager ),
  m_state( STATE_NONE ),
  m_Phase( PHASE_NONE ),
  m_ResultYesNoWindow( app::tool::YesNoMenu::UPDATE_NONE ),
  m_pMessageWindow( NULL ),
  m_pLayOutSystem( NULL ),
  m_pStrbuf( NULL ),
  m_pYesNoMenu( NULL ),
  m_pMsgData( NULL ),
  m_pWordSet( NULL )  
{
  gfl::grp::GraphicsSystem* graphics_system = m_game_manager->GetGraphicsSystem();
  gfl::ui::DeviceManager* device_manager = m_game_manager->GetUiDeviceManager();

  // CAEgVXe쐬
  // CAEgVXe
  {
    gfl::grp::g2d::LytSysSetUp lytSysSetUp;
    lytSysSetUp.lyt_resource_max = 128;
    lytSysSetUp.lyt_wk_max = 32;

    m_pLayOutSystem = GFL_NEW( m_heap_memory ) gfl::grp::g2d::LytSys(
     &lytSysSetUp,
     m_heap_allocator,
     m_device_allocator
    );
  }
#if 1
  // bZ[WEChE̍쐬
  m_pMessageWindow = GFL_NEW( m_heap_memory ) app::tool::TalkCursorWindow();
  m_pMessageWindow->Initialize( 
    m_heap_memory, 
    m_device_allocator, 
    graphics_system, 
    m_pLayOutSystem, 
    device_manager 
  );
  m_pMessageWindow->Setup( m_device_memory, gamesystem::FRAMEMODE_30 );
  m_pMessageWindow->SetWindowPos( app::tool::TalkCursorWindow::WINDOW_POSITION_DOWN );
  m_pMessageWindow->SetAutoDrawFlag( false );
#endif
  // YES NOI
  m_pYesNoMenu = GFL_NEW( m_heap_memory ) app::tool::YesNoMenu(
    m_heap_memory,
    m_device_memory,
    m_game_manager->GetUiDeviceManager(),
    graphics_system,
    m_pLayOutSystem,
    &INTRO_2D_LAYOUT_WORK_SETUP,
    gamesystem::FRAMEMODE_30,
    gfl::grp::DISPLAY_UPPER
  );
  m_pYesNoMenu->SetVisible( false );
  m_pYesNoMenu->SetAutoDrawFlag( false );

  // bZ[Wǂݍ
  m_pMsgData = GFL_NEW( m_heap_memory ) gfl::str::MsgData( ARCID_MESSAGE, GARC_message_intro_DAT, m_heap_memory, gfl::str::MsgData::LOAD_FULL );
  m_pWordSet = GFL_NEW( m_heap_memory ) WordSet( m_heap_memory );

    
  // bZ[Wopobt@
  m_pStrbuf = GFL_NEW( m_heap_memory ) gfl::str::StrBuf ( INTRO_2D_STRBUF_LENGTH , m_heap_memory );

  m_state = STATE_CREATING;

}

// @brief      fXgN^
Intro2d::~Intro2d()
{
  // 񓯊̏I҂
  GFL_ASSERT( m_pMessageWindow == NULL );

  GFL_SAFE_DELETE( m_pWordSet );
  GFL_SAFE_DELETE( m_pMsgData );
  
  GFL_SAFE_DELETE( m_pStrbuf );
  GFL_SAFE_DELETE( m_pMessageWindow );
  GFL_SAFE_DELETE( m_pYesNoMenu );

  GFL_SAFE_DELETE( m_pLayOutSystem );
}

// @brief      vZ
void Intro2d::Update(void)
{
  switch( m_state )
  {
    case STATE_CREATING:
    {
      updateCreating();
      break;
    }

    case STATE_PLAYING:
    {
      UpdatePhase();
      break;
    }

    case STATE_DESTROYING:
    { 
      if( m_pMessageWindow->End() )
      {
         GFL_SAFE_DELETE( m_pMessageWindow );
         GFL_SAFE_DELETE( m_pLayOutSystem );

         m_state = STATE_NONE;
      }
      break;
    }
  }

}

// @brief      `
void Intro2d::Draw(void)
{
  switch( m_state )
  {
    case STATE_CREATING:
    {

      break;
    }

    case STATE_PLAYING:
    {
      gfl::grp::GraphicsSystem* graphics_system = m_game_manager->GetGraphicsSystem();

      gfl::grp::RenderTarget* upperFrameBuffer = graphics_system->GetCurrentFrameBuffer(gfl::grp::DISPLAY_UPPER);
      gfl::grp::RenderTarget* rightFrameBuffer = graphics_system->GetCurrentFrameBuffer(gfl::grp::DISPLAY_UPPER_RIGHT);
      gfl::grp::RenderTarget* lowerFrameBuffer = graphics_system->GetCurrentFrameBuffer(gfl::grp::DISPLAY_LOWER);

      m_pLayOutSystem->DrawAll( graphics_system, gfl::grp::DISPLAY_UPPER, upperFrameBuffer, rightFrameBuffer );
      m_pLayOutSystem->DrawAll( graphics_system, gfl::grp::DISPLAY_LOWER, lowerFrameBuffer );

      m_pMessageWindow->Draw( graphics_system, gfl::grp::DISPLAY_UPPER );

      break;
    }
  }
}
void Intro2d::Message( MESSAGE msg )
{
  switch( msg )
  {
    // YES NOʂ̕`JnAXVĂ΂ȂH
    case MESSAGE_SHOW_YES_NO:
    {
      m_Phase = PHASE_YES_NO;
      m_ResultYesNoWindow = app::tool::YesNoMenu::UPDATE_NONE;

      m_pYesNoMenu->Start();
      m_pYesNoMenu->SetVisible( true );
      m_pYesNoMenu->SetAutoDrawFlag( true );
      break;      
    }

    case MESSAGE_CLOSE_YES_NO:
    {
      m_Phase = PHASE_NONE;
      m_ResultYesNoWindow = app::tool::YesNoMenu::UPDATE_NONE;

      m_pYesNoMenu->SetVisible( false );
      m_pYesNoMenu->SetAutoDrawFlag( false );
      break;
    }

    case MESSAGE_DELETE:
    {
      GFL_SAFE_DELETE( m_pWordSet );
      GFL_SAFE_DELETE( m_pMsgData );

      GFL_SAFE_DELETE( m_pStrbuf );
      GFL_SAFE_DELETE( m_pYesNoMenu );

      if( m_pMessageWindow )
      {
        if( m_pMessageWindow->End() )
        {
          GFL_SAFE_DELETE( m_pMessageWindow );
          GFL_SAFE_DELETE( m_pLayOutSystem );

          m_state = STATE_NONE;
        }
        else
          m_state = STATE_DESTROYING;
      }
      else
      {
        GFL_SAFE_DELETE( m_pLayOutSystem );
        m_state = STATE_NONE;
      }

      break;
    }

    case MESSAGE_SETUP_INTRODUCTION_01: OpenMessageWindowTimer( INTRO_2D_STR_ID_TABLE[0], INTRO_2D_WINDOW_CLOSE_TIMER ); break;
    case MESSAGE_SETUP_INTRODUCTION_02: OpenMessageWindowTimer( INTRO_2D_STR_ID_TABLE[1] ); break;
    case MESSAGE_SETUP_INTRODUCTION_03: OpenMessageWindowTimer( INTRO_2D_STR_ID_TABLE[2] ); break;
    case MESSAGE_SETUP_INTRODUCTION_04: OpenMessageWindowTimer( INTRO_2D_STR_ID_TABLE[3], INTRO_2D_WINDOW_CLOSE_TIMER ); break;
    case MESSAGE_SETUP_INTRODUCTION_05: OpenMessageWindowTimer( INTRO_2D_STR_ID_TABLE[4], INTRO_2D_WINDOW_CLOSE_TIMER ); break;
    case MESSAGE_SETUP_INTRODUCTION_06: OpenMessageWindowTimer( INTRO_2D_STR_ID_TABLE[5] ); break;
    case MESSAGE_SETUP_INTRODUCTION_07: OpenMessageWindowTimer( INTRO_2D_STR_ID_TABLE[6] ); break;
    case MESSAGE_SETUP_INTRODUCTION_08: OpenMessageWindowTimer( INTRO_2D_STR_ID_TABLE[7] ); break;
    case MESSAGE_SETUP_INTRODUCTION_09: OpenMessageWindowTimer( INTRO_2D_STR_ID_TABLE[8] ); break;
    case MESSAGE_SETUP_INTRODUCTION_10: OpenMessageWindowTimer( INTRO_2D_STR_ID_TABLE[9] ); break;
    case MESSAGE_SETUP_INTRODUCTION_11: OpenMessageWindowTimer( INTRO_2D_STR_ID_TABLE[10] ); break;
    case MESSAGE_SETUP_INTRODUCTION_12: OpenMessageWindowTimer( INTRO_2D_STR_ID_TABLE[11] ); break;
    case MESSAGE_SETUP_INTRODUCTION_13: OpenMessageWindowTimer( INTRO_2D_STR_ID_TABLE[12], INTRO_2D_WINDOW_CLOSE_TIMER ); break;
    case MESSAGE_SETUP_INTRODUCTION_14: OpenMessageWindowTimer( INTRO_2D_STR_ID_TABLE[13], INTRO_2D_WINDOW_CLOSE_TIMER ); break;
    case MESSAGE_SETUP_INTRODUCTION_15: OpenMessageWindowTimer( INTRO_2D_STR_ID_TABLE[14], INTRO_2D_WINDOW_CLOSE_TIMER ); break;

    case MESSAGE_CLOSE_MESSAGE:
    {
      m_pMessageWindow->CloseMsgWin();
      break;
    }

    case MESSAGE_SETUP_PLAYER_NAME:
    {
      // [hZbgɓo^Ēu
      gamesystem::GameManager* game_manager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
      gamesystem::GameData*    game_data    = game_manager->GetGameData();
      savedata::MyStatus*      my_status    = game_data->GetPlayerStatus();

      m_pWordSet->RegisterPlayerName( 0, my_status );
    }

  }
}

void Intro2d::UpdateFrame( f32 frame )
{

}

// window\ĂȂ͂ǂȂH
s16 Intro2d::GetYesNoWindowResult( void ) const
{
  return m_ResultYesNoWindow;
}

// private
void Intro2d::updateCreating(void)
{
  if( m_pMessageWindow->Update() != app::tool::TalkWindow::WIN_STATUS_SETUP_WAIT)
    m_state = STATE_PLAYING;

}

void Intro2d::OpenMessageWindowTimer( u32 strId, s32 frame )
{
  if( m_pMessageWindow->GetStatus() != app::tool::TalkWindow::WIN_STATUS_SUSPEND )
    m_pMessageWindow->CloseMsgWin();

  m_pMsgData->GetString( strId, *m_pStrbuf );
  gfl::math::VEC3 pos( 0.0f, 0.0f, 0.0f );

  app::tool::TalkCursorWindow::CallMsgWinParams param = {
    m_pStrbuf,
    savedata::Config::MSG_NORMAL,
    WIN_TYPE_TALK,
    app::tool::TalkWindowGra::WIN_COLLAR_TYPE_DEFAULT,
    false,
    &pos,
    frame
  };

  m_pMessageWindow->CallMsgWin( param );
  m_pMessageWindow->SetAutoDrawFlag( true );
}

void Intro2d::OpenMessageWindow( u32 strId )
{
  m_pMsgData->GetString( strId, *m_pStrbuf );
  m_pMessageWindow->CallMsgWin( m_pStrbuf, WIN_TYPE_TALK, app::tool::TalkWindowGra::WIN_COLLAR_TYPE_DEFAULT);
  m_pMessageWindow->SetAutoDrawFlag( true );
}

void Intro2d::UpdatePhase(void)
{
  switch( m_Phase )
  {
    case PHASE_YES_NO:
    {
      m_ResultYesNoWindow = m_pYesNoMenu->Update();
//      m_pMessageWindow->Update();
      break;
    }
  }

  m_pMessageWindow->Update();
  m_pLayOutSystem->UpdateAll();
}

} // namespace intro
} // namespace app
