//============================================================================================
/**
 * @file    gts_menucursor.cpp
 * @brief   TRADELISTpʃJ[\
 * @author  Akito Mori
 * @date    12.07.03
 *
 * namespace  app::tradelist::
 *
 */
//============================================================================================
#include "arc/arc_def.h"

#include "tradelist_menucursor.h"

namespace netapp {
  namespace tradelist {


  //=============================================================================================
  /**
   * @brief ėpJ[\
   */
  //=============================================================================================
  app::tool::MenuCursor *TradelistMenuCursor::Initialize( app::util::Heap * heap, gfl::grp::g2d::LytSys* lytSys )
  {
    app::tool::MenuCursor *pMenuCursor = GFL_NEW( heap->pHeap ) app::tool::MenuCursor( lytSys );
    pMenuCursor->LoadLayoutResource( heap->pHeap, heap->pDevHeapAllocator );
  
    //GetLayoutWorkSetup( gfl::grp::DisplayType disp );
  
    static const gfl::grp::g2d::LytWkSetUp setup = {
      gfl::math::VEC3(0,-290,0),  // pos
      gfl::math::VEC2(1,1),       // scale
      gfl::math::VEC3(0,0,0),     // rotate
      1,                          // priority
    };
    pMenuCursor->CreateLayoutWork( &setup, false );
    pMenuCursor->StartAnime( gamesystem::FRAMEMODE_60 );
  
    return pMenuCursor;
  }
  
  //=============================================================================================
  /**
   * @brief ėpJ[\
   */
  //=============================================================================================
  void TradelistMenuCursor::Finalize( app::tool::MenuCursor * pMenuCursor )
  {
    pMenuCursor->DeleteLayoutWork();
    pMenuCursor->ReleaseLayoutResource();
    GFL_DELETE pMenuCursor;
  }
  
  } //tradelist
} // netapp
