#if !defined( __PSS_IR_MENU_MAIN_H__ )
#define __PSS_IR_MENU_MAIN_H__
//============================================================================================
/**
 * @file    pss_ir_menu_main.h
 * @brief   PSSԊOMʗpC
 * @author  Hisanao Suzuki
 *
 * namespace  app::pss::pss_ir_menu::
 */
//============================================================================================
#pragma  once

#include <app/util/app_util_heap.h>
#include <app/pss/pss_ir_menu/pss_ir_menu.h>
#include "PssBattleReceiveUIListener.h"
#include "pss_ir_menu_graphic.h"


namespace app {
namespace pss {
namespace pss_ir_menu {


class MainSystem : public PssIrMenuUIListener
{
public:



private:
  // CV[PX`
  typedef enum {
    MAINSEQ_INIT = 0,
    MAINSEQ_MAIN,
    MAINSEQ_FADE_OUT,
    MAINSEQ_RELEASE,
    MAINSEQ_END,
    MAINSEQ_MAX = MAINSEQ_END
  }MAIN_SEQUENCE;

public:
  //------------------------------------------------------------------
  /**
   * @brief    RXgN^
   *
   * @param    prm    Oݒp[^
   */
  //------------------------------------------------------------------
  MainSystem( APP_PARAM * prm );

  //------------------------------------------------------------------
  /**
   * @brief    fXgN^
   */
  //------------------------------------------------------------------
  ~MainSystem(void);

  //------------------------------------------------------------------
  /**
   * @brief    Abvf[g
   *
   * @param    none
   *
   * @retval  "true = "
   * @retval  "false = ȊO"
   */
  //------------------------------------------------------------------
  bool Update(void);

  //------------------------------------------------------------------
  /**
   * @brief    `揈
   *
   * @param    none
   *
   * @return  none
   */
  //------------------------------------------------------------------
  void Draw(void);

public:

  //------------------------------------------------------------------
  /**
  * @brief  ߂Iʒm
  */
  //------------------------------------------------------------------
  virtual void OnSelectedReturn( void );

private:
  //------------------------------------------------------------------
  /**
   * @brief    Tu[N쐬
   *
   * @param    none
   *
   * @return  none
   */
  //------------------------------------------------------------------
  void CreateSubWork(void);

  //------------------------------------------------------------------
  /**
   * @brief    Tu[N폜
   *
   * @param    none
   *
   * @return  none
   */
  //------------------------------------------------------------------
  void DeleteSubWork(void);

  //------------------------------------------------------------------
  /**
   * @brief    tF[hCZbg
   *
   * @param    none
   *
   * @return  none
   */
  //------------------------------------------------------------------
  void SetFadeIn( void );

  //------------------------------------------------------------------
  /**
   * @brief    tF[hAEgZbg
   *
   * @param    none
   *
   * @return  none
   */
  //------------------------------------------------------------------
  void SetFadeOut( void );

  //------------------------------------------------------------------
  /**
   * @brief CV[PXݒ
   *
   * @param  seq   ؂ւΏۂƂȂV[PX
   */
  //------------------------------------------------------------------
  void SetMainSequence( MAIN_SEQUENCE seq );

  //------------------------------------------------------------------
  /**
   * @brief ʂ̏Iݒ
   *
   * @param  none
   */
  //------------------------------------------------------------------
  void SetFinish( void );

  //------------------------------------------------------------------
  /**
   * @brief   V[PXʃvZX
   *
   * @param   none
   *
   * @retval  "true  = "
   * @retval  "false = ȊO"
   */
  //------------------------------------------------------------------
  bool DoSequenceProcess( void );

private:
  // V[PX
  void MainSeq_Init(void);
  void MainSeq_Release(void);
  void MainSeq_Fade( MAIN_SEQUENCE nextSeq );
  void MainSeq_Main(void);

private:
  static const u32 APP_HEAP_SIZE    = 0x10000;   //!< Avp[Jq[vTCY
  static const u32 DEVICE_HEAP_SIZE = 0x70000;   //!< Avp[JfoCXq[vTCY

private:
  GraphicWork*                     m_view;       //!< `Ǘ
  app::util::Heap                  m_heap;       //!< q[vǗ
  APP_PARAM*                       m_appParam;   //!< Np[^
  MAIN_SEQUENCE                    m_sequence;   //!< JgV[PX
  bool                             m_isFinish;   //!< ItO
};

}    // pss_ir_menu
}    // pss
}    // app
#endif // __PSS_IR_MENU_MAIN_H__
