//============================================================================================
/**
 * @file		pss_ir_menu_main.cpp
 * @brief		C
 * @author  Hisanao Suzuki
 * @date    12.2.22
 *
 * namespace	app::pss::pss_ir_menu::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================
#include "pss_ir_menu_main.h"
#include "gamesystem/ForcedReturnManager.h"
#include "sound/sound.h"
#include <arc/fieldmenu_pss_tex.gaix>

namespace app {
namespace pss {
namespace pss_ir_menu {



//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		prm		Oݒp[^
 */
//--------------------------------------------------------------------------------------------
MainSystem::MainSystem( APP_PARAM * prm )
{
  m_view       = NULL;
  m_isFinish   = false;

  m_appParam = prm;

  SetMainSequence( MAINSEQ_INIT );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
MainSystem::~MainSystem(void)
{
  DeleteSubWork();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 *
 * @param		none
 *
 * @retval	"true = "
 * @retval	"false = ȊO"
 */
//--------------------------------------------------------------------------------------------
bool MainSystem::Update(void)
{
  bool isRunning = DoSequenceProcess();

  if( m_view != NULL ){
    m_view->Update();
  }
  return isRunning;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   V[PXʃvZX
 *
 * @param   none
 *
 * @retval  "true  = "
 * @retval  "false = ȊO"
 */
//--------------------------------------------------------------------------------------------
bool MainSystem::DoSequenceProcess( void )
{
  switch( m_sequence )
  {
    case  MAINSEQ_INIT:
      MainSeq_Init();
      break;

    case  MAINSEQ_MAIN:
      MainSeq_Main();
      break;

    case  MAINSEQ_FADE_OUT:
      MainSeq_Fade( MAINSEQ_RELEASE );
      break;

    case  MAINSEQ_RELEASE:
      MainSeq_Release();
    case  MAINSEQ_END:
      return false;
  }
  return true;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		`揈
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::Draw(void)
{
	if( m_view != NULL ){
	  m_view->Draw();
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Tu[N쐬
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::CreateSubWork(void)
{
  m_heap.Create( gfl::heap::Manager::GetHeapByHeapId( HEAPID_FIELDMENU ),
                 gfl::heap::Manager::GetHeapByHeapId( HEAPID_FIELDMENU_DEV ),
                 HEAPID_PSS_BATTLE_RECEIVE_APP, APP_HEAP_SIZE, HEAPID_PSS_BATTLE_RECEIVE_DEVICE, DEVICE_HEAP_SIZE );

  m_view = GFL_NEW( m_heap.pHeap ) GraphicWork( &m_heap, m_appParam->m_layout,
                                                                m_appParam->m_messageData,
                                                                m_appParam->m_wordset);

  m_view->SetPssIrMenuUIListener( this );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Tu[N폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::DeleteSubWork(void)
{
  if( m_view != NULL )
  {
    GFL_DELETE	m_view;
    m_view = NULL;
  }

  m_heap.Delete();
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		tF[hCZbg
 *
 * @param		next		tF[h̃V[PX
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::SetFadeIn( void )
{
  gfl::grp::Fade_Reset( gfl::grp::Fade::DISP_LOWER );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		tF[hAEgZbg
 *
 * @param		next		tF[h̃V[PX
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::SetFadeOut( void )
{
  gfl::grp::Fade_RequestOut( gfl::grp::Fade::DISP_LOWER, gfl::grp::Fade::OUTTYPE_CAPTURE, 1, false );
}



//--------------------------------------------------------------------------------------------
/**
 * @brief		CV[PXF
 *
 * @param		none
 *
 * @return	̃V[PX
 *
 *	`FMAINSEQ_INIT
 */
//--------------------------------------------------------------------------------------------
void MainSystem::MainSeq_Init(void)
{
	CreateSubWork();
  m_view->Update();

	SetFadeIn();
  SetMainSequence( MAINSEQ_MAIN );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CV[PXF
 *
 * @param		none
 *
 * @return	̃V[PX
 *
 *	`FMAINSEQ_RELEASE
 */
//--------------------------------------------------------------------------------------------
void MainSystem::MainSeq_Release(void)
{
	DeleteSubWork();

	SetMainSequence( MAINSEQ_END );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CV[PXFtF[h҂
 *
 * @param		nextSeq tF[hɑJڂV[PX
 *
 * @return	void
 */
//--------------------------------------------------------------------------------------------
void MainSystem::MainSeq_Fade( MAIN_SEQUENCE nextSeq )
{
	if( gfl::grp::Fade_IsEnd() )
	{
	  SetMainSequence( nextSeq );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CV[PXFC
 *
 * @param		none
 *
 * @return	̃V[PX
 *
 *	`FMAINSEQ_MAIN
 */
//--------------------------------------------------------------------------------------------
void MainSystem::MainSeq_Main(void)
{
  m_view->SetInputEnabled( m_view->IsAnimeEnd() );

  if( m_isFinish ||
      GFL_SINGLETON_INSTANCE(gamesystem::ForcedReturnManager)->IsReturn(gamesystem::ForcedReturnManager::FORCERETURN_APP) )
  {
    SetFadeOut();
    SetMainSequence( MAINSEQ_FADE_OUT );
  }
}


//------------------------------------------------------------------
/**
 * @brief CV[PXݒ
 *
 * @param  seq   ؂ւΏۂƂȂV[PX
 */
//------------------------------------------------------------------
void MainSystem::SetMainSequence( MAIN_SEQUENCE seq )
{
  m_sequence = seq;
}


//------------------------------------------------------------------
/**
 * @brief ʂ̏Iݒ
 *
 * @param  none
 */
//------------------------------------------------------------------
void MainSystem::SetFinish( void )
{
  m_isFinish = true;

  // ȍ~̓͂֎~
  m_view->SetInputEnabled( false );
}


//------------------------------------------------------------------
/**
* @brief  ߂Iʒm
*/
//------------------------------------------------------------------
void MainSystem::OnSelectedReturn( void )
{
  //xy_snd::PlaySE( PSS_BATTLE_RECEIVE_SE_CANCEL );
  SetFinish();
}


}		// pss_ir_menu
}		// pss
}		// app

