#if !defined( __PSS_IR_MENU_GRAPHIC_H__ )
#define __PSS_IR_MENU_GRAPHIC_H__
//============================================================================================
/**
 * @file		pss_ir_menu_graphic.h
 * @brief		OtBbN֘A
 * @author	Hisanao Suzuki
 * @date		12.2.22
 *
 * namespace	app::pss::pss_ir_menu::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================
#pragma	once

#include <app/util/app_util_heap.h>
#include <app/util/app_util_2d.h>
#include <app/tool/app_tool_LytTexReplaceSystem.h>
#include <app/ui/UIView.h>
#include <app/pss/view/PssRuleDetailWindow.h>
#include <app/ui/UIInputListener.h>
#include "PssBattleReceiveUIListener.h"

namespace app {
namespace pss {
namespace pss_ir_menu {


class GraphicWork : public app::ui::UIView, public app::ui::UIInputListener
{
public:

  // BoundBoxXgIndexID
  typedef enum
  {
    E_PAGE_TOP,             // ΐݒTOPy[W
    //
    E_PAGE_MAX
  }ENUM_PAGE_ID;

private:
  static const u32 BUTTON_NUM = 1;

  typedef enum {
    PSS_IR_MENU_LAYOUT_ID_UPPER,
    PSS_IR_MENU_LAYOUT_ID_LOWER,
    PSS_IR_MENU_LAYOUT_ID_MAX,
  }LAYOUT_ID;

  // ΐ\݉ʗpAjID
  typedef enum {
    E_ANMID_BTL_RECEIVE_DISP_BACK = 0,
    E_ANMID_BTL_RECEIVE_DISP_YESNO,
    E_ANMID_BTL_RECEIVE_DISP_MESSAGE,
    //
    E_ANMID_MAX,
  }E_ANIME_ID;

  /**
  * @brief LAj
  */
  typedef enum
  {
    E_SHARE_ANIME_BUTTON_RELEASE = E_ANMID_MAX,
    E_SHARE_ANIME_BUTTON_CANCEL  = (E_SHARE_ANIME_BUTTON_RELEASE+BUTTON_NUM),
    E_SHARE_ANIME_BUTTON_TOUCH   = (E_SHARE_ANIME_BUTTON_CANCEL+BUTTON_NUM),
    E_SHARE_ANIME_BUTTON_ACTIVE  = (E_SHARE_ANIME_BUTTON_TOUCH+BUTTON_NUM),
    E_SHARE_ANIME_BUTTON_PASSIVE = (E_SHARE_ANIME_BUTTON_ACTIVE+BUTTON_NUM),
    E_SHARE_ANMID_MAX            = (E_SHARE_ANIME_BUTTON_PASSIVE+BUTTON_NUM),
  }SHARE_ANIME_ID;


public:
  //--------------------------------------------------------------------------------------------
  /**
   * @brief		RXgN^
   *
   * @param		heap	      q[v
   * @param   messageData p郁bZ[Wf[^BNULLȂVK쐬
   * @param   wordset     p郏[hZbgBNULLȂVK쐬
   */
  //--------------------------------------------------------------------------------------------
  GraphicWork( app::util::Heap * heap, gfl::grp::g2d::LytSys *layout,
               gfl::str::MsgData *messageData, WordSet *wordset );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief		fXgN^
   */
  //--------------------------------------------------------------------------------------------
  virtual ~GraphicWork(void);

public:
  //--------------------------------------------------------------------------------------------
  /**
   * @brief		Abvf[g
   *
   * @param		none
   *
   * @return	none
   */
  //--------------------------------------------------------------------------------------------
  virtual void Update(void);

  //--------------------------------------------------------------------------------------------
  /**
   * @brief		`
   *
   * @param		none
   *
   * @return	none
   */
  //--------------------------------------------------------------------------------------------
  virtual void Draw(void);

public:
  //--------------------------------------------------------------------------------------------
  /**
   * @brief   Aj[V̊Jn
   *
   * @param animeId Aj[VID
   */
  //--------------------------------------------------------------------------------------------
  void StartAnime( u32 animeId );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   Aj[V̊Jn
   *
   * @param startAnimeId JnAj[VID
   * @param nextAnimeId  ɃZbgĂAj[VID
   */
  //--------------------------------------------------------------------------------------------
  void StartAnime( u32 startAnimeId, u32 nextAnimeId );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   yCAj[V̏I
   *
   * @return  AjIȂtrueAAj[VȂfalseԋp
   */
  //--------------------------------------------------------------------------------------------
  bool IsAnimeEnd( void );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   UICxgXi̓o^
   *
   * @param   listener ʒmthCxgXi
   *
   * @return  none
   */
  //--------------------------------------------------------------------------------------------
  void SetPssIrMenuUIListener( PssIrMenuUIListener* listener );


public:
  // yCANVʒmpXi
  virtual bool OnLayoutPaneEvent( const u32 painId );
  // L[͒ʒmpXi
  virtual bool OnKeyAction( gfl::ui::Button* pKey, gfl::ui::VectorDevice* pStick);

private:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		2D֘A
	 *
	 * @param		heap		q[v
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void intialize2D( app::util::Heap * heap, gfl::grp::g2d::LytSys *layout, gfl::str::MsgData *messageData, WordSet *wordset );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief   eLXgyC̏
	 *
	 * @param   none
	 *
	 * @return  none
	 */
	//--------------------------------------------------------------------------------------------
	void InitTextPain( void );

private:
	app::pss::pss_rule_select::PssRuleSettingInfo* m_setting;
  PssIrMenuUIListener*                           m_uiListener;
  //
  u32                                            m_nextAnime;
  u32                                            m_currentAnime;
  bool                                           m_isSetAnime;
  //
  static const gfl::grp::g2d::LytArcIndex        LowerAnmIndex[E_ANMID_MAX];
  static const gfl::grp::g2d::LytArcIndex        UpperAnmIndex[2];
  static const app::ui::ButtonInfo               BUTTON_PANE_LIST[BUTTON_NUM];

};


}	// pss_ir_menu
}	// pss
}	// app
#endif // __PSS_IR_MENU_GRAPHIC_H__
