//============================================================================================
/**
 * @file		pss_ir_menu_graphic.cpp
 * @brief		OtBbN֘A
 * @author  Hisanao Suzuki
 * @date    12.2.22
 *
 * namespace	app::pss::pss_ir_menu::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================
#include "pss_ir_menu_main.h"
#include "pss_ir_menu_graphic.h"
#include "field/subscreen/fieldmenu_snd_def.h"
#include "app/pss/pss_battle_receive/pss_battle_receive_res_pane.h"
#include "app/pss/pss_battle_receive/pss_battle_receive_res.h"
#include <arc/fieldmenu_pss_tex.gaix>
#include <arc/arc_def.h>
#include <message/msg_pss_message.h>
#include <message/message.gaix>

namespace app {
namespace pss {
namespace pss_ir_menu {


//============================================================================================
//  萔`
//============================================================================================
//{^j[pyC
const app::ui::ButtonInfo GraphicWork::BUTTON_PANE_LIST[GraphicWork::BUTTON_NUM] =
{
  // vtB[
  {
    PANENAME_CONNECT_LOWER_PANE_RETURN_ICON,    // picture_pane
    PANENAME_CONNECT_LOWER_PANE_RETURN_BOUND,   // bound_pane
    E_SHARE_ANIME_BUTTON_TOUCH+0,               // hold_anime_index
    E_SHARE_ANIME_BUTTON_CANCEL+0,              // release_anime_index
    E_SHARE_ANIME_BUTTON_RELEASE+0,             // select_anime_index
    E_SHARE_ANIME_BUTTON_ACTIVE+0,              // active_anime_index
    E_SHARE_ANIME_BUTTON_PASSIVE+0,             // passive_anime_index
  }
};

// Ajf[^iʁj
const gfl::grp::g2d::LytArcIndex GraphicWork::LowerAnmIndex[E_ANMID_MAX] =
{
    LYTRES_PSS_BATTLE_RECEIVE_RES_CONNECT_LOWER_TYPE_A_BCLAN,
    LYTRES_PSS_BATTLE_RECEIVE_RES_CONNECT_LOWER_TYPE_B_BCLAN,
    LYTRES_PSS_BATTLE_RECEIVE_RES_CONNECT_LOWER_TYPE_C_BCLAN,
};

// Ajf[^iʁj
const gfl::grp::g2d::LytArcIndex GraphicWork::UpperAnmIndex[2] =
{
  LYTRES_PSS_BATTLE_RECEIVE_RES_CONNECT_UPPER_TYPE_A_BCLAN,
  LYTRES_PSS_BATTLE_RECEIVE_RES_CONNECT_UPPER_TYPE_B_BCLAN,
};


//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		heap        q[v
 * @param   layout      pCAEgVXeBNULLȂVK쐬
 * @param   messageData p郁bZ[Wf[^BNULLȂVK쐬
 * @param   wordset     p郏[hZbgBNULLȂVK쐬
 * @param   info        QƂݒ
 */
//--------------------------------------------------------------------------------------------
GraphicWork::GraphicWork( app::util::Heap * heap, gfl::grp::g2d::LytSys *layout,
                          gfl::str::MsgData *messageData, WordSet *wordset
                          ) : app::ui::UIView(heap,heap->pDevHeapAllocator,heap->pDevHeapAllocator)
{
  m_uiListener = NULL;
  m_isSetAnime = false;

	CreateGraphicsSystem( heap );
	intialize2D( heap, layout, messageData, wordset );

  // {^}l[W
  u32        paneNum      = (sizeof(BUTTON_PANE_LIST)/ sizeof(BUTTON_PANE_LIST[0]));
  CreateButtonManager( heap, GetLayoutWork(PSS_IR_MENU_LAYOUT_ID_LOWER), BUTTON_PANE_LIST, paneNum );

  // SEݒ
  m_button_manager->SetButtonSelectSE( PANENAME_CONNECT_LOWER_PANE_RETURN_ICON, FM_SE_PSS_CANCEL );

  StartAnime( E_ANMID_BTL_RECEIVE_DISP_YESNO );

	InitTextPain();

	SetInputListener( this );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
GraphicWork::~GraphicWork(void)
{
	Delete2D();
	DeleteGraphicsSystem();
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   UICxgXi̓o^
 *
 * @param   listener ʒmthCxgXi
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::SetPssIrMenuUIListener( PssIrMenuUIListener* listener )
{
  m_uiListener = listener;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Update(void)
{
  app::ui::UIView::Update();

	if( m_isSetAnime )
	{
	  if( IsAnimeEnd() )
	  {
	    StartAnime(m_nextAnime);
	    m_isSetAnime = false;
	  }
	}
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		`
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Draw(void)
{
  // LOWER
  m_g2dUtil->Draw2D( m_graphicSystem, PSS_IR_MENU_LAYOUT_ID_UPPER );
  // LOWER
  m_g2dUtil->Draw2D( m_graphicSystem, PSS_IR_MENU_LAYOUT_ID_LOWER );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   JgAj[V̏I
 *
 * @return  AjIȂtrueAAj[VȂfalseԋp
 */
//--------------------------------------------------------------------------------------------
bool GraphicWork::IsAnimeEnd( void )
{
  return m_g2dUtil->IsAnimeEnd( PSS_IR_MENU_LAYOUT_ID_LOWER, m_currentAnime );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief   Aj[V̊Jn
 *
 * @param startAnimeId JnAj[VID
 * @param nextAnimeId  ɃZbgĂAj[VID
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::StartAnime( u32 startAnimeId, u32 nextAnimeId )
{
  m_nextAnime  = nextAnimeId;
  m_isSetAnime = true;

  StartAnime(startAnimeId);
}

//--------------------------------------------------------------------------------------------
/**
 * @brief   Aj[V̊Jn
 *
 * @param animeId Aj[VID
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::StartAnime( u32 animeId )
{
  m_currentAnime = animeId;
  m_g2dUtil->StopAnime( PSS_IR_MENU_LAYOUT_ID_LOWER, animeId, false);
  m_g2dUtil->StartAnime( PSS_IR_MENU_LAYOUT_ID_LOWER, animeId );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   eLXgyC̏ݒ
 *
 * @param   none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::InitTextPain( void )
{
  // ̃[őΐ킵܂H
  SetTextboxPaneMessage( PSS_IR_MENU_LAYOUT_ID_LOWER, PANENAME_CONNECT_LOWER_PANE_TEXT_00,  msg_pss_02_01 );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		2D֘A
 *
 * @param   heap    q[v
 * @param   layout  CAEgVXe
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::intialize2D( app::util::Heap * heap, gfl::grp::g2d::LytSys *layout, gfl::str::MsgData *messageData, WordSet *wordset )
{
  // A[JCuIDe[u
  static const app::util::G2DUtil::LYT_RES_DATA resTbl[] =
  {
    { ARCID_PSS_BATTLE_RECEIVE_GRA, 0, 0 },
  };

  static const app::util::G2DUtil::LYTWK_DATA layoutData[] =
  {
    { // 
      0,                                                     // arcID
      LYTRES_PSS_BATTLE_RECEIVE_RES_CONNECT_UPPER_BCLYT,     // resID̃CAEgf[^ID
      UpperAnmIndex,                      // Aj[Vf[^IDe[u AĵȂꍇNULL
      GFL_NELEMS(UpperAnmIndex),          // Aj[Vf[^IDe[u AĵȂꍇ0
      GFL_NELEMS(UpperAnmIndex),          // o^Aj[Vő吔
      false,                              // \yCɍsvZs
      app::util::G2DUtil::SETUP_UPPER,    // fBXvC
      true,                               // \ݒ
	  },
	  {	// 
      1,
      LYTRES_PSS_BATTLE_RECEIVE_RES_CONNECT_LOWER_BCLYT,
      LowerAnmIndex,
      GFL_NELEMS(LowerAnmIndex),
      GFL_NELEMS(LowerAnmIndex),
      false,
      app::util::G2DUtil::SETUP_LOWER,
      true,
		},
	};

  if( (messageData == NULL) || (wordset == NULL) )
  {
    Create2D( heap, layout, PSS_IR_MENU_LAYOUT_ID_MAX,
                  resTbl, GFL_NELEMS(resTbl),
                  layoutData, GFL_NELEMS(layoutData),
                  GARC_message_pss_message_DAT );
  }
  else
  {
    Create2D( heap, layout, PSS_IR_MENU_LAYOUT_ID_MAX,
              resTbl, GFL_NELEMS(resTbl),
              layoutData, GFL_NELEMS(layoutData),
              messageData, wordset );
  }
}


//------------------------------------------------------------------
/**
* @brief   yCCxǧm
*
* @param  painId   ʒm󂯂yChc
*
* @return t[ł̑̓CxgȂtrueA
*         ̃CxgrȂfalseԋp邱ƁB
*/
//------------------------------------------------------------------
// @override
bool GraphicWork::OnLayoutPaneEvent( const u32 painId )
{
  if( m_uiListener != NULL )
  {
    switch( painId )
    {
      case  PANENAME_CONNECT_LOWER_PANE_RETURN_ICON:
        m_uiListener->OnSelectedReturn();
        return false;
    }
  }
  return true;
}

//------------------------------------------------------------------
/**
* @brief   L[͂̌m
*
* @param  pKey    \L[
* @param  pStick  AiOXeBbN
*
* @return t[ł̑̓CxgȂtrueA
*         ̃CxgrȂfalseԋp邱ƁB
*/
//------------------------------------------------------------------
// @override
bool GraphicWork::OnKeyAction( gfl::ui::Button* pKey, gfl::ui::VectorDevice* pStick)
{
  if( m_uiListener != NULL )
  {
    if( pKey->IsTrigger( gfl::ui::BUTTON_B ) )
    {
      m_button_manager->StartSelectedAct( PANENAME_CONNECT_LOWER_PANE_RETURN_ICON ); // {^Ƃɂ
      return false;
    }
  }
  return true;
}



}	// pss_ir_menu
}	// pss
}	// app
